; Copyright (C) 2007 Jan Vorel

; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

; This is a shared modul, class modul, usercontrol or form. It is also
; published under the GNU General Public License.

; If you have any questions, suggestions or bug reports about this product,
; contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
; language or A.P.I. issues

EnableExplicit

Import "Kernel32.lib"
  lstrlenW(ptrString.l)
  EndImport




;#QPClassName = "WinampPluginShowTitleClass"
#QPClassTitle = "Winamp"

Structure PluginInfoType
  Version.l
	Description.l
	Init.l
	Config.l
	Quit.l
	hwndParent.l
	hDllInstance.l
	EndStructure

Global PluginInfo.PluginInfoType
Global xThread.l
Global QuitThread.l
Global xQPClassWindowHWnd.l
Global CurTitleNowF.l
Global CurTitleNowFLen.l
Global CurTitleNowS.l
Global CurTitleNowSLen.l

Procedure Sleep(IntervalMS.l)
  Static xLong1.l

  xLong1 = CreateWaitableTimer_(0, -1, 0)
  While MsgWaitForMultipleObjects_(1, @xLong1, 0, IntervalMS, 255) = 0
    WindowEvent()
    Wend
  WindowEvent()
  EndProcedure

Procedure.l SMQueryString(wParam.l, MapFileID.l)
  ;Define.l xLong1
  Define.l hMapFile
  Define.l hMapFileView
  Define.l hMapFileSize
  Define.s xChar1
  Define.MEMORY_BASIC_INFORMATION xType1
  Define.l Result
  Define.l CurTitleNowX
  Define.l CurTitleNowXLen
  
  hMapFile = OpenFileMapping_(2, 0, "winampshowtitleplugin_" + Str(MapFileID))
  If hMapFile
    hMapFileView = MapViewOfFile_(hMapFile, $F001F, 0, 0, 0)
    If hMapFileView
      If VirtualQuery_(hMapFileView, @xType1, 28)
        hMapFileSize = xType1\RegionSize
        If hMapFileSize
          If wParam = 800 Or wParam = 801
            If wParam = 800
              CurTitleNowX = CurTitleNowF
              CurTitleNowXLen = CurTitleNowFLen
              Else
              CurTitleNowX = CurTitleNowS
              CurTitleNowXLen = CurTitleNowSLen
              EndIf
            If CurTitleNowFLen And CurTitleNowXLen
              If (CurTitleNowXLen + 1) * 2 => hMapFileSize
                RtlMoveMemory_(hMapFileView, CurTitleNowX, hMapFileSize)
                PokeW(hMapFileView + hMapFileSize - 2, 0)
                Result = hMapFileSize / 2 - 1
                Else
                RtlMoveMemory_(hMapFileView, CurTitleNowX, CurTitleNowXLen * 2)
                PokeW(hMapFileView + CurTitleNowXLen * 2, 0)
                Result = CurTitleNowXLen
                EndIf
              EndIf
            EndIf
          EndIf
        EndIf
      UnmapViewOfFile_(hMapFileView)
      EndIf
    CloseHandle_(hMapFile)
    EndIf
  ProcedureReturn Result
  EndProcedure


Procedure.l ProcClassWnd(hWnd.l, message.l, wParam.l, lParam.l)
  Define.l ProcClassWnd
  
  Select message
    Case 2
      ProcClassWnd = 0
    Case $111
      ProcClassWnd = SMQueryString(wParam, lParam)
    Default
      ProcClassWnd = DefWindowProc_(hWnd, message, wParam, lParam)
    EndSelect
  ProcedureReturn ProcClassWnd
  EndProcedure

Procedure MakeFilePartW()
  Define.l xLong1 = CurTitleNowF
  Define.l xLong2
  Repeat
    Select PeekW(xLong1)
      Case 0
        Break
      Case 92
        xLong2 = xLong1
      EndSelect
    xLong1 + 2
    ForEver
  If xLong2
    RtlMoveMemory_(CurTitleNowS, xLong2 + 2, xLong1 - xLong2)
    CurTitleNowSLen = (xLong1 - xLong2) / 2 - 1
    EndIf
  EndProcedure

Procedure SPThread(Param)
  Define.l HWndWinamp
  Define.WNDCLASSEX xType1
  Define.l xLong1
  Define.l xLong2
  
  With xType1
    \cbsize = SizeOf(xType1)
    \style = $83
    \lpfnWndProc = @ProcClassWnd()
    \cbClsExtra = 0
    \cbWndExtra = 0
    \hInstance = PluginInfo\hDllInstance
    \hIcon = 0
    \hCursor = LoadCursor_(0, $F00)
    \hbrBackground = 6
    \lpszMenuName = #Null ;Chr(0)
    \lpszClassName = ?lbl_ClassName
    \hIconSm = 0
    EndWith
  RegisterClassEx_(xType1)

  HWndWinamp = PluginInfo\hwndparent
  If HWndWinamp
    CurTitleNowF = AllocateMemory($208)
    If CurTitleNowF
      CurTitleNowS = AllocateMemory($208)
      If CurTitleNowS
        xQPClassWindowHWnd = CreateWindowEx_($88, ?lbl_ClassName, #QPClassTitle, $8E800000, 0, 0, 400, 35, 0, 0, PluginInfo\hDllInstance, 0)
        EndIf
      EndIf
    Repeat
      If SendMessage_(HWndWinamp, #WM_USER, 0, 104) = 1 ;isplaying
        xLong1 = SendMessage_(HWndWinamp, #WM_USER, 0, 125)
        Define.l xLong4 = SendMessage_(HWndWinamp, #WM_USER, 0, 105) ;pos/ms
        xLong2 = SendMessage_(HWndWinamp, #WM_USER, 0, 3031)
        If xLong2
          Define.l xLong3 = lstrlenW(xLong2)
          If CompareMemory(CurTitleNowF, xLong2, (xLong3 + 1) * 2) = 0 Or xLong4 < 1500
            CurTitleNowFLen = xLong3
            RtlMoveMemory_(CurTitleNowF, xLong2, (xLong3 + 1) * 2)
            MakeFilePartW()
            EndIf
          Else
          CurTitleNowFLen = 0
          EndIf
        Else
        CurTitleNowFLen = 0
        EndIf

      Sleep(500)
      Until QuitThread
    If xQPClassWindowHWnd
      DestroyWindow_(xQPClassWindowHWnd)
      UnregisterClass_(?lbl_ClassName, PluginInfo\hDllInstance)
      EndIf
    EndIf


  LockMutex(QuitThread)
  xThread = 0
  UnlockMutex(QuitThread)
  EndProcedure

Procedure.w Init()
  xThread = CreateThread(@SPThread(), 0)
  EndProcedure

Procedure Config()
  EndProcedure

Procedure Quit()
  QuitThread = CreateMutex()
  Repeat
    LockMutex(QuitThread)
    If xThread = 0
      UnlockMutex(QuitThread)
      Break
      Else
      Sleep_(100)
      UnlockMutex(QuitThread)
      EndIf
    ForEver
  FreeMutex(QuitThread)
  EndProcedure

ProcedureCDLL.l winampGetGeneralPurposePlugin()
  PluginInfo\Version = $10
  PluginInfo\Description = ?lbl_Description
  PluginInfo\Init = @Init()
  PluginInfo\Config = @Config()
  PluginInfo\Quit = @Quit()
  ProcedureReturn @PluginInfo
  EndProcedure
 
DataSection
  lbl_Description:
  Data.s "GetWinampTitle 1.00.2007.0911"
  lbl_ClassName:
  Data.s "WinampShowTitlePluginClass"
  EndDataSection
; IDE Options = PureBasic v4.02 (Windows - x86)
; ExecutableFormat = Shared Dll
; CursorPosition = 127
; FirstLine = 112
; Folding = --
; Executable = gen_GetTitle.dll
; DisableDebugger
; AddResource = D:\DEV\Software\Libraries\Winamp\Plugins\gen_GetTitle.rc