; Copyright (C) 2007 Jan Vorel

; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

; This is a shared modul, class modul, usercontrol or form. It is also
; published under the GNU General Public License.

; If you have any questions, suggestions or bug reports about this product,
; contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
; language or A.P.I. issues

EnableExplicit

Import "Kernel32.lib"
  lstrlenW(ptrString.l)
  EndImport
Import "GDI32.lib"
  TextOutW(DC.l, X.l, Y.l, ptrString.l, LenString.l)
  EndImport



;#QPClassName = "WinampPluginShowTitleClass"
#QPClassTitle = "Winamp"
#ShowIRTicksFull = 5000

Structure PluginInfoType
  Version.l
	Description.l
	Init.l
	Config.l
	Quit.l
	hwndParent.l
	hDllInstance.l
	EndStructure

Global PluginInfo.PluginInfoType

Global xQPClassWindowHWnd.l
Global ShowIRWin.l
Global ShowIRTicks.l
Global ShowIR_DC.l
Global ShowIR_IconHWnd.l
Global ShowIR_Width.l
Global CurTitleNowF.l
Global CurTitleNowFLen.l
Global CurTitleNowS.l
Global CurTitleNowSLen.l
;Global CanUnicode
Global HWndWinamp.l

Global xQPClassAlign.l
#DoEventsEx_TimerAND = 1073741823    ; 3fffffff
#DoEventsEx_TimerANDMOD = 1073741823 ; 4000000

Procedure.l DoEventsEx_IsTickCountElapsed(FirstTickCountValue.l, TimeIntervalMs.l)
  Define.l xLong1

  xLong1 = GetTickCount_() & #DoEventsEx_TimerAND
  If xLong1 < FirstTickCountValue
    If (xLong1 + #DoEventsEx_TimerANDMOD > FirstTickCountValue + TimeIntervalMs)
      ProcedureReturn 1
      EndIf
    Else
    If (xLong1 > FirstTickCountValue + TimeIntervalMs)
      ProcedureReturn 1
      EndIf
    EndIf
  EndProcedure

Procedure.l LoadResEx_IsHighColor()
  Define.l xLong1

  xLong1 = GetDC_(0)
  If xLong1
    If GetDeviceCaps_(xLong1, 12) > 15
      ReleaseDC_(0, xLong1)
      ProcedureReturn 1
      EndIf
    ReleaseDC_(0, xLong1)
    EndIf
  EndProcedure

Procedure GetWhiteBackGrnd()
  SetTextColor_(ShowIR_DC, GetSysColor_(8))
  SetBkColor_(ShowIR_DC, GetSysColor_(5))
  EndProcedure

Procedure.l SMQueryString(wParam.l, MapFileID.l)
  ;Define.l xLong1
  Define.l hMapFile
  Define.l hMapFileView
  Define.l hMapFileSize
  Define.s xChar1
  Define.MEMORY_BASIC_INFORMATION xType1
  Define.l Result
  Define.l CurTitleNowX
  Define.l CurTitleNowXLen
  
  hMapFile = OpenFileMapping_(2, 0, "winampshowtitleplugin_" + Str(MapFileID))
  If hMapFile
    hMapFileView = MapViewOfFile_(hMapFile, $F001F, 0, 0, 0)
    If hMapFileView
      If VirtualQuery_(hMapFileView, @xType1, 28)
        hMapFileSize = xType1\RegionSize
        If hMapFileSize ;> CanUnicode
          If wParam = 800 Or wParam = 801
            If wParam = 800
              CurTitleNowX = CurTitleNowF
              CurTitleNowXLen = CurTitleNowFLen
              Else
              CurTitleNowX = CurTitleNowS
              CurTitleNowXLen = CurTitleNowSLen
              EndIf
            If CurTitleNowFLen And CurTitleNowXLen
              If (CurTitleNowXLen + 1) * 2 => hMapFileSize
                Result = hMapFileSize / 2 - 1
                Else
                Result = CurTitleNowXLen
                EndIf
              RtlMoveMemory_(hMapFileView, CurTitleNowX, CurTitleNowXLen * 2)
              PokeW(hMapFileView + CurTitleNowXLen * 2, 0)
              EndIf
            EndIf
          EndIf
        EndIf
      UnmapViewOfFile_(hMapFileView)
      EndIf
    CloseHandle_(hMapFile)
    EndIf
  ProcedureReturn Result
  EndProcedure

Declare ShowIR_Do()
Declare HideIRWin()


Procedure MakeFilePartW()
  Define.l xLong1 = CurTitleNowF
  Define.l xLong2
  Repeat
    Select PeekW(xLong1)
      Case 0
        Break
      Case 92
        xLong2 = xLong1
      EndSelect
    xLong1 + 2
    ForEver
  If xLong2
    RtlMoveMemory_(CurTitleNowS, xLong2 + 2, xLong1 - xLong2)
    CurTitleNowSLen = (xLong1 - xLong2) / 2 - 1
    EndIf
  EndProcedure

Procedure ReInterface()
  Define.l WinStateMin.l
  Define.l xLong1
  Define.RECT xType1
  Define.POINT xType2
  ;Static xQPClassAlign.l
  #xBarHeight = 35
  #xBarHeightX2 = #xBarHeight * 2.5
  #xBarHeightX3 = #xBarHeight * 4










  WinStateMin = IsIconic_(HWndWinamp)
  If SendMessage_(HWndWinamp, #WM_USER, 0, 104) = 1 ;isplaying
    Define.l xLong4 = SendMessage_(HWndWinamp, #WM_USER, 0, 105) ;pos/ms
    xLong1 = SendMessage_(HWndWinamp, #WM_USER, 0, 3031)
    If xLong1
      Define.l xLong3 = lstrlenW(xLong1)
      If xLong4 > 1500 Or (xLong3 = CurTitleNowFLen)
        If CompareMemory(CurTitleNowF, xLong1, (xLong3 + 1) * 2) = 0 Or xLong4 < 1500 Or (Not xLong3 = CurTitleNowFLen)
LblSame1:
          CurTitleNowFLen = xLong3
          RtlMoveMemory_(CurTitleNowF, xLong1, (xLong3 + 1) * 2)
          MakeFilePartW()
          If WinStateMin
            ShowIR_Do()
            EndIf
          EndIf
        Else
        Goto LblSame1
        EndIf
      Else
      CurTitleNowFLen = 0
      EndIf
    Else
    CurTitleNowFLen = 0
    EndIf
  If ShowIRWin
    If WinStateMin = 0 Or CurTitleNowFLen = 0 Or DoEventsEx_IsTickCountElapsed(ShowIRTicks, #ShowIRTicksFull)
      HideIRWin()
      Else
      GetWindowRect_(GetDesktopWindow_(), xType1)
      xType2\Y = xType1\Bottom
      GetCursorPos_(xType2)
      If xType2\Y < #xBarHeightX2
        xLong1 = 2
        Else
        xLong1 = 1
        EndIf
      If Not xLong1 = xQPClassAlign
        If xLong1 = 2
          SetWindowPos_(xQPClassWindowHWnd, 0, 0, #xBarHeightX3, xType1\Right, #xBarHeight, $214)
          Else
          SetWindowPos_(xQPClassWindowHWnd, 0, 0, 0, xType1\Right, #xBarHeight, $214)
          EndIf
        xQPClassAlign = xLong1
        EndIf
      If ShowIR_IconHWnd = 0
        ShowIR_Width = xType1\Right - 4
        Else
        ShowIR_Width = xType1\Right - 44
        EndIf
      EndIf
    EndIf
  EndProcedure


Procedure.l ProcClassWnd(hWnd.l, message.l, wParam.l, lParam.l)
  Define.l ProcClassWnd
  
  Select message
    Case $113 ;Const WM_TIMER = &H113
      ReInterface()
    Case 2 ;Forgotten :)
      ProcClassWnd = 0
    Case $F ;& 'WM_PAINT = &HF
      If ShowIR_DC
        If ShowIR_IconHWnd = 0
          TextOutW(ShowIR_DC, 4, 0, CurTitleNowS, CurTitleNowSLen)
          Else
          DrawIcon_(ShowIR_DC, 4, 0, ShowIR_IconHWnd)
          TextOutW(ShowIR_DC, 40, 0, CurTitleNowS, CurTitleNowSLen)
          EndIf
        EndIf
      ProcClassWnd = DefWindowProc_(hWnd, message, wParam, lParam)
    Case $15 ; syscolorchange
      If ShowIR_DC
        GetWhiteBackGrnd()
        EndIf
;        ProcClassWnd = DefWindowProc_(hWnd, message, wParam, lParam)
    Case $111
      ProcClassWnd = SMQueryString(wParam, lParam)
    Default
      ProcClassWnd = DefWindowProc_(hWnd, message, wParam, lParam)
    EndSelect
  ProcedureReturn ProcClassWnd
  EndProcedure

Procedure ShowIR_Do()
  If xQPClassWindowHWnd
    If ShowIRWin
      ShowIRTicks = GetTickCount_() & #DoEventsEx_TimerAND
      If ShowIR_DC
        SendMessage_(xQPClassWindowHWnd, $14, ShowIR_DC, 0)
        SendMessage_(xQPClassWindowHWnd, $F, ShowIR_DC, 0)
        EndIf
      Else ;If Not Passive
      ShowIRWin = #True
      ReInterface()
      ShowIRTicks = GetTickCount_() & #DoEventsEx_TimerAND
      ShowWindow_(xQPClassWindowHWnd, $4)
      SetWindowPos_(xQPClassWindowHWnd, -1, 0, 0, 0, 0, $213)
      EndIf
    EndIf
  EndProcedure

Procedure HideIRWin()
  ShowIRWin = #False
  ShowWindow_(xQPClassWindowHWnd, 0)
  xQPClassAlign = 0
  EndProcedure

Procedure.w Init()
  Define.WNDCLASSEX xType1
  Define.l xLong1

  With xType1
    \cbsize = SizeOf(xType1)
    \style = $83
    \lpfnWndProc = @ProcClassWnd()
    \cbClsExtra = 0
    \cbWndExtra = 0
    \hInstance = PluginInfo\hDllInstance
    \hIcon = 0
    \hCursor = LoadCursor_(0, $F00)
    \hbrBackground = 6
    \lpszMenuName = #Null ;Chr(0)
    \lpszClassName = ?lbl_ClassName
    \hIconSm = 0
    EndWith
  RegisterClassEx_(xType1)

  HWndWinamp = PluginInfo\hwndparent
  If HWndWinamp
    CurTitleNowF = AllocateMemory($208)
    If CurTitleNowF
      CurTitleNowS = AllocateMemory($208)
      If CurTitleNowS
        xQPClassWindowHWnd = CreateWindowEx_($88, ?lbl_ClassName, #QPClassTitle, $8E800000, 0, 0, 400, 35, 0, 0, PluginInfo\hDllInstance, 0)
        If xQPClassWindowHWnd
          ShowIR_DC = GetDC_(xQPClassWindowHWnd)
          If ShowIR_DC
            xLong1 = CreateFont_(-32, 0, 0, 0, 700, 0, 0, 0, 0, 0, 0, 0, 0, "MS Sans Serif")
            If xLong1
              xLong1 = SelectObject_(ShowIR_DC, xLong1)
              If xLong1
                DeleteObject_(xLong1)
                EndIf
              EndIf
            If LoadResEx_IsHighColor()
              ShowIR_IconHWnd = LoadImage_(PluginInfo\hDllInstance, "#101", 1, 32, 32, $8000)
              EndIf
            If ShowIR_IconHWnd = 0
              ShowIR_IconHWnd = LoadImage_(PluginInfo\hDllInstance, "#100", 1, 32, 32, $8000)
              EndIf
            GetWhiteBackGrnd()
            SetTimer_(xQPClassWindowHWnd, 3, 150, @ProcClassWnd())
            EndIf
          EndIf
        EndIf
      EndIf
    EndIf
  EndProcedure

Procedure Config()
  EndProcedure

Procedure Quit()
  If xQPClassWindowHWnd
    If ShowIRWin
      ShowIRWin = #False
      EndIf

    If ShowIR_DC
      ReleaseDC_(xQPClassWindowHWnd, ShowIR_DC)
      KillTimer_(xQPClassWindowHWnd, 3)
      EndIf
    DestroyWindow_(xQPClassWindowHWnd)
    If ShowIR_IconHWnd
      DeleteObject_(ShowIR_IconHWnd)
      EndIf
    

    
    ;xQPClassWindowHWnd = 0
    UnregisterClass_(?lbl_ClassName, PluginInfo\hDllInstance)
    EndIf
  EndProcedure

ProcedureCDLL.l winampGetGeneralPurposePlugin()
  PluginInfo\Version = $10
  PluginInfo\Description = ?lbl_Description
  PluginInfo\Init = @Init()
  PluginInfo\Config = @Config()
  PluginInfo\Quit = @Quit()
  ProcedureReturn @PluginInfo
  EndProcedure
 
DataSection
  lbl_Description:
  Data.s "Show title 1.00.2007.0912"
  lbl_ClassName:
  Data.s "WinampShowTitlePluginClass"
  EndDataSection
; IDE Options = PureBasic v4.02 (Windows - x86)
; ExecutableFormat = Shared Dll
; CursorPosition = 384
; FirstLine = 354
; Folding = ---
; Executable = gen_ShowTitle.dll
; DisableDebugger
; AddResource = D:\Dev\Software\Libraries\Winamp\Plugins\gen_ShowTitle.rc