EnableExplicit

#ctExtractor_Mode = 0 ; 0 = cmd, 1 = simplelist, 2 = explorerlike
#ctExtractor_Filter = 1 ;

Declare SetPosition64(PosLo.l, PosHi.l)
Declare ctExtractor_ErrorQuit_OutOfMem()

Import "kernel32.lib"
  CreateDirectoryW(*ptrPath, *SecAttr)
  CreateFileW(*lpFilename, *dwDesiredAccess, *dwShareMode, *lpSecurityAttributes, *dwCreationDistribution, *dwFlagsAndAttributes, *hTemplateFile)
  SetConsoleTitleW(*lpTitleW)
  WriteConsoleW(*hConsole, *MsgW, *LenMsg, *RetBytes, *Reserved)
  lstrlenW(*ptrWide)
  EndImport

Procedure.l ctExtractor_MemAlloc(Size.l)
  Define *Mem = LocalAlloc_(#LMEM_ZEROINIT, Size + 3)
  If *Mem = 0
    ctExtractor_ErrorQuit_OutOfMem()
    EndIf
  ProcedureReturn 
  EndProcedure
Macro       ctExtractor_MemFree(Mem)
  LocalFree_(Mem)
  EndMacro
Procedure.l ctExtractor_Str_AnsiFromWide(*ptrWide)
  Define *Mem
  Define.l xLong1 = lstrlenW(*ptrWide)

  If xLong1
    *Mem = ctExtractor_MemAlloc(xLong1 + 1)
    If *Mem
      If WideCharToMultiByte_(0, 0, *ptrWide, xLong1, *Mem, xLong1, 0, 0)
        ProcedureReturn *Mem
        EndIf
      ctExtractor_MemFree(*Mem)
      EndIf
    EndIf
  EndProcedure
Procedure.l ctExtractor_Str_WideFromAnsi(*ptrAnsi)
  Define *Mem
  Define.l xLong1 = lstrlen_(*ptrAnsi)

  If xLong1
    *Mem = ctExtractor_MemAlloc((xLong1 + 1) * 2)
    If *Mem
      If MultiByteToWideChar_(0, 0, *ptrAnsi, xLong1, *Mem, xLong1)
        ProcedureReturn *Mem
        EndIf
      ctExtractor_MemFree(*Mem)
      EndIf
    EndIf
  EndProcedure

DataSection
  SpacesX79:
    !DB "                                                                               ", 0
;  Analyzing1:
;    !DB " "
;  Analyzing2:
;    !DB "* Analyzing ("
;  Analyzing3:
;    !DB "xxx%)", 0

  TotalSizeL:
    !TotalSizeL DD 0
  TotalSizeH:
    !TotalSizeH DD 0
  !DoneSizeL DD 0
  !DoneSizeH DD 0

  PathX1:
    !PathX1 DU "_extract"
  PathX2:
    !PathX2:
      !RB 2 ;DU "\"
  PathX3:
    !PathX3 RB 512
  PathX4:
    !PathX4 RB 270
  FreeSizeL:
    !FreeSizeL RD 1
  FreeSizeH:
    !FreeSizeH RD 1
  TempDW1:
    !TempDW1 RD 1
    !TempDW2 RD 1
;  TempDW3:
;    !TempDW3 RD 1
;    !TempDW4 RD 1
  EndDataSection

Procedure   ctExtractor_InitW(*lpTitleW)
  Structure ctExtractor_FileInfo
    hFile.l
    FileNamePathW.l
    PositionLo.l
    PositionHi.l
    Size.l
    ProcHandle.l
    EndStructure

  Global IsUnicode.l
  Global hConsole.l
  Global ctExtractor_hFileCurrent.l
  Global ctExtractor_SizeHCurrent.l
  Global ctExtractor_SizeLCurrent.l
  Global NewList ctExtractor_Queue.ctExtractor_FileInfo()
  Global ctExtractor_QueueCount.l
  Define *Mem

  hConsole = GetStdHandle_(-11)
  If hConsole
    SetConsoleMode_(hConsole, #ENABLE_PROCESSED_OUTPUT); | #ENABLE_WRAP_AT_EOL_OUTPUT) ;#ENABLE_LINE_INPUT
    EndIf
  
  GetVersion_()
  AND eax, $800000ff
  CMP eax, $80000004
  JZ IsAnsi
  IsUnicode = 1
!IsAnsi:

  If IsUnicode
    SetConsoleTitleW(*lpTitleW)
    Else
    *Mem = ctExtractor_Str_AnsiFromWide(*lpTitleW)
    If *Mem
      SetConsoleTitle_(*Mem)
      ctExtractor_MemFree(*Mem)
      EndIf
    EndIf
  EndProcedure

Procedure   ctExtractor_InitA(*lpTitleA)
  Define *Mem = ctExtractor_Str_WideFromAnsi(*lpTitleA)
  ctExtractor_InitW(*Mem)
  If *Mem
    ctExtractor_MemFree(*Mem)
    EndIf
  EndProcedure

Procedure   ctExtractor_Close()
  Sleep_(8000)
  End
  EndProcedure

;Procedure.l ctExtractor_PrintEx(*MsgA, NumBytes)
;CONSOLE_SCREEN_BUFFER_INFO 

Procedure.l ctExtractor_PrintBytes(*Bytes, NumBytes)
  Define.l xLong1
  If hConsole
    WriteConsole_(hConsole, *Bytes, NumBytes, @xLong1, 0)
    EndIf
  EndProcedure

Procedure.l ctExtractor_PrintW(*MsgW)
  Define *Mem
  Define.l xLong1
  If hConsole
    If *MsgW
      If IsUnicode
        WriteConsoleW(hConsole, *MsgW, lstrlenW(*MsgW), @xLong1, 0)
        Else
        *Mem = ctExtractor_Str_AnsiFromWide(*MsgW)
        If *Mem
          WriteConsole_(hConsole, *Mem, lstrlen_(*Mem), @xLong1, 0)
          ctExtractor_MemFree(*Mem)
          EndIf
        EndIf
      EndIf
    EndIf
  EndProcedure

Procedure.l ctExtractor_PrintA(*MsgA)
  Define.l xLong1
  WriteConsole_(hConsole, *MsgA, lstrlen_(*MsgA), @xLong1, 0)
  EndProcedure

Procedure.l ctExtractor_PrintRA(*MsgA)
  ctExtractor_PrintA(*MsgA)
  Define.l xLong1 = $0d
  ctExtractor_PrintBytes(@xLong1, 1)
  EndProcedure

Procedure.l ctExtractor_PrintRW(*MsgW)
  ctExtractor_PrintW(*MsgW)
  Define.l xLong1 = $0d
  ctExtractor_PrintBytes(@xLong1, 2)
  EndProcedure

Procedure.l ctExtractor_PrintNA(*MsgA)
  ctExtractor_PrintA(*MsgA)
  Define.l xLong1 = $0d0a
  ctExtractor_PrintBytes(@xLong1, 2)
  EndProcedure

Procedure.l ctExtractor_PrintNW(*MsgW)
  ctExtractor_PrintA(*MsgW)
  Define.l xLong1 = $0d000a
  ctExtractor_PrintBytes(@xLong1, 4)
  EndProcedure

Procedure.l ctExtractor_PrintCL()
  ctExtractor_PrintRA(?SpacesX79)
  EndProcedure

;Procedure.l ctExtractor_Print(*MsgA)
;  ctExtractor_PrintEx(*MsgA, lstrlen_(*MsgA))
;  EndProcedure

Procedure   ctExtractor_ErrorQuitA(*MsgA)
;  ctExtractor_SetColor(4, 0)
  ctExtractor_PrintCL()
  ctExtractor_PrintNA(*MsgA)
  ctExtractor_Close()
  EndProcedure

Procedure   ctExtractor_ErrorQuit_CannotOpenFile()
  ctExtractor_ErrorQuitA(@"Failed to open file")
  EndProcedure

Procedure   ctExtractor_ErrorQuit_OutOfMem()
  ctExtractor_ErrorQuitA(@"Failed to allocate Memory")
  EndProcedure

Procedure.l ctExtractor_RawReadAllocBytes(NumBytes)
  Define.l xLong1

  Define *Mem = LocalAlloc_(0, NumBytes + 3)
  If *Mem
    If ReadFile_(ctExtractor_hFileCurrent, *Mem, NumBytes, @xLong1, 0)
      If NumBytes = xLong1
        ProcedureReturn *Mem
        EndIf
      EndIf
    ctExtractor_ErrorQuitA(@"Failed to read requested number of bytes")
    Else
    ctExtractor_ErrorQuit_OutOfMem()
    EndIf
  EndProcedure

Procedure.l ctExtractor_OpenFileW(*lpFilenameW, OpenMode.l, AccessMode.l)
  Define.l Result
  Define *Mem

  If *lpFilenameW
    If IsUnicode
      Result = CreateFileW(*lpFilenameW, AccessMode, 1, 0, OpenMode, 0, 0)
      Else
      *Mem = ctExtractor_Str_AnsiFromWide(*lpFilenameW)
      If *Mem
        Result = CreateFile_(*Mem, AccessMode, 1, 0, OpenMode, 0, 0)
        ctExtractor_MemFree(*Mem)
        EndIf
      EndIf
    If Result = -1
      ctExtractor_ErrorQuit_CannotOpenFile()
      EndIf
    ProcedureReturn Result
    EndIf
  EndProcedure
Procedure.l ctExtractor_OpenFileA(*lpFilenameA, OpenMode.l, AccessMode.l)
  Define.l Result
  Define *Mem

  If *lpFilenameA
    If IsUnicode
      *Mem = ctExtractor_Str_WideFromAnsi(*lpFilenameA)
      If *Mem
        Result = CreateFileW(*Mem, AccessMode, 1, 0, OpenMode, 0, 0)
        ctExtractor_MemFree(*Mem)
        EndIf
      Else
      Result = CreateFile_(*lpFilenameA, AccessMode, 1, 0, OpenMode, 0, 0)
      EndIf
    If Result = -1
      ctExtractor_ErrorQuit_CannotOpenFile()
      EndIf
    ProcedureReturn Result
    EndIf
  EndProcedure

Procedure ctExtractor_Archive_AddFileW(*lpFilenameW, PositionLo.l, PositionHi.l, Size.l, *ProcHandle, lParam, Flags.l, Process.f)
  Define.l xLong1
  Static xLong2.l
  Define.s xChar1

  If *lpFilenameW
    AddElement(ctExtractor_Queue())
    With ctExtractor_Queue()
      \hFile = ctExtractor_hFileCurrent
      \FileNamePathW = *lpFilenameW
      \PositionLo = PositionLo
      \PositionHi = PositionHi
      \Size = Size
      \ProcHandle = *ProcHandle
      EndWith
    ctExtractor_QueueCount = ctExtractor_QueueCount + 1
;xChar1 = PeekS(*lpFilenameW, -1, #PB_Unicode) + ": " + Hex(Position) + " / " + Hex(Size)
;ctExtractor_PrintNA(@xChar1)
    
    MOV eax, Size
    ADD [TotalSizeL], eax
    ADC [TotalSizeH], 0
    EndIf

  xLong1 = GetTickCount_() & $ffffff80
  If Not xLong1 = xLong2
    Select (xLong1 & $180) >> 7
      Case 0: xLong2 = 92  ; \
      Case 1: xLong2 = 124 ; |
      Case 2: xLong2 = 47  ; /
      Case 3: xLong2 = 45  ; -
      EndSelect
    xChar1 = " " + Chr(xLong2) + " Analyzing (" + Str(Round(Process * 100 + 0.5, 0)) + "%)"
    ctExtractor_PrintRA(@xChar1)
    xLong2 = xLong1
    EndIf
  EndProcedure

Procedure ctExtractor_Archive_AddFileA(*lpFilenameA, PositionLo.l, PositionHi.l, Size.l, *ProcHandle, Flags.l, Process.f)
  Define *Mem

  If *lpFilenameA
    *Mem = ctExtractor_Str_WideFromAnsi(*lpFilenameA)
;Define.s xChar1 = PeekS(*lpFilenameA) + ": " + Hex(Position) + " / " + Hex(Size)
;ctExtractor_PrintNA(@xChar1)
    ctExtractor_Archive_AddFileW(*Mem, PositionLo, PositionHi, Size, *ProcHandle, 0, Flags, Process)
    ctExtractor_MemFree(*lpFilenameA)
    EndIf
  EndProcedure

Procedure.l ctExtractor_FastExtensionW(*ptrFilenameW)
  MOV eax, *ptrFilenameW
  XOR edx, edx

!ctExtractor_FastExtensionW_DoLoop:
  MOV cx, [eax]
  CMP cx, 92
  JE ctExtractor_FastExtensionW_PathPos
  CMP cx, 46
  JE ctExtractor_FastExtensionW_ExtPos
  OR cx, cx
  JE ctExtractor_FastExtensionW_UnLoop
  
!ctExtractor_FastExtensionW_NoPos:
  INC eax
  INC eax
  JMP ctExtractor_FastExtensionW_DoLoop

!ctExtractor_FastExtensionW_ExtPos:
  MOV edx, eax
  JMP ctExtractor_FastExtensionW_NoPos

!ctExtractor_FastExtensionW_PathPos:
  XOR edx, edx
  JMP ctExtractor_FastExtensionW_NoPos

!ctExtractor_FastExtensionW_UnLoop:
  XOR eax, eax
  OR edx, edx
  JZ ctExtractor_FastExtensionW_NoExt

  PUSH ebx
  XOR ebx, ebx
!ctExtractor_FastExtensionW_DoLoop2:
  INC edx
  INC edx
  MOV cx, [edx]
  OR cx, cx
  JE ctExtractor_FastExtensionW_UnLoop2
  TEST cx, $ff80
  JNZ ctExtractor_FastExtensionW_UnLoop2Fail
  CMP cl, 97
  JB ctExtractor_FastExtensionW_NoCase
  CMP cl, 122
  JA ctExtractor_FastExtensionW_NoCase
  BTR cx, 5
!ctExtractor_FastExtensionW_NoCase:
  INC ebx
  SHL eax, 8
  MOV al, cl
  JMP ctExtractor_FastExtensionW_DoLoop2
  
  XOR eax, eax
!ctExtractor_FastExtensionW_UnLoop2:
  ;BSWAP eax
  CMP ebx, 4
  JE ctExtractor_FastExtensionW_IsOk
  JB ctExtractor_FastExtensionW_DoLoop4

!ctExtractor_FastExtensionW_UnLoop2Fail:
  XOR eax, eax
  JMP ctExtractor_FastExtensionW_IsNotOk

!ctExtractor_FastExtensionW_DoLoop4:
  SHL eax, 8
  INC ebx
  CMP ebx, 4
  JB ctExtractor_FastExtensionW_DoLoop4

!ctExtractor_FastExtensionW_IsOk:
  BSWAP eax
!ctExtractor_FastExtensionW_IsNotOk:
  POP ebx
  ;MOV xLong1, eax
!ctExtractor_FastExtensionW_NoExt:
  ProcedureReturn
  EndProcedure

Procedure.l ctExtractor_FastExtensionA(*ptrFilenameA)
  MOV eax, *ptrFilenameA
  XOR edx, edx

!ctExtractor_FastExtensionA_DoLoop:
  MOV cl, [eax]
  CMP cl, 92
  JE ctExtractor_FastExtensionA_PathPos
  CMP cl, 46
  JE ctExtractor_FastExtensionA_ExtPos
  OR cl, cl
  JE ctExtractor_FastExtensionA_UnLoop
  
!ctExtractor_FastExtensionA_NoPos:
  INC eax
  JMP ctExtractor_FastExtensionA_DoLoop

!ctExtractor_FastExtensionA_ExtPos:
  MOV edx, eax
  JMP ctExtractor_FastExtensionA_NoPos

!ctExtractor_FastExtensionA_PathPos:
  XOR edx, edx
  JMP ctExtractor_FastExtensionA_NoPos

!ctExtractor_FastExtensionA_UnLoop:
  XOR eax, eax
  OR edx, edx
  JZ ctExtractor_FastExtensionA_NoExt

  PUSH ebx
  XOR ebx, ebx
!ctExtractor_FastExtensionA_DoLoop2:
  INC edx
  MOV cl, [edx]
  OR cl, cl
  JE ctExtractor_FastExtensionA_UnLoop2
  TEST cl, $80
  JNZ ctExtractor_FastExtensionA_UnLoop2Fail
  CMP cl, 97
  JB ctExtractor_FastExtensionA_NoCase
  CMP cl, 122
  JA ctExtractor_FastExtensionA_NoCase
  BTR cx, 5
!ctExtractor_FastExtensionA_NoCase:
  INC ebx
  SHL eax, 8
  MOV al, cl
  JMP ctExtractor_FastExtensionA_DoLoop2
  
  XOR eax, eax
!ctExtractor_FastExtensionA_UnLoop2:
  ;BSWAP eax
  CMP ebx, 4
  JE ctExtractor_FastExtensionA_IsOk
  JB ctExtractor_FastExtensionA_DoLoop4

!ctExtractor_FastExtensionA_UnLoop2Fail:
  XOR eax, eax
  JMP ctExtractor_FastExtensionA_IsNotOk

!ctExtractor_FastExtensionA_DoLoop4:
  SHL eax, 8
  INC ebx
  CMP ebx, 4
  JB ctExtractor_FastExtensionA_DoLoop4

!ctExtractor_FastExtensionA_IsOk:
  BSWAP eax
!ctExtractor_FastExtensionA_IsNotOk:
  POP ebx
  ;MOV xLong1, eax
  ;PokeL(@xLong1, xLong1)
  ;Debug PeekS(xLong1)
  ;Debug Hex(xLong1)
!ctExtractor_FastExtensionA_NoExt:
  ProcedureReturn
  EndProcedure

Procedure.l ctExtractor_IsExtension(*Extension, *ExtensionList)
  MOV ecx, *Extension
  MOV edx, *ExtensionList
!DoLoop3:
  MOV eax, [edx]
  OR eax, eax
  JZ UnLoop3
  ADD edx, 4
  CMP eax, ecx
  JNE DoLoop3

!UnLoop3:
  ProcedureReturn
  EndProcedure

Procedure ctExtractor_Process_Mem()
  Define.l xLong1
  Define.l xLong2
  Define.s xChar1

  MOV ecx, [TotalSizeH]
  MOV edx, [TotalSizeL]
  SHR edx, 20
  SHL ecx, 12
  OR ecx, edx
  INC ecx
  MOV [TotalSizeL], ecx

  !PLoop:
  GetDiskFreeSpaceEx_(0, ?FreeSizeL, ?TempDW1, 0)

  MOV ecx, [FreeSizeH]
  TEST ecx, $fff0000
  JNZ PUnLoop

  MOV edx, [FreeSizeL]
  SHR edx, 20
  SHL ecx, 12
  OR ecx, edx

  MOV edx, [TotalSizeL]
;MOV xLong2, edx ; total size / job
;MOV xLong3, ecx ; free  size / hdd
;(xLong2, xLong3)
;MOV edx, xLong2 ; total size / job
;MOV ecx, xLong3 ; free  size / hdd
  CMP ecx, edx
  JAE PUnLoop
  SUB edx, ecx
  MOV xLong2, ecx
  If Not xLong1 = xLong2
    xLong1 = xLong2
    xChar1 = "Please free another " + Str(xLong1) + " MB"
    ctExtractor_PrintRA(@xChar1)
    EndIf
  Sleep_(2000)
  JMP PLoop

  !PUnLoop:
  ctExtractor_PrintCL()
  EndProcedure

Procedure ctExtractor_Process()
  Define.l xLong1
  Define.l xLong2
  Define.l xLong3
  Define.l xLong4
  Define *Mem

  ctExtractor_Process_Mem()


  If IsUnicode
    CreateDirectoryW(?PathX1, 0)
    Else
    WideCharToMultiByte_(0, 0, ?PathX1, -1, ?PathX4, 270, 0, 0)
;Debug "DIR1: " + PeekS(?PathX4)
    CreateDirectory_(?PathX4, 0)
    EndIf
  
  MOV [PathX2], word 92
  ;xLong1 = 0
  ForEach ctExtractor_Queue()
    With ctExtractor_Queue()
      ctExtractor_PrintRA(@"Processing ")
      ctExtractor_PrintW(\FileNamePathW)
      ctExtractor_PrintNA(@"...")

      xLong1 = lstrlenW(\FileNamePathW) * 2
      RtlMoveMemory_(?PathX3, \FileNamePathW, xLong1)
      xLong1 + ?PathX3
      MOV eax, PathX2
      MOV ecx, xLong1
      MOV [ecx], word 0

;WideCharToMultiByte_(0, 0, ?PathX1, -1, ?PathX4, 270, 0, 0)
;Debug "DIR0: " + PeekS(?PathX4)

      
!MDLoop:
      INC eax
      INC eax
      CMP eax, ecx
      JE MDDoneLoop
      CMP [eax], word 92
      JNE MDLoop
      
      MOV [eax], byte 0
      MOV xLong2, eax
      
      If IsUnicode
        CreateDirectoryW(?PathX1, 0)
        Else
        WideCharToMultiByte_(0, 0, ?PathX1, -1, ?PathX4, 270, 0, 0)
;Debug "DIR2: " + PeekS(?PathX4)
        CreateDirectory_(?PathX4, 0)
        EndIf
;Sleep_(100)

      
      MOV eax, xLong2
      MOV [eax], byte 92
      MOV ecx, xLong1
      JMP MDLoop
      
!MDDoneLoop:
      ;MOV [PathX2], byte 92
      If IsUnicode
        ;CreateDirectoryW(?PathX1, 0)
        xLong3 = CreateFileW(?PathX1, #GENERIC_WRITE, 1, 0, #CREATE_ALWAYS, 0, 0)
        Else
        WideCharToMultiByte_(0, 0, ?PathX1, -1, ?PathX4, 270, 0, 0)
;Debug "OFil: " + PeekS(\FileNamePathW, -1, #PB_Unicode)
;Debug "File: " + PeekS(?PathX4)
        xLong3 = CreateFile_(?PathX4, #GENERIC_WRITE, 1, 0, #CREATE_ALWAYS, 0, 0)
        EndIf
      If xLong3 = -1
        ctExtractor_ErrorQuitA(@"Failed to create file")
        EndIf


      ctExtractor_hFileCurrent = \hFile
      SetPosition64(\PositionLo, \PositionHi)
      *Mem = ctExtractor_RawReadAllocBytes(\Size)
;Debug "Pre: " + Str(*Mem)
      If (\ProcHandle)
;Debug "   " + PeekS(*Mem, 16)
        *Mem = CallFunctionFast(\ProcHandle, *Mem, @\Size, 0, 0)
;Debug "   " + PeekS(*Mem, 16)
        EndIf
;Debug "Post: " + Str(*Mem)
      If WriteFile_(xLong3, *Mem, \Size, @xLong4, 0) = 0
WriteFail:
        ctExtractor_ErrorQuitA(@"Failed to write to file")
        ElseIf Not xLong4 = \Size
        Goto WriteFail
        EndIf
      ctExtractor_MemFree(*Mem)
      CloseHandle_(xLong3)


      ;hFile
      ;FileNamePathW.l
      ;Position.l
      ;Size.l
      EndWith
    ;If Not hFile = xLong1
    ;  If hFile
    ;  xLong1 = hFile
    ;  EndIf
    Next

  EndProcedure

Procedure ctExtractor_Extract_Do()
  ctExtractor_Process()
  EndProcedure

Procedure.l OpenArchiveW(*ptrAnalyze, *lpFilenameW, *lParam)
  Define.l xLong1

  ctExtractor_PrintA(@"Processing ")
  ctExtractor_PrintW(*lpFilenameW)
  ctExtractor_PrintNA(@":")
  ctExtractor_hFileCurrent = ctExtractor_OpenFileW(*lpFilenameW, #OPEN_EXISTING, #GENERIC_READ)
  If ctExtractor_hFileCurrent
    ctExtractor_SizeLCurrent = GetFileSize_(ctExtractor_hFileCurrent, @ctExtractor_SizeHCurrent)
    If ctExtractor_SizeLCurrent = $ffffffff
      If GetLastError_()
        ;ctExtractor_ConsoleOutNextLine("Error detecting filesize")
        ctExtractor_ErrorQuitA(@"Error detecting filesize")
        EndIf
      EndIf
    xLong1 = ctExtractor_QueueCount
    CallFunctionFast(*ptrAnalyze, *lpFilenameW, *lParam)
    If xLong1 = ctExtractor_QueueCount
      CloseHandle_(ctExtractor_hFileCurrent)
      EndIf
    EndIf
  EndProcedure

Procedure.l OpenArchiveA(*ptrAnalyze, *lpFilenameA, *lParam)
  Define *lpFilenameW
  If *lpFilenameA
    *lpFilenameW = ctExtractor_Str_WideFromAnsi(*lpFilenameA)
    If *lpFilenameW
      OpenArchiveW(*ptrAnalyze, *lpFilenameW, *lParam)
      ctExtractor_MemFree(*lpFilenameW)
      EndIf
    EndIf
  EndProcedure

Procedure SetPosition64(PosLo.l, PosHi.l)
  Define.l xLong1 = PosHi
  Define.l xLong2

  xLong2 = SetFilePointer_(ctExtractor_hFileCurrent, PosLo, @xLong1, #FILE_BEGIN)
  If xLong2 = $ffffffff
    If GetLastError_()
SetPosition64_Error:
      ctExtractor_ErrorQuitA(@"Failed to seek to required position")
      EndIf
    ElseIf Not (xLong1 = PosHi And xLong2 = PosLo)
    Goto SetPosition64_Error
    EndIf
  EndProcedure

Procedure SetPosition32(Position.l)
  SetPosition64(Position, 0)
  EndProcedure

Procedure SeekToLastBytes32(NumBytes.l)
  Define.l xLong1
  Define.l xLong2

  MOV ecx, ctExtractor_SizeHCurrent
  MOV edx, ctExtractor_SizeLCurrent
  SUB edx, NumBytes
  SBB ecx, 0

  MOV xLong1, ecx
  MOV xLong2, edx
  SetPosition64(xLong2, xLong1)
  EndProcedure

Procedure.l ReadDWORD()
  Define.l xLong1
  Define.l xLong2

  If ReadFile_(ctExtractor_hFileCurrent, @xLong1, 4, @xLong2, 0)
    If xLong2 = 4
      ProcedureReturn xLong1
      EndIf
    EndIf
  ctExtractor_ErrorQuitA(@"Failed to read requested number of bytes (DWORD)")
  EndProcedure

Procedure CheckLgByteSignature(NumBytes.l, *lpBytes)
  Define *Mem = ctExtractor_RawReadAllocBytes(NumBytes)
  If CompareMemory(*lpBytes, *Mem, NumBytes) = 0
    ctExtractor_ErrorQuitA(@"Signature does not match")
    EndIf
  ctExtractor_MemFree(*Mem)
  EndProcedure

Procedure.l GetPosition64(*ptrLo, *ptrHi)
  If *ptrHi
    PokeL(*ptrHi, 0)
    EndIf

  Define.l xLong1 = SetFilePointer_(ctExtractor_hFileCurrent, 0, *ptrHi, #FILE_CURRENT)
  If xLong1 = $ffffffff
    If GetLastError_()
      ctExtractor_ErrorQuitA(@"Failed to determin to required position")
      EndIf
    EndIf
  PokeL(*ptrLo, xLong1)
  EndProcedure

Procedure.l GetPosition64Hi()
  Define.l xLong1
  Define.l xLong2
  GetPosition64(@xLong1, @xLong2)
  ProcedureReturn xLong2
  EndProcedure

Procedure.l GetPosition64Lo()
  Define.l xLong1
  Define.l xLong2
  GetPosition64(@xLong1, @xLong2)
  ProcedureReturn xLong1
  EndProcedure

Procedure ReadHexLine()
  Define.l xLong1
  Define.l xLong2
  Define.l xLong3
  Define.l xLong4
  Define.l xLong5
  Define.s xChar1
  Define.s xChar2
  
  GetPosition64(@xLong3, @xLong4)
  MOV ecx, ctExtractor_SizeHCurrent
  MOV edx, ctExtractor_SizeLCurrent
  MOV eax, xLong3
  SUB edx, eax
  MOV eax, xLong4
  SBB ecx, eax
  MOV xLong1, edx
  MOV xLong2, ecx
;  Debug "H: " + Hex(xLong2) + " / Lo: " + Hex(xLong1)
  
  If xLong4
    If xLong2 Or xLong1 > 8
      xLong1 = 8
      xLong2 = 1
      EndIf
    ElseIf xLong2 Or xLong1 > 16
    xLong1 = 16
    xLong2 = 1
    EndIf
  If xLong1
    xChar1 = Right("0000000" + Hex(xLong3), 8)
    If xLong4
      xChar1 = Right("0000000" + Hex(xLong4), 8) + ":" + xChar1
      EndIf
    xLong3 = ctExtractor_RawReadAllocBytes(xLong1)
    xLong1 - 1
    For xLong4 = 0 To xLong1
      xLong5 = PeekB(xLong3 + xLong4) & $ff
      xChar1 = xChar1 + " " + Hex((xLong5 & $f0) >> 4) + Hex(xLong5 & $f)
      Select xLong5
        Case 0
          PokeB(xLong3 + xLong4, 32)
        EndSelect
      Next
    xChar2 = PeekS(xLong3, xLong1 + 1)
    ctExtractor_MemFree(xLong3)
    EndIf
  xChar1 = "HH: " + xChar1 + "   " + xChar2
  ctExtractor_PrintCL()
  ctExtractor_PrintNA(@xChar1)
  If xLong2 = 0
    ctExtractor_ErrorQuitA(@"End of file reached!")
    EndIf
  EndProcedure

;Procedure CallDBG(Need, Free)
;  Debug "Need: " + Str(Need) + " Free: " + Str(Free)
;  EndProcedure

Procedure.l My_DeCrypt(*Mem, *Size, Flags, lParam)
;Debug "   " + PeekS(*Mem, 16)

  MOV ecx, *Mem
  MOV edx, *Size
  MOV edx, [edx]
  SHR edx, 2
  INC edx

;Define.l xLong1
;MOV xLong1, edx
;Debug xLong1
;Debug *Size
;Debug PeekL(*Size)
;End

!DeCrypt:
  MOV eax, [ecx]
  XOR eax, $37373737
  MOV [ecx], eax
  ADD ecx, 4
  DEC edx
  JNZ DeCrypt

!DoneDeCrypt:
  ProcedureReturn *Mem
  EndProcedure

Procedure.l My_Analyze(*lpFilenameW, *lParam)
  Define.l xLong1
  Define.l xLong2
  Define.l xLong3
  Define.l xLong4
  Define.l xLong5

  ;SetLastBytes32($fffff)
  CheckLgByteSignature(7, @"BASPACK")
  xLong1 = ReadDWORD()
  Debug xLong1
  SetPosition32(xLong1)
  
  ;xLong5 = (ctExtractor_SizeLCurrent - xLong1) / ($ff + 8)
  xLong5 = (ctExtractor_SizeLCurrent - xLong1) / ($ff + 8)
  
;  SeekToLastBytes32($102)

Define.l xLong8
Define.l xLong9
  For xLong1 = 1 To xLong5
    xLong2 = ctExtractor_RawReadAllocBytes($ff)
    RtlMoveMemory_(xLong2, xLong2 + 1, $fe)
    PokeB(xLong2 + $fe, 0)
;Debug PeekS(xLong2)
    xLong3 = ReadDWORD()
    xLong4 = ReadDWORD()
xLong8 = xLong8 + xLong3
xLong9 = xLong9 + xLong4

    CompilerIf #ctExtractor_Filter
      Define.l xLong7 = ctExtractor_FastExtensionA(xLong2)
      If xLong7 = $47474f Or xLong7 = $34504d
        Define.s xChar1 = LCase(PeekS(xLong2))
        If Left(xChar1, 10) = "data\music"
          ctExtractor_Archive_AddFileA(xLong2, xLong3, 0, xLong4, @My_DeCrypt(), 0, (xLong1 - 1) / xLong5)
          ElseIf Left(xChar1, 10) = "data\video"
          ctExtractor_Archive_AddFileA(xLong2, xLong3, 0, xLong4, @My_DeCrypt(), 0, (xLong1 - 1) / xLong5)
          ElseIf Left(xChar1, 15) = "data_i18n\video"
          ctExtractor_Archive_AddFileA(xLong2, xLong3, 0, xLong4, @My_DeCrypt(), 0, (xLong1 - 1) / xLong5)
          ElseIf Left(xChar1, 25) = "data\sfx\cutscenes\outro\"
          If xLong4 > 2000000
            ctExtractor_Archive_AddFileA(xLong2, xLong3, 0, xLong4, @My_DeCrypt(), 0, (xLong1 - 1) / xLong5)
            EndIf
          ElseIf xChar1 = "data\sfx\scene_sets\tower\heartdoor_stairs\sweeteners\sweetener_choir.ogg"
          ctExtractor_Archive_AddFileA(xLong2, xLong3, 0, xLong4, @My_DeCrypt(), 0, (xLong1 - 1) / xLong5)
          EndIf
        EndIf
      CompilerElse
      ctExtractor_Archive_AddFileA(xLong2, xLong3, 0, xLong4, @My_DeCrypt(), 0, (xLong1 - 1) / xLong5)
      CompilerEndIf
    Next

Debug "Size1: " + Str(xLong8)
Debug "Size2: " + Str(xLong9)

  ;For xLong1 = 1 To 26
  ;  ReadHexLine()
  ;  Next
  EndProcedure

ctExtractor_InitA(@"Gaga")
;OpenArchiveA(@My_Analyze(), @"x:\ra\Drawn - The painted tower\drawn\data.pak", 0)
OpenArchiveA(@My_Analyze(), @"data.pak", 0)
ctExtractor_Extract_Do()
; IDE Options = PureBasic 4.31 (Windows - x86)
; ExecutableFormat = Console
; CursorPosition = 3
; Folding = 8-------
; EnableAsm
; EnableXP
; Executable = Drawn TPT Full Extractor.exe
; DisableDebugger