Attribute VB_Name = "MODUL_GetFileVersion"
' Modul for Visual Basic 6
' Copyright (C) 2003,2004 Jan Vorel
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues

Option Explicit
Option Base 0

Public Type FileInfo
  wLength As Integer
  wValueLength As Integer
  szKey As String * 16
  dwSignature As Long
  dwStrucVersion As Long
  dwFileVersionMS As Long
  dwFileVersionLS As Long
  End Type
Declare Function GetFileVersionInfoA Lib "Version" (ByVal FileName As String, ByVal dwHandle As Long, ByVal cbBuff As Long, ByVal lpvData As String) As Long
Declare Function GetFileVersionInfoSizeA Lib "Version" (ByVal FileName As String, dwHandle As Long) As Long
Declare Sub hmemcpy Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, hpvSource As Any, ByVal cbBytes As Long)

Public Function GetFileVersion(ByVal FileName As String, Optional ByRef Revision As Single = -1) As Single
Dim xType1 As FileInfo
Dim xLong1 As Long
Dim xLong2 As Long
Dim xChar1 As String

xLong1 = GetFileVersionInfoSizeA(FileName, xLong2)
If Not xLong1 = 0& Then
  xChar1 = Space(xLong1)
  Call GetFileVersionInfoA(FileName, xLong2, xLong1, xChar1)
  hmemcpy xType1, ByVal xChar1, Len(xType1)
  GetFileVersion = xType1.dwFileVersionMS \ &HFFFF&
  xLong1 = xType1.dwFileVersionMS And &HFFFF&
  If Not xLong1 = 0 Then
    GetFileVersion = GetFileVersion + 0.1 ^ Int(Log(xLong1) / Log(10) + 1) * xLong1
    End If
  If Not Revision = -1 Then
    Revision = xType1.dwFileVersionLS \ &HFFFF&
    xLong1 = xType1.dwFileVersionLS And &HFFFF&
    If Not xLong1 = 0 Then
      Revision = Revision + 0.1 ^ Int(Log(xLong1) / Log(10) + 1) * xLong1
      End If
    End If
  End If
End Function


