Attribute VB_Name = "MODUL_OpenFilesDlg"
' Modul for Visual Basic 6
' Copyright (C) 2003,2004 Jan Vorel
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues





Option Explicit
Option Base 0

' When opening multiple files, the first file is the path for all other files
' To check whether multiple files are to open, you may try
' Dim FileNameString As String
' Dim FileBasePath As String
' If InStr(FileNameString, Chr(0)) = InStr(FileNameString, Chr(0) + Chr(0)) Then
'   'Only one file to open
'   Else
'   'They are multiple files: You may act this way:
'   FileBasePath = Left(FileNameString, InStr(FileNameString, Chr(0)) - 1)
'   FileNameString = Mid(FileNameString, InStr(FileNameString, Chr(0)) + 1)
'   End If

Private Type tOpenType
  lStructSize As Long
  hWndOwner As Long
  hInstance As Long
  lpstrFilter As String
  lpstrCustomFilter As String
  nMaxCustFilter As Long
  nFilterIndex As Long
  lpstrFile As String
  nMaxFile As Long
  lpstrFileTitle As String
  nMaxFileTitle As Long
  lpstrInitialDir As String
  lpstrTitle As String
  Flags As Long
  nFileOffset As Integer
  nFileExtension As Integer
  lpstrDefExt As String
  lCustData As Long
  lpfnHook As Long
  lpTemplateName As String
  End Type
Private Declare Function GetOpenFileNameA Lib "comdlg32.dll" (pOpenfilename As tOpenType) As Long
Private Declare Function GetSaveFileNameA Lib "comdlg32.dll" (pOpenfilename As tOpenType) As Long
Public Enum eOpenMode
  LoadSingleFile = &H81004
  LoadMultipleFiles = &H81204
  SaveSingleFile = &H80006
  End Enum

Public Function OpenFilesDlg(ByVal hwnd As Long, ByVal Filters As String, ByVal FileMode As eOpenMode, ByVal DlgCaption As String, Optional ByVal InitDir As String) As String
Dim xType1 As tOpenType
With xType1
  .lpstrFilter = Filters
  .lpstrTitle = DlgCaption
  .nFilterIndex = 1
  '.lpstrFile = String(32767&, 0)  'String(257, 0)
  .lpstrFile = String(32767&, vbNullChar)  'String(257, 0)
  .nMaxFile = Len(.lpstrFile) - 1&
  .lpstrFileTitle = .lpstrFile
  .nMaxFileTitle = .nMaxFile
  .lStructSize = Len(xType1)
  .hWndOwner = hwnd
  .hInstance = App.hInstance
  .lpstrInitialDir = InitDir
  .Flags = FileMode
  End With
If FileMode = &H81004 Or FileMode = &H81204 Then
  If GetOpenFileNameA(xType1) Then OpenFilesDlg = xType1.lpstrFile
  Else
  If GetSaveFileNameA(xType1) Then OpenFilesDlg = xType1.lpstrFile
  End If
If FileMode = &H81004 Or FileMode = &H80006 Then
  hwnd = InStr(OpenFilesDlg, vbNullChar)
  If hwnd = 0 Then
    OpenFilesDlg = ""
    Else
    OpenFilesDlg = Left(OpenFilesDlg, hwnd - 1&)
    End If
  End If
End Function


