Attribute VB_Name = "modCommonDialogs"
' Modul for Visual Basic 6
' Copyright (C) 2003,2004 Jan Vorel
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues

'#Const CommonDLG_UseOpenFiles = True
'#Const CommonDLG_UseOpenFilesEx = True
'#Const CommonDLG_UseOpenPath = True
'#Const CommonDLG_UseOpenPathLight = false


Option Explicit
Option Base 0

' When opening multiple files, the first file is the path for all other files
' To check whether multiple files are to open, you may try
' Dim FileNameString As String
' Dim FileBasePath As String
' If InStr(FileNameString, Chr(0)) = InStr(FileNameString, Chr(0) + Chr(0)) Then
'   'Only one file to open
'   Else
'   'They are multiple files: You may act this way:
'   FileBasePath = Left(FileNameString, InStr(FileNameString, Chr(0)) - 1)
'   FileNameString = Mid(FileNameString, InStr(FileNameString, Chr(0)) + 1)
'   End If

#If CommonDLG_UseOpenFiles Or CommonDLG_UseOpenFilesEx Then
  Private Type tOpenType
    lStructSize As Long
    hWndOwner As Long
    hInstance As Long
    lpstrFilter As String
    lpstrCustomFilter As String
    nMaxCustFilter As Long
    nFilterIndex As Long
    lpstrFile As String
    nMaxFile As Long
    lpstrFileTitle As String
    nMaxFileTitle As Long
    lpstrInitialDir As String
    lpstrTitle As String
    flags As Long
    nFileOffset As Integer
    nFileExtension As Integer
    lpstrDefExt As String
    lCustData As Long
    lpfnHook As Long
    lpTemplateName As String
    End Type
  Private Declare Function GetOpenFileNameA Lib "comdlg32.dll" (pOpenfilename As tOpenType) As Long
  Private Declare Function GetSaveFileNameA Lib "comdlg32.dll" (pOpenfilename As tOpenType) As Long
  #If CommonDLG_UseOpenFiles Then
    Public Enum eOpenMode
      LoadSingleFile = &H81004
      LoadMultipleFiles = &H81204
      SaveSingleFile = &H80006
'      SaveSingleFileMultipleExtension = &H80026
      End Enum
    #Else
    Public Const LoadSingleFile  As Long = &H81004
    Public Const LoadMultipleFiles As Long = &H81204
    Public Const SaveSingleFile As Long = &H80006
    #End If
  #End If

'Public DefExtentionArray(16) As String





#If CommonDLG_useOpenPath Or CommonDLG_UseOpenPathLight Then
  Private Declare Function SHBrowseForFolder Lib "shell32" (lpBI As BrowseInfo) As Long
  Private Declare Function SHGetPathFromIDList Lib "shell32" (ByVal pidList As Long, ByVal lpBuffer As String) As Long
  Private Declare Sub CoTaskMemFree Lib "ole32" (ByVal pv As Long)
  #If CommonDLG_UseOpenPathLight = False Then
    Private Declare Function SendMessageA Lib "user32" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As String) As Long
    Private xCurDir As String
    #End If

  Private Type BrowseInfo
    hWndOwner As Long
    pIDLRoot As Long
    'pszDisplayName As Long
    pszDisplayName As String
    'lpszTitle As Long
    lpszTitle As String
    ulFlags As Long
    lpfnCallback As Long
    lParam As Long
    iImage As Long
    End Type
  #End If





#If CommonDLG_UseOpenFiles Or CommonDLG_UseOpenFilesEx Then
  #If CommonDLG_UseOpenFilesEx Then
    Public Function CommonDLG_OpenFiles(ByVal hWnd As Long, ByVal Filters As String, ByVal FileMode As Long, ByVal DlgCaption As String, Optional ByVal InitDir As String) As String
    #Else
    Public Function CommonDLG_OpenFiles(ByVal hWnd As Long, ByVal Filters As String, ByVal FileMode As eOpenMode, ByVal DlgCaption As String, Optional ByVal InitDir As String) As String
    #End If
    Dim xLong1 As Long
    Dim xType1 As tOpenType
    
    With xType1
      .lpstrFilter = Filters
      .lpstrTitle = DlgCaption
      .nFilterIndex = 1
      '.lpstrFile = String(32767&, 0)  'String(257, 0)
      .lpstrFile = String(32767&, vbNullChar)  'String(257, 0)
      .nMaxFile = 32766&
      .lpstrFileTitle = .lpstrFile
      .nMaxFileTitle = .nMaxFile
      .lStructSize = Len(xType1)
      .hWndOwner = hWnd
      .hInstance = App.hInstance
      .lpstrInitialDir = InitDir
    '  .lpfnHook = OpenFilesDlg_CallBack(-2&, 0&, AddressOf OpenFilesDlg_CallBack, 0&)
    '  Debug.Print .lpfnHook
      hWnd = InStr(Filters, vbNullChar) + 1&
      xLong1 = InStr(hWnd, Filters & vbNullChar, vbNullChar)
      If Not hWnd = 1& Then
        CommonDLG_OpenFiles = Mid(Filters, hWnd, InStr(hWnd, Filters & vbNullChar, vbNullChar) - hWnd)
        If Not CommonDLG_OpenFiles = "" Then
          .lpstrDefExt = CommonDLG_OpenFiles
          End If
        End If
      .flags = FileMode
      'If FileMode = &H80006 And Not InStr(xLong1 + 1&, Filters, vbNullChar) = 0& Then
      '  .flags = FileMode And &H80000
      '  End If
      End With
    CommonDLG_OpenFiles = ""
    If FileMode = &H81004 Or FileMode = &H81204 Then
      If GetOpenFileNameA(xType1) Then CommonDLG_OpenFiles = xType1.lpstrFile
      Else
      If GetSaveFileNameA(xType1) Then CommonDLG_OpenFiles = xType1.lpstrFile
      End If
    If Not FileMode = &H81204 Then
      hWnd = InStr(CommonDLG_OpenFiles, vbNullChar)
      If hWnd = 0& Then
        CommonDLG_OpenFiles = ""
        Else
        CommonDLG_OpenFiles = Left(CommonDLG_OpenFiles, hWnd - 1&)
        End If
      End If
    End Function
  #End If

'Public Function OpenFilesDlg_CallBack(ByVal hWnd As Long, ByVal uInt As Long, ByVal wParam As Long, ByVal lParam As Long)
'On Error Resume Next
'
'Debug.Print hWnd, uInt, wParam, lParam
'If hWnd = -2& Then
'  OpenFilesDlg_CallBack = wParam
'  Else
'  'Select Case hWnd
'  '  Case Else
'  '  Debug.Print hWnd, uInt, wParam, lParam
'  '  End Select
'  OpenFilesDlg_CallBack = 0&
'  End If
'End Function











#If CommonDLG_useOpenPath Or CommonDLG_UseOpenPathLight Then
  Public Function CommonDLG_OpenPath(ByVal hWnd As Long, ByVal Caption As String, Optional ByVal InitDir As String) As String
    Dim xLong1 As Long
    Dim xType1 As BrowseInfo
    
    
    #If CommonDLG_UseOpenPathLight = False Then
      xCurDir = InitDir & vbNullChar
      #End If
    xType1.hWndOwner = hWnd
    xType1.lpszTitle = Caption '0 '"Add directory"
    xType1.ulFlags = &H3&
    #If CommonDLG_UseOpenPathLight = False Then
      xType1.lpfnCallback = BrowseCallbackProc(-2&, 0&, AddressOf BrowseCallbackProc, 0&)
      #End If
    xLong1 = SHBrowseForFolder(xType1)
    'If (xLong1) Then
    If Not xLong1 = 0& Then
      CommonDLG_OpenPath = String(260&, vbNullChar) 'Space(260&)
      SHGetPathFromIDList xLong1, CommonDLG_OpenPath
      CommonDLG_OpenPath = Left(CommonDLG_OpenPath, InStr(CommonDLG_OpenPath, vbNullChar) - 1)
      Call CoTaskMemFree(xLong1)
      End If
    End Function

  #If CommonDLG_UseOpenPathLight = False Then
    Private Function BrowseCallbackProc(ByVal hWnd As Long, ByVal uMsg As Long, ByVal lParam As Long, ByVal lData As Long) As Long
      Dim sbuffer As String
      Dim Ret As Long
      
      On Error Resume Next
      If hWnd = -2& Then
        BrowseCallbackProc = lParam
        Else
        Select Case uMsg
          Case 1&
            Call SendMessageA(hWnd, &H466&, 1&, xCurDir)
          Case 2&
            sbuffer = Space(260&)
            Ret = SHGetPathFromIDList(lParam, sbuffer)
            If Ret = 1 Then Call SendMessageA(hWnd, &H464&, 0&, sbuffer)
          End Select
        BrowseCallbackProc = 0&
        End If
      End Function
    #End If
  #End If
