Attribute VB_Name = "mod_BinaryMoveFileData"
' modul for Visual Basic 6
' Copyright (C) 2003-2005 Jan Vorel

' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues

'#Const BinaryMoveFileData_ProgressExtraLarge = 1


'#BinaryMoveFileData_FlagA
'    1 = Extended
'    2 = (Default)
'    5 (4) = UseAlternateMode
'    8 = UseClearData
'   10 = CanAbort
'   20 = ExtraLarge
' 1000 = Callback


Option Explicit
Option Base 0


Public Const BinaryMoveFileData_DefaultBlockSize As Long = &H3FFF00
#If (BinaryMoveFileData_FlagA And &H10&) = &H10& Then
  Public BinaryMoveFileData_AbortCopying As Boolean
  #End If

#If (BinaryMoveFileData_FlagA And &H1&) = &H1& Then
  Public Enum BinaryMoveFileData_OverwriteWithNullcharModes
    BinaryMoveFileData_NullstringNo = 0&
    BinaryMoveFileData_NullstringNew = 1&
    BinaryMoveFileData_NullstringOld = 2&
    BinaryMoveFileData_NullstringBoth = 3&
    BinaryMoveFileData_NullstringIfLarger = 4&
    End Enum
  #End If


#If (BinaryMoveFileData_FlagA And &H1&) = &H1& Then
  #If (BinaryMoveFileData_FlagA And &H20&) = &H20& Then
  Public Function BinaryMoveFileDataEx(ByVal FileMode As Long, ByVal Size As Long, ByVal StartPos As Long, ByVal NewPos As Long, Optional ByVal OutFileMode As Long = -1&, Optional ByVal OverwriteWithNullchars As BinaryMoveFileData_OverwriteWithNullcharModes = BinaryMoveFileData_NullstringIfLarger, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize, Optional ByVal ProgressControl As Long, Optional ByVal ProgressStart As Double = 0#, Optional ByVal ProgressTotal As Double = 0#) As Boolean
  #Else
  Public Function BinaryMoveFileDataEx(ByVal FileMode As Long, ByVal Size As Long, ByVal StartPos As Long, ByVal NewPos As Long, Optional ByVal OutFileMode As Long = -1&, Optional ByVal OverwriteWithNullchars As BinaryMoveFileData_OverwriteWithNullcharModes = BinaryMoveFileData_NullstringIfLarger, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize, Optional ByVal ProgressControl As Long, Optional ByVal ProgressStart As Long = 0&, Optional ByVal ProgressTotal As Long = 0&) As Boolean
  #End If

    Dim xLong1 As Long
    Dim xLong2 As Long
    Dim xLong3 As Long
    Dim xLong4 As Long
    Dim xLong5 As Long
    Dim xChar1 As String
    
    On Error GoTo Er1
    On Error GoTo 0
    
    #If (BinaryMoveFileData_FlagA And &H10&) = &H10& Then
      BinaryMoveFileData_AbortCopying = False
      #End If
    
    If OutFileMode = -1& Then
      OutFileMode = FileMode
      End If
    
    
    If FileMode = OutFileMode Then
      If NewPos > StartPos Then
        xLong1 = NewPos - StartPos
        Else
        xLong1 = StartPos - NewPos
        End If
      If xLong1 > Size Then xLong1 = Size
      Else
      xLong1 = Size
      End If
    
    xLong5 = Size
    If (Not NewPos = StartPos And FileMode = OutFileMode) Or _
      Not FileMode = OutFileMode And _
      (OverwriteWithNullchars = 1& Or OverwriteWithNullchars = 3& Or _
      OverwriteWithNullchars = 4& And NewPos > StartPos) Then
      xLong5 = xLong5 + xLong1
      End If
    
    If Not NewPos = StartPos And FileMode = OutFileMode And _
      (OverwriteWithNullchars = 2& Or OverwriteWithNullchars = 3&) Then
      xLong5 = xLong5 + xLong1
      End If
    
    
    
    
    
    If (Not NewPos = StartPos And FileMode = OutFileMode) Or _
      Not FileMode = OutFileMode And _
      (OverwriteWithNullchars = 1& Or OverwriteWithNullchars = 3& Or _
      OverwriteWithNullchars = 4& And NewPos > StartPos) Then
      
      If FileMode = OutFileMode And NewPos > StartPos Then
        xLong1 = NewPos - StartPos
        If xLong1 > Size Then xLong1 = Size
        xLong2 = NewPos + Size - xLong1 + 2&
        Else
        xLong2 = NewPos + 1&
        End If
      GoSub NullWrite
      End If
    
    
    
    DoEvents
    #If (BinaryMoveFileData_FlagA And &H10&) = &H10& Then
      If BinaryMoveFileData_AbortCopying Then GoTo Rs1
      #End If
    
    
    If NewPos > StartPos And FileMode = OutFileMode Then ' And Not FileMode = OutFileMode Then
      xLong2 = Size
      Do
        If xLong2 = 0& Then Exit Do
        xLong1 = xLong2
        If xLong1 > BlockSize Then xLong1 = BlockSize
        xChar1 = String(xLong1, vbNullChar)
        xLong2 = xLong2 - xLong1
        Get FileMode, (StartPos + xLong2 + 1&), xChar1
        Put OutFileMode, (NewPos + xLong2 + 1&), xChar1
        'xLong2 = xLong2 - xLong1
        xLong4 = xLong4 + xLong1
        
        #If (BinaryMoveFileData_FlagA And &H10&) = &H20& Then
          If Not ProgressTotal = 0# Then
          #Else
          If Not ProgressTotal = 0& Then
          #End If
    
          ctProgressB_SetValue ProgressControl, (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal
          End If
        DoEvents
        #If (BinaryMoveFileData_FlagA And &H10&) = &H10& Then
          If BinaryMoveFileData_AbortCopying Then GoTo Rs1
          #End If
        Loop
      xLong2 = StartPos + 1& '''' 2&
      xLong1 = Size
    '  If xLong1 > Size Then xLong1 = Size
      ElseIf NewPos < StartPos Or Not FileMode = OutFileMode Then
      xLong2 = 0&
      Do
        If xLong2 = Size Then Exit Do
        xLong1 = Size - xLong2
        If xLong1 > BlockSize Then xLong1 = BlockSize
        xChar1 = String(xLong1, vbNullChar)
        Get FileMode, (StartPos + xLong2 + 1&), xChar1
        
        
        Put OutFileMode, (NewPos + xLong2 + 1&), xChar1
        xLong2 = xLong2 + xLong1
        xLong4 = xLong4 + xLong1
        #If (BinaryMoveFileData_FlagA And &H20&) = &H20& Then
          If Not ProgressTotal = 0# Then
          #Else
          If Not ProgressTotal = 0& Then
          #End If
    
          ctProgressB_SetValue ProgressControl, (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal
          #If (BinaryMoveFileData_FlagA And &H1000&) = &H1000& Then
            BinaryMoveFileData_CallBack (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal
            #End If
          End If
        DoEvents
        #If (BinaryMoveFileData_FlagA And &H10&) = &H10& Then
          If BinaryMoveFileData_AbortCopying Then GoTo Rs1
          #End If
        Loop
      xLong1 = StartPos - NewPos
      If xLong1 > Size Then xLong1 = Size
      xLong2 = StartPos + Size - xLong1 + 1& '2&
      End If
    
    If Not NewPos = StartPos And FileMode = OutFileMode And _
      (OverwriteWithNullchars = 2& Or OverwriteWithNullchars = 3&) Then
      OutFileMode = FileMode
      GoSub NullWrite
      End If
    xChar1 = ""
    BinaryMoveFileDataEx = True
    
Rs1:
'Stop
    On Error GoTo 0
    Exit Function
    
Er1:
    Resume Rs1
    
NullWrite:
    'If xLong1 > Size Then xLong1 = Size
    
    If FileMode = OutFileMode Then
      If NewPos > StartPos Then
        xLong1 = NewPos - StartPos
        Else
        xLong1 = StartPos - NewPos
        End If
      Else
      xLong1 = Size
      End If
    If xLong1 > Size Then xLong1 = Size
    DoEvents
    #If (BinaryMoveFileData_FlagA And &H10&) = &H10& Then
      If BinaryMoveFileData_AbortCopying Then Resume Rs1
      #End If
    Do
      If xLong1 = 0 Then Exit Do
      xLong3 = xLong1
      If xLong3 > BlockSize Then xLong3 = BlockSize
      xChar1 = String(xLong3, vbNullChar)
      Put OutFileMode, xLong2, xChar1
      xLong1 = xLong1 - xLong3
      xLong2 = xLong2 + xLong3
      xLong4 = xLong4 + xLong3
      #If (BinaryMoveFileData_FlagA And &H20&) = &H20& Then
        If Not ProgressTotal = 0# Then
        #Else
        If Not ProgressTotal = 0& Then
        #End If
    
        ctProgressB_SetValue ProgressControl, (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal
        #If (BinaryMoveFileData_FlagA And &H1000&) = &H1000& Then
          BinaryMoveFileData_CallBack (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal
          #End If
        End If
      DoEvents
      #If (BinaryMoveFileData_FlagA And &H10&) = &H10& Then
        If BinaryMoveFileData_AbortCopying Then Resume Rs1
        #End If
      Loop
    Return
    End Function
  #End If

#If (BinaryMoveFileData_FlagA And &H2&) = &H2& Or BinaryMoveFileData_FlagA = &H0& Then
#If (BinaryMoveFileData_FlagA And &H20&) = &H20& Then
  Public Function BinaryMoveFileData(ByVal FileModeSource As Long, ByVal FileModeDest As Long, ByVal Size As Long, Optional ByVal StartPosSource As Long, Optional ByVal StartPosDest As Long, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize, Optional ByVal ProgressControl As Long, Optional ByVal ProgressStart As Double = 0#, Optional ByVal ProgressTotal As Double = 0#) As Boolean
  #Else
  Public Function BinaryMoveFileData(ByVal FileModeSource As Long, ByVal FileModeDest As Long, ByVal Size As Long, Optional ByVal StartPosSource As Long, Optional ByVal StartPosDest As Long, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize, Optional ByVal ProgressControl As Long, Optional ByVal ProgressStart As Long = 0&, Optional ByVal ProgressTotal As Long = 0&) As Boolean
  #End If

    Dim xLong1 As Long
    Dim xLong2 As Long
    Dim xChar1 As String
    
    On Error GoTo Er1
    'On Error GoTo 0
    
    #If (BinaryMoveFileData_FlagA And &H10&) = &H10& Then
      BinaryMoveFileData_AbortCopying = False
      #End If
    
    StartPosSource = StartPosSource + 1&
    StartPosDest = StartPosDest + 1&
    Do Until xLong1 = Size
      xLong2 = (Size - xLong1)
      If xLong2 > BlockSize Then xLong2 = BlockSize
      xChar1 = String(xLong2, vbNullChar)
      Get FileModeSource, (StartPosSource + xLong1), xChar1
      Put FileModeDest, (StartPosDest + xLong1), xChar1
      xLong1 = xLong1 + xLong2
      #If (BinaryMoveFileData_FlagA And &H20&) = &H20& Then
        If Not (ProgressControl = 0& Or ProgressTotal = 0#) Then
        #Else
        If Not (ProgressControl = 0& Or ProgressTotal = 0&) Then
        #End If
        ctProgressB_SetValue ProgressControl, (ProgressStart + xLong1) / ProgressTotal
        End If
      DoEvents
      #If (BinaryMoveFileData_FlagA And &H10&) = &H10& Then
        If BinaryMoveFileData_AbortCopying Then GoTo Rs1
        #End If
      Loop
    BinaryMoveFileData = True
    
Rs1:
    On Error GoTo 0
    Exit Function
    
Er1:
    Resume Rs1
    End Function
  #End If


#If (BinaryMoveFileData_FlagA And &H8&) = &H8& Then
Public Function BinaryClearFileData(ByVal FileMode As Long, ByVal Position As Long, ByVal Size As Long, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize, Optional ByVal ProgressControl As Long, Optional ByVal ProgressStart As Long = 0&, Optional ByVal ProgressTotal As Long) As Boolean
Dim xLong1 As Long
Dim xLong2 As Long
Dim xChar1 As String

On Error GoTo Er1
On Error GoTo 0
    
#If (BinaryMoveFileData_FlagA And &H10&) = &H10& Then
  BinaryMoveFileData_AbortCopying = False
  #End If
Do
  If xLong2 = Size Then Exit Do
  xLong1 = Size - xLong2
  If xLong1 > BlockSize Then xLong1 = BlockSize
  xChar1 = String(xLong1, vbNullChar)
  Put FileMode, Position + xLong2 + 1&, xChar1
  xLong2 = xLong2 + xLong1
  #If (BinaryMoveFileData_FlagA And &H20&) = &H20& Then
    If Not (ProgressControl = 0& Or ProgressTotal = 0#) Then
    #Else
    If Not (ProgressControl = 0& Or ProgressTotal = 0&) Then
    #End If
    ctProgressB_SetValue ProgressControl, (ProgressStart + xLong2) / ProgressTotal
    End If
  DoEvents
  #If (BinaryMoveFileData_FlagA And &H10&) = &H10& Then
    If BinaryMoveFileData_AbortCopying Then GoTo Rs1
    #End If
  Loop
BinaryClearFileData = True

Rs1:
On Error GoTo 0
Exit Function

Er1:
Resume Rs1
End Function
#End If



#If (BinaryMoveFileData_FlagA And &H5&) = &H5& Then
  Public Function BinaryMoveFileDataAlternate(ByVal FileMode As Long, ByVal Size As Long, ByVal StartPos As Long, ByVal PDifference As Long, ByVal ProgressControl As ctProgressA, Optional ByVal OutFileMode As Long = -1, Optional ByVal OverwriteWithNullchars As BinaryMoveFileData_OverwriteWithNullcharModes = BinaryMoveFileData_NullstringIfLarger, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize, Optional ByVal ProgressStart As Long = 0&, Optional ByVal ProgressTotal As Long) As Boolean
    BinaryMoveFileDataAlternate = BinaryMoveFileData(FileMode, Size, StartPos, StartPos + PDifference, ProgressControl, OutFileMode, OverwriteWithNullchars, BlockSize, progresstart, ProgressTotal)
    End Function
#End If
