Attribute VB_Name = "modDoEventsEx"
' Copyright (C) 2003,2004 Jan Vorel
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues

Option Explicit
Option Base 0

Private Const SleepValueHigh As Long = 75&
Private Const SleepValueLow As Long = 25&

'#Const DoEventsEx_Extended = 1
'#Const DoEventsEx_ExtendedOnly = 1
'#Const DoEventsEx_ElapsedTime = 1

Private Declare Function GetTickCount Lib "kernel32" () As Long
Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

#If DoEventsEx_ExtendedOnly Then
  #Else
  Public Sub DoEventsEx(ByVal TimeIntervalMs As Long, Optional ByVal FirstTickValue As Long = -1&)
    Static xLong1 As Long
    
'    If FirstTickValue = -1& Then
'      FirstTickValue = GetTickCount And Not &Hc0000000
'      End If
    DoEvents
    If TimeIntervalMs > SleepValueHigh Or FirstTickValue = -1& Then
      If FirstTickValue = -1& Then
        FirstTickValue = GetTickCount And Not &HC0000000
        End If
      Sleep SleepValueHigh
'      Debug.Print "DoeventsEx: Sleep " & Trim(Str(SleepValueHigh))
      Do
        xLong1 = GetTickCount And Not &HC0000000
        If xLong1 < FirstTickValue Then
          xLong1 = TimeIntervalMs - (xLong1 + &H40000000 - FirstTickValue)
          Else
          xLong1 = TimeIntervalMs - (xLong1 - FirstTickValue)
          End If
          
        If xLong1 > 0& Then
          DoEvents
'          Debug.Print "  DoeventsEx: Should " & Trim(Str(xLong1))
          If xLong1 > SleepValueHigh Then xLong1 = SleepValueHigh
          Sleep xLong1
'          Debug.Print "  DoeventsEx: Sleep " & Trim(Str(xLong1))
          Else
          Exit Do
          End If
        Loop
      Else
'      Debug.Print "DoeventsEx: Sleep " & Trim(Str(TimeIntervalMs))
      Sleep TimeIntervalMs
      End If
'    Debug.Print "  Elapsed: " & Trim(Str(((GetTickCount And Not &Hc0000000) + &H40000000 - FirstTickValue) Mod &H40000000))
    End Sub
  #End If

#If DoEventsEx_ElapsedTime Then
  Public Function TickCountElapsedTime(ByVal FirstTickCountValue As Long, ByVal TimeIntervalMs As Long) As Boolean
    Static xLong1 As Long
    xLong1 = GetTickCount And Not &HC0000000
    If xLong1 < FirstTickCountValue Then
      TickCountElapsedTime = xLong1 + &H40000000 - FirstTickCountValue
      Else
      TickCountElapsedTime = (xLong1 - FirstTickCountValue)
      End If
    End Function
  #End If

#If DoEventsEx_Extended Or DoEventsEx_ExtendedOnly Then
  Public Function GetTickCountEx() As Long
    GetTickCountEx = GetTickCount And Not &HC0000000
    End Function
  #End If
  
#If DoEventsEx_Extended Or DoEventsEx_ExtendedOnly Or DoEventsExA Then
  Public Function TickCountElapsed(ByVal FirstTickCountValue As Long, ByVal TimeIntervalMs As Long) As Boolean
    Static xLong1 As Long
    xLong1 = GetTickCount And Not &HC0000000
    If xLong1 < FirstTickCountValue Then
      TickCountElapsed = (xLong1 + &H40000000 > FirstTickCountValue + TimeIntervalMs)
      Else
      TickCountElapsed = (xLong1 > FirstTickCountValue + TimeIntervalMs)
      End If
    End Function
  #End If

#If DoEventsExA Then
  Public Sub DoEventsExA()
    Static xLong1 As Long
    
    If TickCountElapsed(xLong1, 250&) Then
'    Debug.Print "SleepBeginn"
      DoEvents
      Sleep SleepValueLow
      xLong1 = GetTickCount And Not &HC0000000
'    Debug.Print "SleepDone"
      End If
'    DoEvents
'    Sleep 0&
    End Sub
  #End If

