EnableExplicit
; Copyright (C) 2001-2006 Jan Vorel

; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

; This is a shared modul, class modul, usercontrol or form. It is also
; published under the GNU General Public License.

; If you have any questions, suggestions or bug reports about this product,
; contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
; language or A.P.I. issues

;#Compiler_Mode = 2
;#Compiler_DebugMe = 0

; 0 = default
; 1 = debug
; 2 = ctuninst


; PRGNAME=Reg2exe 2.25
; VERSION=2,24,0,0
; COMMENTS=Compressed with UPX (http://upx.sourceforge.net)
; COMPANY=ctuser
; DESCRIP=Reg2exe 'converter'
; LEGALCOPYRIGHT=2001-2005 by Jan Vorel
; E-MAIL=info@ctuser.net
; WEB=http://www.ctuser.net

Declare CheckProgress(Progress.f)
Declare.s GetCharEx(xChar1.s, xLong1.l)
Declare.s InstrRev(xChar1.s)
Declare.l DoEventsEx_IsTickCountElapsed(FirstTickCountValue.l, TimeIntervalMs.l)
Declare Sleep(IntervalMS.l)
Declare.s LoadResStringA(ResID.l) ;, CanBeMultiLine.l)
Declare.l CreateInstance() ;(ResID.l)
Declare RegDeleteValuesEx(OpenKey.l)
Declare.l RegDeleteKeysRecursive(StartKey.l, SubKey.s, NoDeleteMain.l)
Declare.l InstrA(StartPos.l)
Declare.l ReplaceBinary (NewString.s, BinaryStart.l, BinaryEnd.l, OrigString.s)
Declare.s GetProgramsPath()
Declare.s RegReadString(uRGSection.s, uRGName.s)
Declare GetXPAccess()
Declare.l ReadByteX()

;MessageRequester("aa", Hex(GetCurrentProcessId_()))



;CompilerIf #Compiler_Mode = 2
;  MessageRequester("OK","OK")
;  CompilerEndIf

Global Dim xByteA1.b(1048575)
Define.l LOF_File
Define.l xLong1
Define.l xLong2
Define.l xLong3
Define.l xLong4
Define.l xLong5
Define.s xChar1
Define.s xChar2
Define.l xKeyLong2
Define.s xAppPath
Define.s xAppPathProgs
Define.s xAppPathWin
Define.s xAppPathSys
Define.s xAppPathTemp
Define.l ProgressStart
Define.l ProgressWidth

Global hInstance.l
Global IsInterface.l
CompilerIf #Compiler_Mode = 2
  Define.StartupInfo xType1
  Define.Process_Information xType2
  CompilerEndIf



;CompilerIf #Compiler_DebugMe = 1
;  WriteStringX("Init GetTempDir")
;  CompilerEndIf

xChar1 = Space(256)
xLong1 = GetTempPath_(256, xChar1)

xAppPathTemp = GetCharEx(xChar1, xLong1)

;Debug ProgramParameter() 













CompilerIf #Compiler_Mode = 2
  Declare.l ReadLongX()
  Declare.s ReadStringX()
  Declare.s DeleteFileX(DefDir.s, Filename.s)
  Declare.s MidX(BaseString.s, Position.l)
  Declare RunProgramX(FileName.s, RMode.l)
  Declare WaitOnProgram(ProgramID.l)
  CompilerEndIf


;DeleteFileX("1", "c:\q0400e\application Data\microsoft\internet explorer\quick launch\*.lnk")


CompilerIf #Compiler_DebugMe = 1
  Declare WriteStringX(xChar1.s)
  #DebugFileID = 1
  ;#RegFileID = 2
  xChar1 = ProgramFilename() ; AppBase()
  xChar1 = Left(xChar1, Len(xChar1) - 3) + "log"
  CreateFile(#DebugFileID, xChar1)
;  Debug(xChar1)
  ;UseFile(#DebugFileID)
  WriteStringX("Started")
  ;Global FileOpened.l
  CompilerEndIf




CompilerIf #Compiler_DebugMe = 1
  WriteStringX("Declared, init GetWindowsDir")
  CompilerEndIf
xChar1 = Space(256)
xLong1 = GetWindowsDirectory_(xChar1, 256)

xAppPathWin = GetCharEx(xChar1, xLong1)



CompilerIf #Compiler_DebugMe = 1
  WriteStringX("Init GetSystemDir")
  CompilerEndIf
xChar1 = Space(256)
xLong1 = GetSystemDirectory_(xChar1, 256)
xAppPathSys = GetCharEx(xChar1, xLong1)





CompilerIf #Compiler_DebugMe = 1
  WriteStringX("Init GetProgDir")
  CompilerEndIf
xAppPathProgs = GetProgramsPath()




CompilerIf #Compiler_DebugMe = 1
;  xChar1 = ProgramParameter()
;  xChar1 = "C:\Q03311\Programs\ctuser\QuickPlayer\ctuninst.tmp"
;  xChar1 = "C:\Q03311\temp\ctuninst.tmp"
  ;xChar1 = "C:\Q03311\temp\ctuninst.tmp"
  ;xChar1 = "D:\dev\projects\Reg2exe\Test.exe"
  WriteStringX("Attempting file: " + xChar1)
  CompilerElse
  xChar1 = ProgramFilename()
  ;xChar1 = "D:\DEV\Projects\Reg2exe\Test.exe"
  ;xChar1 = "E:\VB6\Reg2exe\Test.exe"
  CompilerEndIf

;xChar1 = "D:\DEV\Projects\Reg2exe\Testr.exe"
;  xChar1 = "C:\Q03311\Programs\ctuser\QuickPlayer\ctuninst.tmp"
CompilerIf #Compiler_Mode = 0
  xAppPath = InstrRev(xChar1)
  CompilerEndIf
;WriteStringX("ReadFile: " + xChar1)
;Debug xAppPath

; Debug xChar1

Global FileAccessID.l

GetXPAccess()
CompilerIf #Compiler_Mode = 2
;  xLong1 = ReadFile(#PB_Any, xChar1)

  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("ReadFile: " + xChar1)
    FileAccessID = ReadFile(#PB_Any, xChar1)
    ;If FileAccessID
    ;  FileOpened = 1
    ;  EndIf
    WriteStringX("ReadFile: " + Trim(Str(FileAccessID)))
    CompilerElse
    FileAccessID = ReadFile(#PB_Any, xChar1)
    CompilerEndIf
  ;MessageRequester("OK",xChar1)
  ;MessageRequester("OK",Str(FileAccessID))
  LOF_File = Lof(FileAccessID)
  ;MessageRequester("OK",Str(LOF_File))
  FileSeek (FileAccessID, LOF_File - 3)
  xChar1 = Space(3)
  xLong1 = ReadData(FileAccessID, @xChar1, 3)
  ;MessageRequester("OK",xChar1)
;Debug ("1" + xChar1)
  If xChar1 = "ctU"
    ;MessageRequester("OK",xChar1)
    FileSeek(FileAccessID, LOF_File - 15)
    xChar1 = Space(8)
    xLong1 = ReadData(FileAccessID, @xChar1, 8)
;Debug(xChar1)
;Debug ("2")
    If xChar1 = "ctUninst"
;Debug ("2.1" + Str(xLong1))
      xLong1 = ReadLongX()
;Debug ("2.2" + Str(xLong1))
      ;MessageRequester("OK",Str(xLong1))
      FileSeek(FileAccessID, xLong1)
      xLong2 = xLong1 + 16 ; 8 + 8 (4+4)
      xChar1 = Space(8)
      xLong1 = ReadData(FileAccessID, @xChar1, 8)
;Debug ("3 "+ xChar1)
      ;MessageRequester("OK",xChar1)
      If xChar1 = "ctUninst"
        xLong1 = ReadLongX()
        If xLong1 = 1
;Debug ("4")
          xLong1 = ReadLongX()
          ;xLong5 = ReadLongX()
          xChar1 = ReadStringX()
          xChar2 = ReadStringX()
          xAppPath = ReadStringX()

;          Debug "0.1 " + xChar3.s
          xAppPath = LCase(xAppPath)
;          Debug "0.2 " + xChar3
          xLong2 = xLong2 + xLong1

            ;MessageRequester("Gaga", ProgramParameter())
            ;MessageRequester("Gaga", ProgramParameter())
          If LCase(ProgramFilename()) = LCase(xAppPathTemp) + "\ctuninst.tmp"
            ;Sleep_(5000)
            Else
            If MessageRequester("Warning", xChar2 + Chr(13) + "(Please ensure the programm is not running before continuing)", #PB_MessageRequester_YesNo) = 6
              xChar1 = "Software\Microsoft\Windows\CurrentVersion\Uninstall\" + xChar1
              RegDeleteKey_(-2147483646, @xChar1)
              ;CopyFile(xProgramFilename(), AppPathTemp + "\ctuninst.tmp")
              If CopyFile(ProgramFilename(), xAppPathTemp + "\ctuninst.tmp")
                ;OnErrorResume()
                ;RunProgram(xAppPathTemp + "\ctuninst.tmp", "DoIt", xAppPathTemp)
                xType1\cb = 68
                CreateProcess_(xAppPathTemp + "\ctuninst.tmp", Chr(34) + xAppPathTemp + "\ctuninst.tmp" + Chr(34) + " " + Str(GetCurrentProcessId_()), 0, 0, 0, 0, 0, xAppPathTemp, @xType1, @xType2)
                Else
                CheckProgress(-3)
                EndIf
              ;OnErrorGoto(0)
              EndIf
            ;Repeat
            ;  Delay(50)
            ;  Sleep_(100)
            ;  ForEver
            End
            EndIf

          CheckProgress(0)
          WaitOnProgram(Val(ProgramParameter()))
          ;MessageRequester("Waiting for: " + Hex(
          ;For xLong1 = 0 To 100
          ;  Sleep(50)
          ;  Next
          ;MessageRequester("OK","OK")
          ProgressStart = Loc(FileAccessID)
          ProgressWidth = xLong2 - ProgressStart
          SetGadgetText(0, LoadResStringA(101))
          While Loc(FileAccessID) < xLong2
            xChar1 = ReadStringX()
            Select Asc(xChar1)
              Case 1
                xChar1 = MidX(xChar1, 2)
                RemoveDirectory_(@xChar1)
              Case 2 
                RunProgramX(xChar1, 0)
              Case 3 ;hidden
                RunProgramX(xChar1, 2)
              Case 4 ;wait
                RunProgramX(xChar1, 1)
              Case 5 ;wait hidden
                RunProgramX(xChar1, 3)
              Default
                DeleteFileX(xAppPath, xChar1)
              EndSelect
            CheckProgress((Loc(FileAccessID) - ProgressStart) / ProgressWidth)
            Wend
          FileSeek (FileAccessID, xLong2)




  CompilerElse


  CompilerIf #Compiler_DebugMe = 1
    FileAccessID = ReadFile(#PB_Any, xChar1)
    ;If xLong1 <> 0
    ;  FileOpened = 1
    ;  EndIf
    WriteStringX("ReadFile: " + Trim(Str(FileAccessID)) + " from " + xChar1)
    CompilerElse
    FileAccessID = ReadFile(#PB_Any, xChar1)
    CompilerEndIf
  LOF_File.l = Lof(FileAccessID)
  If xLong1 <> 0
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("Seeking...")
        WriteStringX("Returns: " + Trim(Str(FileSeek(FileAccessID, LOF_File - 5))))
      CompilerElse
      FileSeek (FileAccessID, LOF_File - 5)
      CompilerEndIf
    xChar1 = Space(3)
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("ReadData...")
      CompilerEndIf
    xLong1 = ReadData(FileAccessID, @xChar1, 3)
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("Comparing")
      CompilerEndIf
    If Left(xChar1, 3) = "R22"
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("Useable")
        CompilerEndIf
        
    
      xLong1 = ReadByteX()
      xLong2 = ReadByteX()
      xLong1 = xLong1 * 256 + xLong2
      FileSeek (FileAccessID, xLong1)
      If ReadData(FileAccessID, @xChar1, 3) = 3
        If Left(xChar1, 3) = "R22"
  CompilerEndIf





CompilerIf #Compiler_DebugMe = 1
  WriteStringX(Str(Loc(FileAccessID)) + " - " + Str(LOF_File))
  CompilerEndIf

;MessageRequester("OK","OK")

CompilerIf #Compiler_Mode = 2
ProgressStart = Loc(FileAccessID)
ProgressWidth = LOF_File - 17
;CheckProgress(-1)
SetGadgetText(0, LoadResStringA(102))
While Loc(FileAccessID) < LOF_File - 17
CompilerElse
ProgressStart.l = Loc(FileAccessID)
ProgressWidth.l = LOF_File - 7
CheckProgress(-1)
While Loc(FileAccessID) < LOF_File - 7
CompilerEndIf
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("<< Loop >>")
    CompilerEndIf
  xLong2 = ReadByteX()
  xLong1 = ReadByteX()
  xLong3 = ReadByteX()
  
  ;Debug Hex(Loc()) + "-" + Str(xlong1) + "-" + Str(xlong2) + "-" + Str(xlong3)
  
  xLong3 = xLong1 * 256 + xLong3
  xLong1 = (xLong2 & 240) / 16 ;Int (xLong2 / 16)
  If xLong1 > 7 
    If xKeyLong2 <> 0
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("Closing key")
        CompilerEndIf
      RegCloseKey_(xKeyLong2)
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("  done")
        CompilerEndIf
      xKeyLong2 = 0
      EndIf
    xLong2 = -2147483648 + (xLong2 & 15)
    Else
    xLong3 = (xLong2 & 15) * 65536 + xLong3
    If xLong1 = 2 
      xLong3 = xLong3 + 2
      EndIf
    EndIf
  If xLong1 < 8 
    For xLong4 = 0 To xLong3 - 1
      xByteA1(xLong4) = ReadByteX()
      Next

    xChar1 = ""
    If xLong1 = 2 
      xLong4 = InstrA(2)
      For xLong5 = 2 To xLong4 - 1
        xChar1 = xChar1 + Chr(xByteA1(xLong5))
        Next
      Else
      xLong4 = InstrA(0)
      For xLong5 = 0 To xLong4 - 1
        xChar1 = xChar1 + Chr(xByteA1(xLong5))
        Next
      EndIf
    Else
    xChar1 = Space(xLong3)
    If ReadData(FileAccessID, @xChar1, xLong3) <> xLong3 
      ;MessageRequester("","Error1", #PB_MessageRequester_Ok)
      Goto Er2
      EndIf
    EndIf

  ;Debug "  " + Hex(Loc()) + "-" + Str(xlong1) + "-" + Str(xlong2) + "-" + Str(xlong3)

;          ' 0 delvalue
;          ' 1 string
;          ' 2 hex(x)
;          ' 3 hex
;          ' 4 dword
;          ' 8 makedir       'xxxxxxxxxxx
;          ' 9 opendir       'xxxxxxxxxxx (does not create if not exists!!!)
;          '10 deldir        'xxxxxxxxxxx
;          '11 delsubdirs    'deletes all subkeys. key left open for writting values
;          '12 delmainvalues 'deletes all values in the directory itself. key left open for writting values


  ;Debug Hex(Loc())
  If xLong1 = 0
    If xKeyLong2 <> 0 
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("RegDeleteKey: " + xChar1)
        Define.l DebugResult
        DebugResult = RegDeleteValue_(xKeyLong2, @xChar1)
        If DebugResult = 0
          WriteStringX("  ok?")
          Else
          WriteStringX("  failed (" + Trim(Str(DebugResult)) + ")?")
          EndIf
        CompilerElse
        RegDeleteValue_(xKeyLong2, @xChar1)
        CompilerEndIf
      EndIf
    ElseIf xLong1 < 5
    If xKeyLong2 <> 0
      If xLong1 = 2 
        xLong1 = xByteA1(0) * 256 + xByteA1(1)
        EndIf
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("ReplaceBinary stuff")
        CompilerEndIf
      xLong3 = Replacebinary(xAppPath, xLong4 + 1, xLong3, "reg2exepath")
      xLong3 = Replacebinary(xAppPathWin, xLong4 + 1, xLong3, "reg2exewinpath")
      xLong3 = Replacebinary(xAppPathSys, xLong4 + 1, xLong3, "reg2exesyspath")
      xLong3 = Replacebinary(xAppPathTemp, xLong4 + 1, xLong3, "reg2exetemppath")
      xLong3 = Replacebinary(xAppPathProgs, xLong4 + 1, xLong3, "reg2exeprogspath")
      xByteA1(xlong3) = 0

      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("RegSetValueEx: " + xChar1)
        DebugResult = RegSetValueEx_(xKeyLong2, @xChar1, 0, xLong1, @xByteA1(xLong4 + 1), xLong3 - 1 - xLong4)
        If DebugResult = 0
          WriteStringX("  ok?")
          Else
          WriteStringX("  failed (" + Trim(Str(DebugResult)) + ")?")
          EndIf
        CompilerElse
        RegSetValueEx_(xKeyLong2, @xChar1, 0, xLong1, @xByteA1(xLong4 + 1), xLong3 - 1 - xLong4)
        CompilerEndIf
      EndIf
    ElseIf xLong1 = 8
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("RegCreateKeyEx: " + xChar1)
      DebugResult = RegCreateKeyEx_(xLong2, @xChar1, 0, 0, 0, 983103, 0, @xKeyLong2, @xLong5)
      If DebugResult = 0
        WriteStringX("  ok?")
        Else
        WriteStringX("  failed (" + Trim(Str(DebugResult)) + ")?")
        xKeyLong2 = 0
        EndIf
      CompilerElse
      If RegCreateKeyEx_(xLong2, @xChar1, 0, 0, 0, 983103, 0, @xKeyLong2, @xLong5) <> 0 
        xKeyLong2 = 0
        EndIf
      CompilerEndIf
    ElseIf xLong1 = 9 Or xLong1 = 12
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("RegOpenKeyEx: " + xChar1)
      DebugResult = RegOpenKeyEx_(xLong2, @xChar1, 0, 983103, @xKeyLong2)
      If DebugResult = 0
        WriteStringX("  ok?")
        If xLong1 = 12
          WriteStringX("RegDeleteValuesEx_Sub")
          RegDeleteValuesEx(xKeyLong2)
          WriteStringX("  done")
          EndIf
        Else
        WriteStringX("  failed (" + Trim(Str(DebugResult)) + ")?")
        xKeyLong2 = 0
        EndIf
      CompilerElse
      If RegOpenKeyEx_(xLong2, @xChar1, 0, 983103, @xKeyLong2) <> 0
        xKeyLong2 = 0
        ElseIf xLong1 = 12
        RegDeleteValuesEx(xKeyLong2)
        EndIf
      CompilerEndIf
    ElseIf xLong1 = 10
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("RegDeleteKeysRecursive: " + xChar1)
      RegDeleteKeysRecursive(xLong2, xChar1, 0)
      WriteStringX("  done")
      CompilerElse
      RegDeleteKeysRecursive(xLong2, xChar1, 0)
      CompilerEndIf
    ElseIf xLong1 = 11
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("RegDeleteKeysRecursive: " + xChar1)
      xKeyLong2 = RegDeleteKeysRecursive(xLong2, xChar1, 1)
      WriteStringX("  done")
      CompilerElse
      xKeyLong2 = RegDeleteKeysRecursive(xLong2, xChar1, 1)
      CompilerEndIf
    Else
    ;Debug xLong1
    ;Debug xChar1
    ;Debug xChar2
    Goto Er2
    EndIf
  ;Delay(1)
  CheckProgress((Loc(FileAccessID) - ProgressStart) / ProgressWidth.l)
  ;If (Loc() - ProgressStart) / ProgressWidth.l < 0
  ;  Debug Str((Loc() - ProgressStart) / ProgressWidth.l)
  ;  EndIf
  Wend






CompilerIf #Compiler_Mode = 9999
          EndIf
        EndIf
      EndIf   
    EndIf

Rs2:
  If xKeyLong2 <> 0
    RegCloseKey_(xKeyLong2)
    EndIf
  End

Er2:
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("Error occured")
    CompilerEndIf
  Goto Rs2






  CompilerElse
; If xLong1 <> 0
;   If Left(xChar1, 3) = "R22"
;     If ReadData(xChar1, 3) = 3
;       If Left(xChar1, 3) = "R22"
          Else
          Goto Er2
          EndIf
        Else
        Goto Er2
        EndIf
      Else
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("Unusable: " + Trim(Str(Asc(Left(xChar1, 1)))) + "," + Trim(Str(Asc(Mid(xChar1, 2, 1))))+ "," + Trim(Str(Asc(Mid(xChar1, 3, 1)))))
        CompilerEndIf
      Goto Er2
      EndIf
    Else
    Goto Er2
    EndIf


Rs1:
  If xKeyLong2 <> 0
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("Closing key (Final)")
      CompilerEndIf
    RegCloseKey_(xKeyLong2)
    EndIf
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("Done")
    CompilerEndIf
  End

Er2:
  CheckProgress(-2)
  ;MessageRequester("Reg2exe 2.25","File damaged", #PB_MessageRequester_Ok)
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("######### Error File Damaged")
    CompilerEndIf
  Goto Rs1
  CompilerEndIf
















Procedure RegDeleteValuesEx(OpenKey.l)
  Define.l xLong1
  Define.l xLong2
  Define.l xLong3
  Define.s xChar1

  RegDeleteValue_(OpenKey, @xChar1) ; Manually delete default value + updates regestry
  Repeat
    xChar1 = Space(512)
    xLong2= 512
;    Select RegEnumValue_(OpenKey, xLong1, @xChar1, @xLong2, 0, 0, 0, 0)
    xLong3 = RegEnumValue_(OpenKey, xLong1, @xChar1, @xLong2, 0, 0, 0, 0)
;Debug xLong3
;Debug xChar1
    Select xLong3
      Case 259
        RegDeleteValue_(OpenKey, @xChar1)
        xChar1 = ""
        RegDeleteValue_(OpenKey, @xChar1)  ; Manually delete default value after updating regestry
        Break
      Case 0
        RegDeleteValue_(OpenKey, @xChar1)
        xLong1 = xLong1 + 1
      Default
        Break
      EndSelect
    ForEver
  EndProcedure


Procedure.l RegDeleteKeysRecursive(StartKey.l, SubKey.s, NoDeleteMain.l)
  Define.l xLong1
  Define.l xLong2
  Define.l xLong3
  Define.s xChar1

  If SubKey <> ""
    If RegOpenKeyEx_(StartKey, SubKey, 0, 983103, @xLong1) = 0
      Repeat
        xChar1 = Space(512)
        xLong3 = 512
        Select RegEnumKeyEx_(xLong1, xLong2, @xChar1, @xLong3, 0, 0, 0, 0)
;          Case 259
;  Debug "RegDelKey: " + SubKey
;            Break
          Case 0
            If SubKey
              xChar1 = SubKey + "\" + xChar1
              EndIf
            CompilerIf #Compiler_DebugMe = 1
              WriteStringX("  SubKey: " + xChar1)
              CompilerEndIf
            RegDeleteKeysRecursive(StartKey, xChar1, 0)
            xLong2 = xLong2 + 1
          Default
            Break
          EndSelect
        ForEver
      If NoDeleteMain = 0
        ;RegDeleteKey_(StartKey, SubKey)
        RegCloseKey_(xLong1) ;Key)
        CompilerIf #Compiler_DebugMe = 1
          WriteStringX("  DeleteKey: " + SubKey)
          WriteStringX("    Returns: " + Trim(Str(RegDeleteKey_(StartKey, @SubKey))))
          CompilerElse
          RegDeleteKey_(StartKey, @SubKey)
          CompilerEndIf
        Else
        ProcedureReturn xLong1 ; Key
        EndIf
      EndIf
    EndIf
  EndProcedure

Procedure.l InstrA(StartPos.l)
  Define.l xLong1

  For xLong1 = StartPos To 1048575
    If xByteA1(xLong1) = 0
      ProcedureReturn = xLong1
      EndIf
    Next
  EndProcedure

Procedure.s InstrRev(xChar1.s)
  Define.l xLong1
  Define.l xLong2

  While 1
    xLong1 = FindString(xChar1, "\", xLong2 + 1)
    If xLong1 = 0 
      Break
      Else
      xLong2 = xLong1
      EndIf
    Wend
  If xLong2 <> 0
    ProcedureReturn = Left(xChar1, xLong2 - 1)
    EndIf
  EndProcedure

Procedure.l ReplaceBinary (NewString.s, BinaryStart.l, BinaryEnd.l, OrigString.s)
  Define.l xLong1
  Define.l xLong2
  Define.l xLong3
  Define.l xLong4
  Define.l xLong5
  Define.s xChar1
  
  xLong5.l = Len(OrigString)

  For xLong1 = BinaryEnd - xLong5 - 1 To BinaryStart Step -1
    If xByteA1(xLong1) = 60 And xByteA1(xLong1 + xLong5 + 1) = 62 
      xChar1 = ""
      For xLong2 = xLong1 + 1 To xLong1 + xLong5
        xChar1 = xChar1 + Chr(xByteA1(xLong2))
        Next
;      If LCase(xChar1)="reg2exepath"
      If LCase(xChar1) = OrigString
        xLong2 = Len(NewString) 
        If xLong2 <> xLong5 + 2 
          If xLong2 < xLong5 + 2
;            Debug ("Longer" + OrigString)
            xLong3 = xLong5 + 2 - xLong2
            BinaryEnd = BinaryEnd - xLong3
            For xLong4 = xLong1 + xLong2 To BinaryEnd
              xByteA1(xLong4) = xByteA1(xLong4 + xLong3)
              Next
;            BinaryEnd = BinaryEnd - xLong3
            Else
;            Debug ("Shorter: " + OrigString)
            xLong3 = xLong2 - (xLong5 + 2)
            BinaryEnd = BinaryEnd + xLong3
            For xLong4 = BinaryEnd To xLong1 + xLong2 Step -1
              xByteA1(xLong4) = xByteA1(xLong4 - xLong3)
              Next
            EndIf
          EndIf
        For xLong3 = 0 To xLong2 - 1
          xByteA1(xLong1 + xLong3) = Asc(Mid(NewString, xLong3 + 1, 1))
          Next
        EndIf
      EndIf
    Next
  ProcedureReturn = BinaryEnd
  EndProcedure

;Procedure.s GetApiChar(Pointer.l)
;  If Pointer
;    ProcedureReturn PeekS(xLong1, 65535)
;    EndIf
;  EndProcedure

Procedure.s GetProgramsPath()
  Define.s xChar1

  xChar1 = RegReadString("Software\Microsoft\Windows\CurrentVersion", "ProgramFilesDir")
  If xChar1 = ""
    xChar1 = RegReadString("Software\Microsoft\Windows\CurrentVersion", "ProgramFilesPath")
    If xChar1 = ""
      xChar1 = RegReadString("HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SETUP\VarLDID", "28700")
      EndIf
    EndIf

  If xChar1 = ""
    xChar1 = "C:\Program Files"
    Else
    If Right(xChar1, 1) = "\"
      xChar1 = Left(xChar1, Len(xChar1) - 1)
      EndIf
    EndIf

  ProcedureReturn xChar1
  EndProcedure


Procedure.s RegReadString(uRGSection.s, uRGName.s)
  Define.l xLong1
  Define.l xLong2
  Define.l xLong3
  Define.l xLong4
  Define.s xChar1

;&H80000002
  If RegOpenKeyEx_(-2147483646, uRGSection, 0, 983103, @xLong1) = 0
;    Debug "Opened"
    xLong2 = 1024
    xChar1 = Space(xLong2)

;    xLong4 = RegQueryValueEx_(xLong1, uRGName, 0, xLong3, @xChar1, @xLong2)
;    If xLong4 = 0 And xLong2 > 0

    If RegQueryValueEx_(xLong1, uRGName, 0, xLong3, @xChar1, @xLong2) = 0
      If xLong2 > 0
        ProcedureReturn = Left(xChar1, xLong2 - 1)
        EndIf
      EndIf
    RegCloseKey_(xLong1)
    EndIf
  EndProcedure

Procedure.s GetCharEx(xChar1.s, xLong1.l)
  If xLong1
    If Right(xChar1, 1) = "\"
      xChar1 = Left(xChar1, Len(xChar1) - 1)
      EndIf
    ProcedureReturn xChar1
    EndIf
  EndProcedure
; ExecutableFormat=Windows
; EnableXP
; UseIcon=E:\VB6\Reg2Exe\Backup48.ico
; Executable=E:\VB6\Reg2Exe\Reg2exe.exe
; EOF

CompilerIf #Compiler_DebugMe = 1
  Procedure WriteStringX(xChar1.s)
    ;UseFile(#DebugFileID)
    WriteStringN(#DebugFileID, xChar1)
    Debug(xChar1)
    ;If FileOpened
      ;UseFile(FileAccessID)
    ;  EndIf
    EndProcedure
  CompilerEndIf

Procedure GetXPAccess()
;  '"SE_TAKE_OWNERSHIP_NAME"
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("Aquirering Privileges")
    CompilerEndIf


  Define.l xLong1
  Define.l xLong2
  Define.OSVERSIONINFO xType1
  Define.TOKEN_PRIVILEGES xType2
  Define.TOKEN_PRIVILEGES xType3
  
  xType1\dwOSVersionInfoSize = SizeOf(xType1)
  If GetVersionEx_(xType1) <> 0
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("  GetVersionEx ok, PlattformId = " + Trim(Str(xType1\dwPlatformId)))
      CompilerEndIf
    If xType1\dwPlatformId = 2
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("  OpenToken")
        CompilerEndIf
      If OpenProcessToken_(GetCurrentProcess_(), 40, @xLong2)
        xLong1 = LookupPrivilegeValue_(#Null, @"SeTakeOwnershipPrivilege", xType2\Privileges[0]\Luid)
        xType2\PrivilegeCount = 1
        xType2\Privileges[0]\Attributes = 2
        CompilerIf #Compiler_DebugMe = 1
          Define.l xLong999
          xLong999.l = AdjustTokenPrivileges_(xLong2, 0, xType2, SizeOf(xType3), xType3, xLong1)
          If xLong999 = 0
            WriteStringX("  ok")
            Else
            WriteStringX("  failed (" + Trim(Str(xLong999)) + ")")
            EndIf
          CompilerElse
          AdjustTokenPrivileges_(xLong2, 0, xType2, SizeOf(xType3), xType3, xLong1)
          CompilerEndIf
        EndIf
      EndIf
    EndIf
  EndProcedure

Procedure.l ReadByteX()
  ProcedureReturn ((256 + ReadByte(FileAccessID)) & 255)
  EndProcedure

CompilerIf #Compiler_Mode = 2
  Procedure WaitOnProgram(ProgramID.l)
    ;MessageRequester("Waiting for:", Hex(ProgramID))
    If ProgramID
      ProgramID = OpenProcess_(2035711, #False, ProgramID)
      Sleep(1000)
      While (WaitForSingleObject_(ProgramID, 256) = 258)
        Sleep(200)
        Wend
      CloseHandle_(ProgramID)
      EndIf
    EndProcedure

  Procedure.l ReadLongX()
    Define.l xLong1
    Define.l xLong2
    Define.l xLong3
    Define.l xLong4

    xLong1.l = ((256 + ReadByte(FileAccessID)) & 255)
;Debug ("0.1" + Str(xLong1))
    xLong2.l = ((256 + ReadByte(FileAccessID)) & 255)
;Debug ("0.2" + Str(xLong2))
    xLong3.l = ((256 + ReadByte(FileAccessID)) & 255)
;Debug ("0.3" + Str(xLong3))
    xLong4.l = ((256 + ReadByte(FileAccessID)) & 255)
;Debug ("0.4" + Str(xLong4))
    xLong1 = ((xLong1 * 256 + xLong2) * 256 + xLong3) * 256 + xLong4
;Debug ("0.5" + Str(xLong1))
    ProcedureReturn xLong1
    EndProcedure

  Procedure.s ReadStringX()
    Define.l xLong1
    Define.s xChar1

    Repeat
      xLong1 = ((256 + ReadByte(FileAccessID)) & 255)
      If xLong1 = 0
        Break
        Else
        xChar1 = xChar1 + Chr(xLong1)
        EndIf
      ForEver
    ProcedureReturn xChar1
    EndProcedure

  Procedure.s DeleteFileX(DefDir.s, Filename.s)
    Define.l xBool1
    Define.s xChar1
    Define.WIN32_Find_Data xType1

;Debug 1
    If LCase(Right(Filename, 4)) = ".lnk"
      xBool1 = 1
      Else
      If LCase(Left(Filename, Len(DefDir) + 1)) = LCase(DefDir) + "\"
        xBool1 = 1
        Else
;        Debug "0. " + FileName
;        Debug ("1. " + LCase(MidX(Filename, Len(DefDir) + 1)))
;        Debug ("2. " + LCase(DefDir) + "\")
        If MessageRequester("Warning", "Do you want to permit deletion of this file:" + Chr(13) + Filename, #PB_MessageRequester_YesNo) = 6
          xBool1 = 1
          EndIf
        EndIf
      EndIf

;Debug xBool1
;Debug Filename
    If xBool1
      If FindString(Filename, "?", 1) + FindString(Filename, "*", 1) ;Or 1
;        Debug ("DeleteDir.1: " + xChar1)
        xChar1 = InstrRev(Filename)
        If Not (Right(xChar1, 1) = "\" Or xChar1 = "")
          xChar1 + "\"
          EndIf
        ;Filename = MidX(Filename, Len(xChar1) + 2)
;        Debug ("DeleteDir.1: " + xChar1)
;        Debug ("DeleteDir.2: " + Filename)
        xType1\dwFileAttributes = $3F
        xBool1 = FindFirstFile_(Filename, @xType1)
        If Not xBool1 = #INVALID_HANDLE_VALUE
          Repeat
             ;DeleteDirectory(xChar1, Filename, #PB_FileSystem_Force)
            Filename = PeekS(@xType1\cFileName)
            ;Debug "File: " + xChar1 + Filename
            If Not (Left(FileName, 1) = "."  Or xType1\dwFileAttributes & 24)
              DeleteFile_(xChar1 + FileName)
              EndIf
            Until FindNextFile_(xBool1, @xType1) = 0
          FindClose_(xBool1)
          EndIf
        Else
        DeleteFile(Filename)
;        Debug ("DeleteFile: " + Filename)
        EndIf
      EndIf
    EndProcedure

  Procedure.s MidX(BaseString.s, Position.l)
    Define.l xLong1

    xLong1.l = Len(BaseString)
    If Position < xLong1
      BaseString = Mid(BaseString, Position, xLong1 - Position + 1)
      EndIf
    ProcedureReturn BaseString
    EndProcedure

  Procedure RunProgramX(FileName.s, RMode.l)
    Define.l xLong1
    Define.s xChar1
    Define.s xChar2

    Filename = MidX(Filename, 2)
    xLong1 = FindString(Filename, ",", 1)
    xChar1 = Left(Filename, xLong1 - 1)
    Filename = MidX(Filename, xLong1 + 1)
    xChar2 = InstrRev(xChar1)
    
    RunProgram(xChar1, Filename, xChar2, RMode)
    EndProcedure
  CompilerEndIf

Procedure.l DoEventsEx_IsTickCountElapsed(FirstTickCountValue.l, TimeIntervalMs.l)
  Static xLong1.l
  
  xLong1 = (GetTickCount_() & 1073741823)
  If xLong1 < FirstTickCountValue
    If (xLong1 + 1073741824 > FirstTickCountValue + TimeIntervalMs)
      ProcedureReturn 1
      EndIf
    Else
    If (xLong1 > FirstTickCountValue + TimeIntervalMs)
      ProcedureReturn 1
      EndIf
    EndIf
  EndProcedure

  Procedure Sleep(IntervalMS.l)
    ;Static xLong1.l
  
    ;xLong1 = CreateWaitableTimer_(0, -1, 0)
    ;While MsgWaitForMultipleObjects_(1, @xLong1, 0, IntervalMS, 255) = 0
    While MsgWaitForMultipleObjects_(0, 0, 0, IntervalMS, 255) = 0
      WindowEvent()
      Wend
    WindowEvent()
    ;CloseHandle_(xLong1)
    EndProcedure

Procedure.s LoadResStringA(ResID.l) ;, CanBeMultiLine.l)
    Define.l xLong1
    Define.s xChar1

    xChar1 = Space(32766)
    ; Debug Str(hInstance) + " - " + Str(ResID)
    xLong1 = LoadString_(hInstance, ResID, @xChar1, 32766)
    If xLong1
      xChar1 = Left(xChar1, xLong1)
      ;If CanBeMultiLine
      ;  xChar1 = ReplaceString(xChar1, "|", Chr(13), 2)
      ;  EndIf
      ;MessageRequester(Str(ResID), xChar1)
      ProcedureReturn xChar1
      EndIf
  ;MessageRequester(Str(ResID), xChar1)
  EndProcedure

Procedure.l CreateInstance() ;(ResID.l)
  Define.l xLong1
  Define.l xLong2

;  Debug "CreateI"
  If OpenWindow(0, 0, 0, 264, 40, "SelfReg", #PB_Window_WindowCentered | #PB_Window_ScreenCentered)
    xLong1 = WindowID(0)
    If xLong1
      hInstance = GetWindowLong_(xLong1, #GWL_HINSTANCE)
      ;Debug Str(hInstance)
      If hInstance
        SetWindowTitle(0, LoadResStringA(100))
        If CreateGadgetList(xLong1)
          xLong2 = LoadImage_(hInstance, "#1", 1, 32, 32, 32768)
          If xLong2
            SetClassLong_(xLong1, #GCL_HICON, xLong2)
            DestroyIcon_(xLong2)
            EndIf
          EndIf
        EndIf
      EndIf
    EndIf
  IsInterface = 1
  EndProcedure

Procedure CheckProgress(Progress.f)
  Static xLong1.l
  ;Static xLong2.l
  
CompilerIf #Compiler_Mode = 2
  If Progress = -2 Or Progress = -3
CompilerElse
  If Progress = -2
CompilerEndIf
    If IsInterface
      FreeGadget(1)
      ResizeGadget(0, 40, 4, 164, 32)
      CompilerIf #Compiler_Mode = 2
        If Progress = -3
          SetGadgetText(0, LoadResStringA(104))
          Else
          SetGadgetText(0, LoadResStringA(103))
          EndIf
        CompilerElse
        SetGadgetText(0, LoadResStringA(102))
        CompilerEndIf
      Else
      CreateInstance() ;(102)
      CompilerIf #Compiler_Mode = 2
        If Progress = -3
          TextGadget(0, 4, 4, 164, 32, LoadResStringA(104))
          Else
          TextGadget(0, 4, 4, 164, 32, LoadResStringA(103))
          EndIf
        CompilerElse
        TextGadget(0, 4, 4, 256, 16, LoadResStringA(102))
        CompilerEndIf
      EndIf
    CompilerIf #Compiler_Mode = 2
      ButtonGadget(1, 170, 11, 90, 25, LoadResStringA(109), #PB_Button_Default)
      CompilerElse
      ButtonGadget(1, 170, 11, 90, 25, LoadResStringA(103), #PB_Button_Default)
      CompilerEndIf
    ;Debug "StartWait"
    Repeat
      If WaitWindowEvent() = #PB_Event_Gadget And EventGadget() = 1
        ;Debug "Yes - " + Str(EventType())
        Select EventType()
          ;Case 0
          ;  Debug "Yes!!"
          Case #PB_EventType_LeftClick
            Break
          Case #PB_EventType_RightClick
            Break
          Case #PB_EventType_LeftDoubleClick
            Break
          Case #PB_EventType_RightDoubleClick
            Break
          EndSelect
        EndIf
      ForEver
    ElseIf Progress = -1 
    xLong1 = GetTickCount_() & 1073741823
    ElseIf IsInterface = 0
CompilerIf #Compiler_Mode = 2
CompilerElse
    If DoEventsEx_IsTickCountElapsed(xLong1, 1000) And Progress < 0.25
CompilerEndIf
      CreateInstance() ;(101)
      TextGadget(0, 4, 4, 256, 16, LoadResStringA(101))
      ProgressBarGadget(1, 4, 20, 256, 16, 0, 1024)
      SetGadgetState(1, Progress * 1024)
      Sleep(200)
      xLong1 = GetTickCount_() & 1073741823
CompilerIf #Compiler_Mode = 2
CompilerElse
      EndIf
CompilerEndIf
    ElseIf DoEventsEx_IsTickCountElapsed(xLong1, 200)
    SetGadgetState(1, Progress * 1024)
    Sleep(200)
    xLong1 = GetTickCount_() & 1073741823
    EndIf
  EndProcedure

; IDE Options = PureBasic v4.00 (Windows - x86)
; CursorPosition = 186
; FirstLine = 179
; Folding = ----
; EnableXP
; Executable = Reg2exe.exe
; DisableDebugger
; VersionField0 = 2.25
; VersionField1 = 2.25
; VersionField2 = ctuser
; VersionField3 = Reg2exe
; VersionField4 = 2.25
; VersionField5 = 2.25
; VersionField6 = Reg2exe 'converter'
; VersionField7 = Reg2exe
; VersionField8 = Reg2exe.exe
; VersionField9 = Copyright 2002-2006 by Jan Vorel; Published under the GNU General Public License
; VersionField18 = Comments
; VersionField21 = Published under the GNU General Public License; homepage: http://www.ctuser.net; Compressed with upx: http://upx.sourceforge.net
; AddResource = E:\VB6\Reg2Exe\Selfreg.rc