Attribute VB_Name = "mod_ctCompressA_Decompress"
' Copyright (C) 2004-2006 Jan Vorel
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues

Option Explicit
Option Base 0

Private Const DASMSize As Long = &H4C38&
Private Type HeapData
  ptrDataIn As Long
  ptrDataOut As Long
  ProgressHandler As Long
  ProgressControl As Long
  ProgressStart As Long
  ProgressTotal As Long
  ProgressQueue As Long
  End Type
Private Const HeapDataSize As Long = 28&
Private Declare Function VirtualAlloc Lib "kernel32" (ByVal lpAddress As Long, ByVal dwSize As Long, ByVal flAllocationType As Long, ByVal flProtect As Long) As Long
Private Declare Function VirtualFree Lib "kernel32" (ByVal lpAddress As Long, ByVal dwSize As Long, ByVal dwFreeType As Long) As Long
Private Declare Sub RtlMoveMemory Lib "kernel32" (Destination As Any, Source As Any, ByVal Length As Long)

Public Function ctCompressA_Decompress(ByRef Data As String, ByVal OriginalSize As Long, Optional ByVal ProgressHandler As Long, Optional ByVal ProgressControl As Long = 0&, Optional ByVal ProgressStart As Long = 0&, Optional ByVal ProgressTotal As Long = 0&, Optional ByVal ProgressQueue As Long = 0&) As String
  Dim hHeap As Long
  Dim hMemIn As Long
  Dim hMemOut As Long
  Dim xLong1 As Long
  Dim xByteA1() As Byte
  Dim xType1 As HeapData
  
  If Not OriginalSize = 0& Then
    
'OriginalSize = &HFFFFFF

    xByteA1() = LoadResData("ctCompressA_Decompress", "DASM")
    If Not UBound(xByteA1) = 0& Then
      hHeap = VirtualAlloc(0&, DASMSize, &H1000&, 4&)
      If hHeap Then
        hMemIn = VirtualAlloc(0&, Len(Data), &H1000&, 4&)
        If hMemIn Then
          hMemOut = VirtualAlloc(0&, OriginalSize, &H1000&, 4&)
          If hMemOut Then
            Call RtlMoveMemory(ByVal hMemIn, ByVal Data, Len(Data))
'            Stop
            Data = ""
            With xType1
              .ptrDataIn = hMemIn
              .ptrDataOut = hMemOut
              .ProgressHandler = ProgressHandler
              .ProgressControl = ProgressControl
              .ProgressStart = ProgressStart
              .ProgressTotal = ProgressTotal
              .ProgressQueue = ProgressQueue
              End With
            Call RtlMoveMemory(ByVal hHeap, xType1, HeapDataSize)
'            Stop
            xLong1 = CallFunctionFast(VarPtr(xByteA1(0)), hHeap)
'            Stop
            If xLong1 = OriginalSize Then
              ctCompressA_Decompress = String(OriginalSize, vbNullChar)
              Call RtlMoveMemory(ByVal ctCompressA_Decompress, ByVal hMemOut, OriginalSize)
              Else
              'Stop
              ctCompressA_Decompress = ""
              End If
            Call VirtualFree(hMemOut, 0&, &H8000&)
            End If
          Call VirtualFree(hMemIn, 0&, &H8000&)
          End If
        Call VirtualFree(hHeap, 0&, &H8000&)
        End If
      End If
    End If
  End Function

'a$="This is a basic test":b$=ctcompressa_compress(a$)
'? ctcompressa_decompress(b$,len(a$))

