; Copyright (C) 2004-2006 Jan Vorel
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
; This is a shared modul, class modul, usercontrol or form. It is also
; published under the GNU General Public License.
;
; If you have any questions, suggestions or bug reports about this product,
; contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
; language or A.P.I. issues

EnableExplicit

#CodeName = "ctCompressA_Decompress.dasm"

Goto xSkip

;#Size = 9*8 + 11*4 + 8 + 4*256 + 4*256


!MemIncSize = $10
!MemIncFilt = $0f
#HeapPos_ptrDataIn        =  $0
!HeapPos_ptrDataIn        =  $0
#HeapPos_ptrDataOut       =  $4
!HeapPos_ptrDataOut       =  $4
#HeapPos_ProgressHandler  =  $8
!HeapPos_ProgressHandler  =  $8
#HeapPos_ProgressControl  =  $C
!HeapPos_ProgressControl  =  $C
#HeapPos_ProgressStart    = $10
!HeapPos_ProgressStart    = $10
#HeapPos_ProgressTotal    = $14
!HeapPos_ProgressTotal    = $14
#HeapPos_ProgressQueue    = $18
!HeapPos_ProgressQueue    = $18

#HeapPos_X                = $1C
!HeapPos_X                = $1C
#HeapPos_Y                = $20
!HeapPos_Y                = $20
#HeapPos_OrgLen_ByteValue = $24
!HeapPos_OrgLen_ByteValue = $24
#HeapPos_NumberOfNodes    = $28
!HeapPos_NumberOfNodes    = $28
#HeapPos_NuNode           = $2C
!HeapPos_NuNode           = $2C
#HeapPos_TotBits          = $30
!HeapPos_TotBits          = $30
#HeapPos_TelBits          = $34
!HeapPos_TelBits          = $34
#HeapPos_Nulen            = $38
!HeapPos_Nulen            = $38

#HeapPos_LenBits = #HeapPos_Nulen
!HeapPos_LenBits =  HeapPos_Nulen
#HeapPos_Bits = #HeapPos_LenBits +     4*256
!HeapPos_Bits =  HeapPos_LenBits +     4*256
#HeapPos_LeafA = #HeapPos_Bits +       32*256
!HeapPos_LeafA =  HeapPos_Bits +       32*256
#HeapPos_LeafB = #HeapPos_LeafA +      4*256
!HeapPos_LeafB =  HeapPos_LeafA +      4*256

#HeapPos_TreeNodesA = #HeapPos_LeafB + 4*256
!HeapPos_TreeNodesA =  HeapPos_LeafB + 4*256
#HeapPos_TreeNodesB = #HeapPos_TreeNodesA + 4*512
!HeapPos_TreeNodesB =  HeapPos_TreeNodesA + 4*512
#HeapPos_TreeNodesC = #HeapPos_TreeNodesB + 4*512
!HeapPos_TreeNodesC =  HeapPos_TreeNodesB + 4*512
#HeapPos_TreeNodesE = #HeapPos_TreeNodesC + 4*512
!HeapPos_TreeNodesE =  HeapPos_TreeNodesC + 4*512

#Size = #HeapPos_TreeNodesE + 4*512
!Size =  HeapPos_TreeNodesE + 4*512




ASMCode:

ctCompressA_Decompress:
PUSH ebx
MOV edx, [esp + 8]


    MOV eax, [edx + HeapPos_ptrDataIn]
    MOV ecx, [eax]
    BSWAP ecx
    SHR ecx, 1
    ADD eax, 4
    MOV [edx + HeapPos_ptrDataIn], eax
    MOV [edx + HeapPos_TotBits], ecx

; First ForNext

    SHL ecx, 2 ;max
    ADD ecx, edx
    MOV eax, edx ;cnt
    MOV ebx, [edx + HeapPos_ptrDataIn]

!xtra1:
    ADD eax, HeapPos_LeafA
    MOV byte dl, [ebx]
    MOV [eax], byte dl
    INC ebx

    ADD eax, HeapPos_LeafB - HeapPos_LeafA
    MOV byte dl, [ebx]
    MOV [eax], byte dl
    INC ebx

    SUB eax, (HeapPos_LeafB - 4) ;  auto inc 4
; Why isn't + 8 here...??????????????????????
    MOV edx, [esp + 8]
    
    CMP eax, ecx
    JNZ xtra1
    
    MOV [edx + HeapPos_ptrDataIn], ebx
    
; Done
    MOV [edx + HeapPos_TelBits], dword -1



















;Debug PeekL(Heap + #HeapPos_TotBits)

;    For X = 0 To PeekL(Heap + #HeapPos_TotBits) - 1


MOV [edx + HeapPos_X], dword -1

!theloop10:
;Debug "Loop"


MOV ecx, [edx + HeapPos_X]
INC ecx
MOV eax, [edx + HeapPos_TotBits]
CMP ecx, eax
JE finish10


MOV [edx + HeapPos_X], ecx










;      For Y = 1 To LeafB(X)
;    MOV ecx, [edx + HeapPos_X]
    SHL ecx, 2
    MOV ecx, [edx + ecx + HeapPos_LeafB]
    PUSH ecx
    OR ecx, ecx
    JZ breakloop11
!doloop11:








    MOV ecx, [edx + HeapPos_X]
    SHL ecx, 2



    MOV eax, [edx + HeapPos_TelBits]
    INC eax
    JNZ noincr
    
    MOV [edx + HeapPos_TelBits], dword 7
    MOV eax, [edx + HeapPos_ptrDataIn]
    MOVZX ebx, byte [eax]
    MOV [edx + HeapPos_OrgLen_ByteValue], ebx
    INC eax
    MOV [edx + HeapPos_ptrDataIn], eax



!noincr:


;!redoaftermem:
    MOV ecx, [edx + ecx + HeapPos_LeafA]
    SHL ecx, 2

    MOV ebx, [edx + HeapPos_LenBits + ecx]

;Debug "a"
    MOV eax, ebx
    INC eax
    MOV [edx + HeapPos_LenBits + ecx], eax

;rebit
    MOV eax, ecx
    SHL eax, 3
    ADD eax, edx
    ADD eax, HeapPos_Bits
    ADD eax, ebx



    MOV ebx, [edx + HeapPos_TelBits]
    MOV ecx, ebx
    DEC ecx
    MOV [edx + HeapPos_TelBits], ecx
    
    MOVZX ecx, byte [edx + HeapPos_OrgLen_ByteValue]
    BT ecx, ebx
    MOV ebx, 0
    !Jc iszero
    INC ebx
    !iszero:
;eax = 1/0    

    MOV [eax], byte bl

;next

    

!breakloop11:
    MOV ecx, [esp]
    DEC ecx
    MOV [esp], ecx
    JNZ doloop11

POP ecx



JMP theloop10


!finish10:












;  TreeNodesC(0) = -1
  MOV [edx + HeapPos_TreeNodesB], dword $ffffffff
  MOV [edx + HeapPos_TreeNodesC], dword $ffffffff




;    For X = 0 To 255
MOV eax, 0
!loopnowforx:
MOV [edx + HeapPos_X], eax







;        For Y = 0 To LenBits(X) - 1

MOV eax, [edx + HeapPos_X]
SHL eax, 2
ADD eax, edx
ADD eax, HeapPos_LenBits
MOV eax, [eax]

OR eax, eax
JZ lenbitsiszero


;MOV [edx + HeapPos_NuNode], dword 0





PUSH eax


MOV eax, 0

  ;MOV ecx, 0; [edx + HeapPos_NuNode]
  ;SHL ecx, 2
  ;ADD ecx, edx
  MOV ecx, edx

!theloop22:
;rebit
;Debug "A"
MOV [edx + HeapPos_Y], eax
MOV ebx, [edx + HeapPos_X]
SHL ebx, 5
ADD ebx, edx
ADD ebx, HeapPos_Bits




ADD eax, ebx
MOVZX eax, byte [eax]

OR eax, eax
JZ noneedc
MOV eax, HeapPos_TreeNodesB - HeapPos_TreeNodesC
!noneedc:
ADD eax, HeapPos_TreeNodesC



;for 0:
;MOV eax, HeapPos_TreeNodesC

        ; TmpToNode ebx
      MOV ebx, [ecx + eax]
      CMP ebx, dword $ffffffff
      JNE noadd


      ; number of nodex eax
      MOV ebx, [edx + HeapPos_NumberOfNodes]
      INC ebx
      MOV [edx + HeapPos_NumberOfNodes], ebx
      MOV [ecx + eax], ebx
      MOV eax, ebx ; -> tonode -> later nunode
      
      SHL eax, 2
      ADD eax, edx
      MOV [eax + HeapPos_TreeNodesB], dword $ffffffff
      MOV [eax + HeapPos_TreeNodesC], dword $ffffffff
      
      
      

!noadd:
      MOV ecx, ebx
      SHL ecx, 2
      ADD ecx, edx














MOV eax, [edx + HeapPos_Y]
INC eax
MOV ebx, [esp]
CMP eax, ebx
JNE theloop22

POP eax

MOV ebx, [edx + HeapPos_X]


MOV [ecx + HeapPos_TreeNodesA], ebx
MOV [ecx + HeapPos_TreeNodesE], dword 255




!lenbitsiszero:
MOV eax, [edx + HeapPos_X]
INC eax
CMP eax, dword 256
JNE loopnowforx

;MOV [edx + HeapPos_X], eax




; Prog1
;JMP noprog
MOV ecx, [edx + HeapPos_ProgressHandler]
OR ecx, ecx
JZ noprog

;JMP noprog
MOV eax, [edx + HeapPos_ProgressQueue]
;MOV eax, 100
MOV ebx, 100
MOV edx, 0
DIV dword ebx
MOV edx, [esp + 8]
PUSH dword [edx + HeapPos_ProgressTotal]
MOV ebx, [edx + HeapPos_ProgressQueue]
SUB ebx, eax
MOV [edx + HeapPos_ProgressQueue], ebx
MOV ebx, [edx + HeapPos_ProgressStart]
ADD ebx, eax
MOV [edx + HeapPos_ProgressStart], ebx


PUSH ebx
PUSH dword [edx + HeapPos_ProgressControl]

CALL ecx
MOV edx, [esp + 8]
OR eax, eax
JNZ aborting
!noprog:








    MOV eax, [edx + HeapPos_ptrDataIn]
    MOV ecx, [eax]
    BSWAP ecx
    ADD eax, 4
    MOV [edx + HeapPos_ptrDataIn], eax
    MOV [edx + HeapPos_OrgLen_ByteValue], ecx

    MOV [edx + HeapPos_TelBits], dword 7





    MOV ecx, 0
    MOV [edx + HeapPos_NuNode], ecx
    MOV [edx + HeapPos_Nulen], ecx
    
    JMP endlooppos
!theloop:

  MOV eax, [edx + HeapPos_TelBits]
  MOV ecx, [edx + HeapPos_ptrDataIn]
  CMP eax, -1
  JNE telbitsnotneg1

  INC ecx
  MOV [edx + HeapPos_ptrDataIn], ecx
  MOV eax, 7
  MOV [edx + HeapPos_TelBits], eax

!telbitsnotneg1:


MOV ecx, [edx + HeapPos_NuNode]
SHL ecx, 2


MOV ebx, [edx + HeapPos_TelBits]
;MOV ebx, 0
;BTS ebx, eax

MOV eax, [edx + HeapPos_ptrDataIn]
MOVZX eax, byte [eax]

BT eax, ebx
MOV eax, 0
;AND eax, ebx
JC NeedC
  MOV eax, HeapPos_TreeNodesB - HeapPos_TreeNodesC
!NeedC:
ADD eax, HeapPos_TreeNodesC

ADD eax, edx
ADD eax, ecx

MOV ecx, [eax]








  OR ecx, ecx
  JZ error

  MOV [edx + HeapPos_NuNode], ecx

  SHL ecx, 2




;      If TreeNodesE(NuNode) = 255
        MOV eax, edx
        ADD eax, HeapPos_TreeNodesE
        ADD eax, ecx

        MOV ebx, [eax]
        CMP ebx, 255
        JNE no255

        ;INC ebx
        ;MOV [eax], ebx
        


;        MOV eax, edx ;[edx + HeapPos_TreeNodesA]
        SUB eax, HeapPos_TreeNodesE - HeapPos_TreeNodesA
;        ADD eax, ecx
        MOV al, [eax]
        
        MOV ebx, [edx + HeapPos_ptrDataOut]
        MOV [ebx], al
        INC ebx
        MOV [edx + HeapPos_ptrDataOut], ebx


;        MOV ebx, 

        MOV [edx + HeapPos_NuNode], dword 0

        MOV ecx, [edx + HeapPos_Nulen]
        INC ecx
        MOV [edx + HeapPos_Nulen], ecx


;!no255:
;        MOV ecx, [edx + HeapPos_Nulen]


      MOV eax, [edx + HeapPos_TelBits]
      DEC eax
      MOV [edx + HeapPos_TelBits], eax




; nulen ecx

; Prog1
;JMP noprog2

;PUSH dword 3
;PUSH dword ecx
;PUSH dword 1
;MOV eax, [edx + HeapPos_ProgressHandler]
;CALL eax
;JMP noprog2x


MOV eax, ecx
AND eax, $1ffff
JZ noprog2


MOV eax, [edx + HeapPos_ProgressHandler]
OR eax, eax
JZ noprog2


;JMP noprog2x
;JMP noprog2
MOV eax, ecx
MOV ecx, [edx + HeapPos_OrgLen_ByteValue]
MOV ebx, [edx + HeapPos_ProgressQueue]
MOV edx, 0
MUL dword ebx
DIV dword ecx
;JMP noprog2x

MOV edx, [esp + $8]
;JMP noprog2x


PUSH dword [edx + HeapPos_ProgressTotal]
MOV ebx, [edx + HeapPos_ProgressStart]
ADD ebx, eax
PUSH ebx
PUSH dword [edx + HeapPos_ProgressControl]

MOV eax, [edx + HeapPos_ProgressHandler]
CALL eax
OR eax, eax
JNZ aborting2

!noprog2x:
MOV edx, [esp + $8]
MOV ecx, [edx + HeapPos_Nulen]


!noprog2:



!endlooppos:
;        MOV ecx, [edx + HeapPos_Nulen]













; Nulen ecx!
;    While Nulen < PeekB(Heap + #HeapPos_OrgLen_ByteValue)
    MOV eax, [edx + HeapPos_OrgLen_ByteValue]
    CMP ecx, eax
    JL theloop


;  MOV eax, 3
  POP ebx
  RET 4


!no255:
    MOV eax, [edx + HeapPos_TelBits]
    DEC eax
    MOV [edx + HeapPos_TelBits], eax

;!endlooppos:
    MOV ecx, [edx + HeapPos_Nulen]
    MOV eax, [edx + HeapPos_OrgLen_ByteValue]
    CMP ecx, eax
    JL theloop
;  MOV eax, 2
  POP ebx
  RET 4

!error:
  MOV eax, dword $ffffffff
;  MOV eax, 1
  POP ebx
  RET 4

!aborting2:
POP eax
!aborting:
MOV eax, dword $fffffffe
POP ebx
RET 4
ASMCodeEnd:









xSkip:
;#Size = 9*8 + 11*4 + 8 + 4*256 + 4*256
Procedure Prog(HWndProgress.l, ProgressPosition, ProgressTotal)
  ;End
  Static xLong1.l
  Define.l xLong2 = GetTickCount_()
  
  If xLong2 - xLong1 > 1000
    OutputDebugString_("Progress: " + Str(ProgressPosition) + " / " + Str(ProgressTotal))
    xLong1 = xLong2
    EndIf
  ProcedureReturn 0
  ;Debug ProgressPosition
  EndProcedure

Define *Heap = AllocateMemory(#Size)
Define *Mem = AllocateMemory($C2B000)


PokeL(*Heap + #HeapPos_ptrDataIn, ?TestData)
PokeL(*Heap + #HeapPos_ptrDataOut, *Mem)
PokeL(*Heap + #HeapPos_ProgressHandler, @Prog())
PokeL(*Heap + #HeapPos_ProgressControl, 1)
PokeL(*Heap + #HeapPos_ProgressStart, 0)
PokeL(*Heap + #HeapPos_ProgressTotal, $C2B000)
PokeL(*Heap + #HeapPos_ProgressQueue, $C2B000)

OutputDebugString_("Start...")
Define.l xLong1 = CallFunctionFast(?ctCompressA_Decompress, *Heap)
OutputDebugString_("done: " + Hex(xLong1))
;Debug PeekS(*Mem, xLong1)
;Debug Hex(Len(PeekS(*Mem, xLong1)))
;Debug CallFunctionFast(?PowerTwo, 8)






















DataSection
TestData:
  IncludeBinary "c:\large.bin"
TestDataD:
  EndDataSection
  
  
  
  
  
  
  
  
  
  
  
Define *BufferFIN = AllocateMemory(?ASMCodeEnd - ?ASMCode)
If *BufferFIN
  CopyMemory(?ASMCode, *BufferFIN, ?ASMCodeEnd - ?ASMCode)
  Define.l xLong2 = CreateFile(#PB_Any, "d:\dev\software\libraries\ctcompressa\" + #CodeName)
  If xLong2
    WriteData(xLong2, *BufferFIN, ?ASMCodeEnd - ?ASMCode)
    CloseFile(xLong2)
    EndIf
  FreeMemory(*BufferFIN)
  EndIf

Debug #Size
Debug Hex(#Size)
OutputDebugString_("Size: " + Str(#Size))
OutputDebugString_("HSize: " + Hex(#Size))

; IDE Options = PureBasic v4.02 (Windows - x86)
; CursorPosition = 786
; FirstLine = 737
; Folding = -
; EnableAsm
; Executable = d90.dll
; DisableDebugger