; Copyright (C) 2001-2008 Jan Vorel

; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

; This is a shared modul, class modul, usercontrol or form. It is also
; published under the GNU General Public License.

; If you have any questions, suggestions or bug reports about this product,
; contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
; language or A.P.I. issues

#Compiler_Mode = 2
#Compiler_DebugMe = 0;1
; 0 = default
; 1 = debug
; 2 = ctuninst
#More = 0





CompilerIf #Compiler_DebugMe = 1
  Declare WriteStringX(xChar1.s)
  CompilerEndIf









CompilerIf #More
  Procedure.l MemCheck(Mode.l, AllocFlag.l, ptr.l, Reason.s)
    
    CompilerIf #More = 2
      Static Dim xPtrs(999)
      Static Dim xSize(999)
      Static Dim xReas.s(999)
      Static xPtrCount.l
      Define.l xLong1
      CompilerEndIf
    
    Select Mode
      Case 0
        CompilerIf #More = 2
          Define.l Success
          Debug "Free: " + Str(ptr)
          For xLong1 = 0  To xPtrCount - 1
            If xPtrs(xLong1) = ptr
              xPtrCount - 1
              xPtrs(xLong1) = xPtrs(xPtrCount)
              xSize(xLong1) = xSize(xPtrCount)
              xReas(xLong1) = xReas(xPtrCount)
              Success = 1
              ;Debug "  ok"
              Break
              EndIf
            Next
          If Success = 0
            Debug "  Failed!"
            EndIf
          CompilerEndIf
;        LocalFree_(ptr)
        FreeMemory(ptr)
      Case 1

CompilerIf #Compiler_DebugMe = 1
  WriteStringX("Alloc0 - " + Str(xPtrCount))
  CompilerEndIf

        CompilerIf #More = 2
          If Not AllocFlag = #LMEM_FIXED
            Debug "NonFixed"
            EndIf
          If ptr < 2
            Debug "Small: " + Str(ptr)
            EndIf
          xSize(xPtrCount) = ptr
          ;ptr = LocalAlloc_(AllocFlag, ptr)
          CompilerEndIf
        ;Debug "WantAlloc: " + Str(ptr) + " (" + Reason + ")"
CompilerIf #Compiler_DebugMe = 1
  WriteStringX("Alloc1")
  CompilerEndIf

;        ptr = LocalAlloc_(#LMEM_FIXED, ptr)
        ptr=AllocateMemory(ptr)
CompilerIf #Compiler_DebugMe = 1
  WriteStringX("Alloc2 - " + Str(ptr))
  CompilerEndIf

        CompilerIf #More = 2
          Debug "Alloc: " + Str(ptr) + " (" + Reason + ")"
          xPtrs(xPtrCount) = ptr
          xReas(xPtrCount) = Reason
          xPtrCount + 1
          CompilerEndIf
        ProcedureReturn ptr
  CompilerIf #More = 2
      Case 2
        For xLong1 = 0  To xPtrCount - 1
          If xPtrs(xLong1) = AllocFlag
            If ptr >= AllocFlag And ptr <= AllocFlag + xSize(xLong1)
              Debug "Check: " + Str(ptr)            
              ;Debug "  ok"
              Else
  ;            Debug "  found"
              Debug "Check: " + Str(ptr)
              Debug "  From " + Str(AllocFlag)
              Debug "  To " + Str(AllocFlag + xSize(xLong1))
              Debug "  Is " + Str(ptr)
              EndIf
            Break
            EndIf
          Next
      Case 3
        Debug "--- MemsLeft ---"
        For xLong1 = 0  To xPtrCount - 1
          Debug xReas(xLong1)
          Next
  CompilerEndIf
      EndSelect
  
  
  
    EndProcedure
  CompilerEndIf



; Copyright (C) 2001-2008 Jan Vorel

; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

; This is a shared modul, class modul, usercontrol or form. It is also
; published under the GNU General Public License.

; If you have any questions, suggestions or bug reports about this product,
; contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
; language or A.P.I. issues

;#Compiler_Mode = 2
;#Compiler_DebugMe = 0

; 0 = default
; 1 = debug
; 2 = ctuninst


Import "kernel32.lib"
  lstrlenA.l(*Param1)
  lstrlenW.l(*Param1)
  GetModuleFileNameA.l(*Param1, *Param2, *Param3)
  GetModuleFileNameW.l(*Param1, *Param2, *Param3)
  GetWindowsDirectoryA.l(*Param1, *Param2)
  GetWindowsDirectoryW.l(*Param1, *Param2)
  GetSystemDirectoryA.l(*Param1, *Param2)
  GetSystemDirectoryW.l(*Param1, *Param2)
  GetTempPathA.l(*Param1, *Param2)
  GetTempPathW.l(*Param1, *Param2)
  
  CreateFileA.l(*Param1, *Param2, *Param3, *Param4, *Param5, *Param6, *Param7)
  CreateFileW.l(*Param1, *Param2, *Param3, *Param4, *Param5, *Param6, *Param7)


  CompilerIf #Compiler_Mode = 2
    CreateProcessA.l(*lpApplicationName, *lpCommandLine, *lpProcessAttributes, *lpThreadAttributes, *bInheritHandles, *dwCreationFlags, *lpEnvironment, *lpCurrentDirectory, *lpStartupInfo, *lpProcessInformation)
    CreateProcessW.l(*lpApplicationName, *lpCommandLine, *lpProcessAttributes, *lpThreadAttributes, *bInheritHandles, *dwCreationFlags, *lpEnvironment, *lpCurrentDirectory, *lpStartupInfo, *lpProcessInformation)
    RemoveDirectoryW.l(*Param1)
    RemoveDirectoryA.l(*Param1)
    DeleteFileW.l(*Param1)
    DeleteFileA.l(*Param1)
    CompilerEndIf
  EndImport


  CompilerIf #Compiler_Mode = 2
    Import "shlwapi.lib"
      MessageBoxW.l(*hwnd, *lpText, *lpCaption, *wType)
      EndImport
    CompilerEndIf

Import "shlwapi.lib"
  PathRemoveFileSpecA.l(*Param1)
  PathRemoveFileSpecW.l(*Param1)
  EndImport

Import "advapi32.lib"
  RegCreateKeyExA.l(*hKey, *lpSubKey, *Reserved, *lpClass, *dwOptions, *samDesired, *lpSecurityAttributes, *phkResult, *lpdwDisposition)
  RegCreateKeyExW.l(*hKey, *lpSubKey, *Reserved, *lpClass, *dwOptions, *samDesired, *lpSecurityAttributes, *phkResult, *lpdwDisposition)
  RegOpenKeyExA.l(*hKey, *lpSubKey, *dwOptions, *samDesired, *phkResult)
  RegOpenKeyExW.l(*hKey, *lpSubKey, *dwOptions, *samDesired, *phkResult)
  RegSetValueExA.l(*hKey, *lpValueName, *Reserved, *lpType, *lpData, *lpchData)
  RegSetValueExW.l(*hKey, *lpValueName, *Reserved, *lpType, *lpData, *lpchData)
  RegEnumValueA.l(*Param1, *Param2, *Param3, *Param4, *Param5, *Param6, *Param7, *Param8)
  RegEnumValueW.l(*Param1, *Param2, *Param3, *Param4, *Param5, *Param6, *Param7, *Param8)
  RegDeleteValueA.l(*hKey, *lpValueName)
  RegDeleteValueW.l(*hKey, *lpValueName)
  RegEnumKeyExA.l(*Param1, *Param2, *Param3, *Param4, *Param5, *Param6, *Param7, *Param8)
  RegEnumKeyExW.l(*Param1, *Param2, *Param3, *Param4, *Param5, *Param6, *Param7, *Param8)
  RegDeleteKeyA.l(*hKey, *lpSubKey)
  RegDeleteKeyW.l(*hKey, *lpSubKey)
  EndImport

Import "shell32.lib"
  ;SHGetPathFromIDListA(*Param1, *Param2)
  SHGetPathFromIDListW(*Param1, *Param2)
  EndImport


Declare CheckProgress(Progress.f)
Declare.l DoEventsEx_IsTickCountElapsed(FirstTickCountValue.l, TimeIntervalMs.l)
Declare Sleep(IntervalMS.l)
Declare.s LoadResStringA(ResID.l) ;, CanBeMultiLine.l)
Declare.l CreateInstance() ;(ResID.l)
Declare RegDeleteValuesEx(OpenKey.l)
Declare.l RegDeleteKeysRecursive(StartKey.l, *SubKey, LenSubkey.l, NoDeleteMain.l)
Declare GetXPAccess()
Declare.l AllocAndRead(ReadAsW.l, Size.l, MemID.l)
Declare MakeA(*ptrString, NumChars)
Declare MakeW(*ptrString, NumChars)
Declare.l RegCreateKeyEx(HKey.l, SubKey.l, LenSubKey.l)
Declare.l RegOpenKeyEx(HKey.l, SubKey.l, LenSubKey.l)
Declare RegDeleteValue(HSKey.l, Name.l, LenName.l)
Declare.l ReadFileFailsLong(*Buffer, Bytes.l)
Declare.l FileSeekFails(NewPos.l)




CompilerIf #Compiler_Mode = 2
  Declare DeleteFileX(xLen.l)
  Declare.s MidX(BaseString.s, Position.l)
  Declare RunProgramX(RMode.l, xLen)
  Declare.l SelfTerminate()
  ;Declare Uninstall(hWnd, hInst, lpszCmdLine, CmdShow)



ProcedureDLL AttachProcess(Instance)
  Global hModule.l = Instance
  EndProcedure
ProcedureDLL Uninstall(hWnd, hInst, lpszCmdLine, CmdShow)
CompilerEndIf







Global xFileTime.FILETIME

; PRGNAME=Reg2exe 2.25
; VERSION=2,24,0,0
; COMMENTS=Compressed with UPX (http://upx.sourceforge.net)
; COMPANY=ctuser
; DESCRIP=Reg2exe 'converter'
; LEGALCOPYRIGHT=2001-2005 by Jan Vorel
; E-MAIL=info@ctuser.net
; WEB=http://www.ctuser.net


Global IsUnicode.l
Define.l LOF_File
Define.l xLong1
Define.l xLong2
Define.l xLong3
Define.l xLong4
Define.l xLong5
Define.s xChar1
Define.s xChar2
Define.l xKeyLong2

Global Dim xAppPaths.l(9)
Global Dim xAppPathsLen.l(4)
Dim xAppPathsR.l(4)
Dim xAppPathsRL.l(4)
; 0 = CurDir
; 1 = Win
; 2 = Sys
; 3 = temp
; 4 = Progs

Define.l ProgressStart
Define.l ProgressWidth

Global hInstance.l
Global IsInterface.l
CompilerIf #Compiler_Mode = 2
  Define.StartupInfo xType1
  Define.Process_Information xType2

  ;Declare WaitOnProgram(ProgramID.l)

  Global Dim *Mem(1)
  CompilerEndIf


GetXPAccess()


Define.l xAppPath


CompilerIf #More
  xAppPath = MemCheck(1, #LMEM_FIXED, $204, "AppPath")
  CompilerElse
  xAppPath = AllocateMemory($204)
  CompilerEndIf
If xAppPath
  If IsUnicode
    CompilerIf #Compiler_Mode = 2
      xLong2 = GetModuleFileNameW(hModule, xAppPath, $101)
      CompilerElse
      xLong2 = GetModuleFileNameW(0, xAppPath, $101)
      CompilerEndIf
    CompilerIf #Compiler_DebugMe = 1
      CompilerIf #Compiler_Mode = 2
        ;PokeS(xAppPath, "C:\Q0510B\PROGRAMS\My Company\My Application2\ctUninst.exe", -1, #PB_Unicode)
        PokeS(xAppPath, "C:\Q0511A\PROGRAMS\My Company\My Application\ctuninst.dll", -1, #PB_Unicode)
        CompilerElse
        PokeS(xAppPath, "D:\Dev\Software\Tools\Reg2exe\Testc.exe", -1, #PB_Unicode)
        CompilerEndIf
      CompilerEndIf
    Else
    CompilerIf #Compiler_Mode = 2
      xLong2 = GetModuleFileNameA(hModule, xAppPath, $101)
      CompilerElse
      xLong2 = GetModuleFileNameA(0, xAppPath, $101)
      CompilerEndIf
    CompilerIf #Compiler_DebugMe = 1
      CompilerIf #Compiler_Mode = 2
        ;okeS(xAppPath, "C:\Q0510B\PROGRAMS\My Company\My Application2\ctUninst.exe")
        PokeS(xAppPath, "C:\Q0511A\PROGRAMS\My Company\My Application\ctuninst.dll")
        CompilerElse
        PokeS(xAppPath, "D:\Dev\Software\Tools\Reg2exe\Testc.exe")
        CompilerEndIf
      CompilerEndIf
    EndIf
  ;xLong7 = xLong2
  EndIf


;MessageRequester("2","0")


CompilerIf #Compiler_DebugMe = 1
  #DebugFileID = 1
  xChar1 = ProgramFilename() ; AppBase()
  xChar1 = Left(xChar1, Len(xChar1) - 3) + "log"
  CreateFile(#DebugFileID, xChar1)
  CompilerEndIf






Define.l xLong7
Global FileAccessID.l
Global LocAPI.l


CompilerIf #Compiler_Mode = 2
  If IsUnicode
    FileAccessID = CreateFileW(xAppPath, $80000000, 1, 0, 3, $20, 0)
    Else
    FileAccessID = CreateFileA(xAppPath, $80000000, 1, 0, 3, $20, 0)
    EndIf
  CompilerIf #Compiler_DebugMe = 1
    If IsUnicode
      WriteStringX("ReadFile: " + PeekS(xAppPath, -1, #PB_Unicode))
      Else
      WriteStringX("ReadFile: " + PeekS(xAppPath))
      EndIf
    WriteStringX("ReadFile: " + Trim(Str(FileAccessID)))
    CompilerEndIf

;MessageRequester("2", PeekS(xAppPath))

  If FileAccessID = -1: Goto Er2: EndIf
  LOF_File = GetFileSize_(FileAccessID, @xLong1)
  If xLong1 Or LOF_File < 15: Goto Er2: EndIf

  If FileSeekFails(LOF_File - 8): Goto Er2: EndIf
  If ReadFileFailsLong(@xLong1, 4): Goto Er2: EndIf
  If ReadFileFailsLong(@xLong2, 4): Goto Er2: EndIf
  If Not xLong2 = $32557463: Goto Er2: EndIf ; ctU2

  If FileSeekFails(xLong1): Goto Er2: EndIf
  If ReadFileFailsLong(@xLong1, 4): Goto Er2: EndIf
  If Not xLong1 = $32557463: Goto Er2: EndIf ; ctU2

  If ReadFileFailsLong(@xLong7, 4): Goto Er2: EndIf


  If ReadFileFailsLong(@xLong1, 4): Goto Er2: EndIf
  If AllocAndRead(xLong1 & $80000000, xLong1 & $ffffff, 0): Goto Er2: EndIf
  Define.s xUninstIDStr = PeekS(*Mem(0), xLong1 & $ffffff, #PB_Unicode)

  If ReadFileFailsLong(@xLong1, 4): Goto Er2: EndIf
  xLong6 = (xLong1 & $ffffff)
  If AllocAndRead(xLong1 & $80000000, xLong6, 1): Goto Er2: EndIf

  If ReadFileFailsLong(@xLong1, 4): Goto Er2: EndIf
  xLong5 = (xLong1 & $ffffff)
  If AllocAndRead(xLong1 & $80000000, xLong5, 0): Goto Er2: EndIf
  xLong2 = xLong5 + 1

  If IsUnicode
    ;xLong1 = lstrlenW(xAppPath)
    ;If xLong1 > 3
    ;  xChar2 = PeekS(xAppPath + xLong1 * 2 - 8, 4, #PB_Unicode)
    ;  EndIf
    RtlMoveMemory_(xAppPath, *Mem(0), xLong5 * 2)
    PokeW(xAppPath + xLong5 * 2, $5C)
    PokeW(xAppPath + xLong5 * 2 + 2, 0)
    Else
    ;xLong1 = lstrlenA(xAppPath)
    ;If xLong1 > 3
    ;  xChar2 = PeekS(xAppPath + xLong1 - 4, 4)
    ;  EndIf
    xChar1 = PeekS(*Mem(0), xLong5, #PB_Unicode) + Chr($5C)
    PokeS(xAppPath, xChar1, xLong2)
    EndIf
  CompilerEndIf








#TheWidth = $13
#TheWidthW = #TheWidth * 2
#TheWidthX = #TheWidth - 1

For xLong1 = 0 To 4
  CompilerIf #More
    xAppPaths(xLong1) = MemCheck(1, #LMEM_FIXED, $204, "AppPath2")
    CompilerElse
    xAppPaths(xLong1) = AllocateMemory($204)
    CompilerEndIf
  If xAppPaths(xLong1)
    CompilerIf #More
      xAppPathsR(xLong1) = MemCheck(1, #LMEM_FIXED, #TheWidthW, "AppPath3")
      CompilerElse
      xAppPathsR(xLong1) = AllocateMemory(#TheWidthW)
      CompilerEndIf
    If xAppPathsR(xLong1)
      RtlMoveMemory_(xAppPathsR(xLong1), ?RegRepPathStrs + xLong1 * #TheWidth, #TheWidth)
      xAppPathsRL(xLong1) = lstrlenA(xAppPathsR(xLong1))
      CallFunctionFast(?MakeExW, xAppPathsR(xLong1), xAppPathsRL(xLong1))

      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("Pathvar: " + PeekS(xAppPathsR(xLong1), -1, #PB_Unicode))
        CompilerEndIf
      
      
      Select xLong1
        Case 0
          If xAppPath
            RtlMoveMemory_(xAppPaths(0), xAppPath, xLong2 * (IsUnicode + 1))
            If IsUnicode
              PathRemoveFileSpecW(xAppPaths(0))
              xAppPathsLen(0) = lstrlenW(xAppPaths(0))
              Else
              PathRemoveFileSpecA(xAppPaths(0))
              xAppPathsLen(0) = lstrlenA(xAppPaths(0))
              EndIf
            EndIf
        Case 1
          If IsUnicode
            xAppPathsLen(1) = GetWindowsDirectoryW(xAppPaths(1), $101)
            Else
            xAppPathsLen(1) = GetWindowsDirectoryA(xAppPaths(1), $101)
            EndIf
        Case 2
          If IsUnicode
            xAppPathsLen(2) = GetSystemDirectoryW(xAppPaths(2), $101)
            Else
            xAppPathsLen(2) = GetSystemDirectoryA(xAppPaths(2), $101)
            EndIf
        Case 3
          If IsUnicode
            xAppPathsLen(3) = GetTempPathW($101, xAppPaths(3))
            Else
            xAppPathsLen(3) = GetTempPathA($101, xAppPaths(3))
            EndIf
        Case 4
          If SHGetSpecialFolderLocation_(0, 2, @xLong3) = 0
            If IsUnicode
              If SHGetPathFromIDListW(xLong3, xAppPaths(4)) = 1
                xAppPathsLen(4) = lstrlenW(xAppPaths(4))
                EndIf
              Else
              If SHGetPathFromIDList_(xLong3, xAppPaths(4)) = 1
                xAppPathsLen(4) = lstrlenA(xAppPaths(4))
                EndIf
              EndIf
            CoTaskMemFree_(xLong3)
            EndIf
;          MessageRequester("1", "1")
          ;xAppPathsLen(4) = GetProgramsPath(xAppPaths(4))
        EndSelect
      If xAppPathsLen(xLong1)
        If IsUnicode
          xLong2 = xAppPaths(xLong1) + (xAppPathsLen(xLong1) - 1) * 2
          If PeekW(xLong2) = 92 ; \
            PokeW(xLong2, 0)
            xAppPathsLen(xLong1) - 1
            EndIf
          Else
          xLong2 = xAppPaths(xLong1) + xAppPathsLen(xLong1) - 1
          If PeekB(xLong2) = 92 ; \
            PokeB(xLong2, 0)
            xAppPathsLen(xLong1) - 1
            EndIf
          
          MakeW(xAppPaths(xLong1), xAppPathsLen(xLong1))

          CompilerIf #Compiler_DebugMe = 1
            WriteStringX("  is: " + PeekS(xAppPaths(xLong1), -1, #PB_Unicode))
            WriteStringX("  ln: " + Str(xAppPathsLen(xLong1)))
            CompilerEndIf
          
          
          
          
          
          EndIf
        CompilerIf #More
          xAppPaths(xLong1 + 5) = MemCheck(1, #LMEM_FIXED, $204, "AppPathV")
          CompilerElse
          xAppPaths(xLong1 + 5) = AllocateMemory($204)
          CompilerEndIf
        If xAppPaths(xLong1 + 5)
          
          ;RtlMoveMemory_(xAppPaths(xLong1 + 5), xAppPaths(xLong1), $102)
          ;PokeL(xAppPaths(xLong1 + 5), $04440444)
          ;PokeL(xAppPaths(xLong1 + 5) + 4, $044B0443)
          ;PokeS(xAppPaths(xLong1 + 5), PeekS(xAppPaths(xLong1 + 5), -1, #PB_Unicode))
          
          
          PokeS(xAppPaths(xLong1 + 5), PeekS(xAppPaths(xLong1), -1, #PB_Unicode))

          CallFunctionFast(?MakeExW, xAppPaths(xLong1 + 5), xAppPathsLen(xLong1))
          CompilerIf #Compiler_DebugMe = 1
            Debug "VirtualAnsi: " + PeekS(xAppPaths(xLong1 + 5), -1, #PB_Unicode)
            CompilerEndIf
          ; For Ansi in data sections, data is filled with 0 bytes, checked/replaced and stripped of the nulls
          ; this way any ANSI replacement stuff is handled vie the unicode
          ; Doing so by replacing with the real unicode string, when stripping the nulls would corrupt the new
          ; path string as no unicode conversation is done, just simply a logical "char AND $00ff".
          ; Instead the path is converted to ansi and made "unicode' by doing the same nullbyte filling.
          Else
          xAppPathsLen(xLong1) = 0
          EndIf
        EndIf
      If xAppPathsLen(xLong1) = 0
        ;MemCheck(0, 0, xAppPathsR(xLong1), "")
        ;MemCheck(0, 0, xAppPaths(xLong1), "")
        xAppPaths(xLong1) = 0
        EndIf
      Else
      ;MemCheck(0, 0, xAppPaths(xLong1), "")
      xAppPaths(xLong1) = 0
      EndIf
    EndIf
  Next

CompilerIf #Compiler_DebugMe = 1
  If IsUnicode
    WriteStringX("Attempting file: " + PeekS(xAppPath, -1, #PB_Unicode))
    Else
    WriteStringX("Attempting file: " + PeekS(xAppPath))
    EndIf
  CompilerEndIf












CompilerIf #Compiler_Mode = 2
;Debug "SelfTest"


;Debug xLong3
;Debug PeekS(*Mem(1), -1, #PB_Unicode)
;Debug xAppPathsLen(3)
;Debug PeekS(xAppPaths(3), -1, #PB_Unicode)
;Debug xAppPathsLen(3) + 13
;If IsUnicode
;  Debug PeekS(xAppPath, -1, #PB_Unicode)
;  Else
;  Debug PeekS(xAppPath)
;  EndIf
;Debug xLong5
;Debug PeekS(*Mem(2), -1, #PB_Unicode)
;Debug xChar2




;checkext
;  If LCase(xChar2) = ".tmp": Goto IsSelf: EndIf

;Goto IsSelf



  CompilerIf #More
    xLong1 = MemCheck(1, #LMEM_FIXED, $304, "DelFileConfirm")
    CompilerElse
    xLong1 = AllocateMemory($304)
    CompilerEndIf
  If xLong1 = 0: Goto Er2: EndIf
  xLong6 * 2

  #xMsgPost = Chr(13) + "(Please ensure the programm is not running before continuing)"
  #xMsgPostLen = 62
  #xMsgPostLenW = #xMsgPostLen * 2
  
  RtlMoveMemory_(xLong1, *Mem(1), xLong6)
  PokeS(xLong1 + xLong6, #xMsgPost, #xMsgPostLen, #PB_Unicode)
  PokeS(*Mem(1), "ctUninst", 8, #PB_Unicode)
  ;PokeB(xLong1 + #xMsgPostLenW + xLong3, 0)
  xLong6 = MessageBoxW(0, xLong1, *Mem(1), #MB_YESNO | #MB_ICONQUESTION)
  CompilerIf #More
    MemCheck(0, 0, xLong1, "")
    CompilerElse
    FreeMemory(xLong1)
    CompilerEndIf
  
  If Not xLong6 = #IDYES: Goto EndThisMisery: EndIf

  


;
;CompilerEndIf

IsSelf:
  CheckProgress(0)
  ;ProgressStart = Val(ProgramParameter())
  ;If ProgressStart
  ;  WaitOnProgram(OpenProcess_(2035711, #False, ProgressStart))
  ;  EndIf

  ProgressStart = LocAPI
  ProgressWidth = LOF_File - ProgressStart - 8
  SetGadgetText(0, LoadResStringA(101))
;Debug "***"
;Debug xLong5
;Debug lstrlenW(*Mem(2))

  For xLong1 = 1 To xLong7


    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("Item " + Str(xLong1) + " / " + Str(xLong7))
      WriteStringX("Pos: " + Hex(xLong2))
      CompilerEndIf


;Debug "Item " + Str(xLong1) + " / " + Str(xLong7)
;Debug "Pos: " + Hex(xLong2)

    If ReadFileFailsLong(@xLong3, 4): Goto Er2: EndIf
    If AllocAndRead(xLong3 & $80000000, xLong3 & $ffffff, 1): Goto Er2: EndIf
;    If (xLong3 & $80000000): xLong2 + (xLong3 & $ffffff): EndIf

;    xLong5 = lstrlenW(*Mem(2))
    xLong4 = ((xLong3 >> 24) & $f)
    xLong3 = (xLong3 & $ffffff)
;    xLong2 + xLong3 + 4

    If xLong4 = 1
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("RemoveDir: " + PeekS(*Mem(1), -1, #PB_Unicode))
        CompilerEndIf
      If IsUnicode
        RemoveDirectoryW(*Mem(1))
        Else
        xChar1 = PeekS(*Mem(1), -1, #PB_Unicode)
        RemoveDirectoryA(@xChar1)
        EndIf
      ElseIf xLong4 = 0
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("DeleteFile")
        CompilerEndIf
;Debug "td"
      DeleteFileX(xLong3)
      ElseIf xLong4 > 1 And xLong4 < 6
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("RunProg")
        CompilerEndIf
;Debug "tr"
      RunProgramX(xLong4, xLong3)
      Else
;Debug "ue"
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("Break, unknown whattodo")
        CompilerEndIf
      Goto Er2
      EndIf
    CheckProgress((LocAPI - ProgressStart) / ProgressWidth)
    Next
  
;Debug "Pos: " + Hex(SetFilePointer_(FileAccessID, 0, 0, #FILE_CURRENT))
;Goto EndThisMisery




CompilerIf #Compiler_DebugMe = 1
  WriteStringX("Done uninstaller specific, doing reg2exe")
  CompilerEndIf










  CompilerElse
  If IsUnicode
    FileAccessID = CreateFileW(xAppPath, $80000000, 1, 0, 3, $20, 0)
    Else
    FileAccessID = CreateFileA(xAppPath, $80000000, 1, 0, 3, $20, 0)
    EndIf

  CompilerIf #Compiler_DebugMe = 1
    If IsUnicode
      WriteStringX("ReadFile: " + Trim(Str(FileAccessID)) + " from " + PeekS(xAppPath, -1, #PB_Unicode))
      Else
      WriteStringX("ReadFile: " + Trim(Str(FileAccessID)) + " from " + PeekS(xAppPath))
      EndIf
    CompilerEndIf

  If FileAccessID = -1: Goto Er2: EndIf
  LOF_File = GetFileSize_(FileAccessID, @xLong1)
  If xLong1 Or LOF_File < 10: Goto Er2: EndIf
    If FileSeekFails(LOF_File - 6): Goto Er2: EndIf
    If ReadFileFailsLong(@xLong1, 2): Goto Er2: EndIf
    ReadFileFailsLong(@xLong3, 4)
    If xLong3 = $30333252 ;R230
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("Processing regdata")
        CompilerEndIf
      If FileSeekFails(xLong1): Goto Er2: EndIf
      ReadFileFailsLong(@xLong3, 4)
      If xLong3 = $30333252 ;R230
  CompilerEndIf













CompilerIf #Compiler_Mode = 2

ProgressStart = LocAPI
ProgressWidth = LOF_File - 17
;CheckProgress(-1)
SetGadgetText(0, LoadResStringA(102))
While LocAPI < LOF_File - 17

  Debug "Pos: " + Hex(LocAPI) + ", " + Hex(LOF_File - 17)

CompilerElse

Global Dim *Mem(1)
ProgressStart.l = LocAPI
ProgressWidth.l = LOF_File - 7
CheckProgress(-1)
While LocAPI < LOF_File - 7

CompilerEndIf

  ; 1=size1, 2=createmode/size2, 3=type/hkey/delmode
  If ReadFileFailsLong(@xLong3, 4): Goto Er2: EndIf
  If ReadFileFailsLong(@xLong1, 2): Goto Er2: EndIf

  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("TypeA: " + Hex(xLong3))
    WriteStringX("Size1: " + Hex(xLong1))
    CompilerEndIf


  If AllocAndRead((xLong3 & $80000000), xLong1, 0): Goto Er2: EndIf
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("Read!, pokeW0")
    CompilerEndIf

  PokeW(*Mem(0) + xLong1 * 2, 0) ;0 terminate!


  CompilerIf #Compiler_DebugMe = 1
    WriteStringX(" StrA: " + PeekS(*Mem(0), xLong1, #PB_Unicode))
    CompilerEndIf

  
  xLong2 = (xLong3 >> 24) & $f ;(7f) ;is type or hkey?

  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("TypeB: " + Hex(xLong2))
    CompilerEndIf


  If xLong2
    If xKeyLong2
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("Closing key")
        CompilerEndIf
      RegCloseKey_(xKeyLong2)
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("  done")
        CompilerEndIf
      xKeyLong2 = 0
      EndIf
    xLong3 = (xLong3 & $00ffffff) | $80000000
   

;          ' 8 makedir       'xxxxxxxxxxx
;          ' 9 opendir       'xxxxxxxxxxx (does not create if not exists!!!)
;          '10 deldir        'xxxxxxxxxxx
;          '11 delsubdirs    'deletes all subkeys. key left open for writting values
;          '12 delmainvalues 'deletes all values in the directory itself. key left open for writting values


    Select xLong2
      Case 1
        xKeyLong2 = RegCreateKeyEx(xLong3, *Mem(0), xLong1)
      Case 2, 5
        xKeyLong2 = RegOpenKeyEx(xLong3, *Mem(0), xLong1)
        If xKeyLong2 And xLong2 = 5
          CompilerIf #Compiler_DebugMe = 1
            WriteStringX("RegDeleteValuesEx_Sub")
            CompilerEndIf
          RegDeleteValuesEx(xKeyLong2)
          CompilerIf #Compiler_DebugMe = 1
            WriteStringX("RegDeleteValuesEx_done")
            CompilerEndIf
          EndIf
      Case 3 ,4
        xKeyLong2 = RegDeleteKeysRecursive(xLong3, *Mem(0), xLong1, xLong2 - 3)
        ;CompilerIf #Compiler_DebugMe = 1
        ;  WriteStringX("RegDeleteKeysRecursive: " + xChar1)
        ;  xKeyLong2 = RegDeleteKeysRecursive(xLong3, xChar1, xLong2 - 3)
        ;  WriteStringX("  done")
        ;  CompilerElse
        ;  xKeyLong2 = RegDeleteKeysRecursive(xLong3, xChar1, xLong2 - 3)
        ;  CompilerEndIf
      Default
        Goto Er2
      EndSelect







    Else

    If (xLong3 & $3fffffff)
      If ReadFileFailsLong(@xLong2, 4)
        Goto Er2
        EndIf

      
;          ' 0 delvalue
;          ' 1 string
;          ' 2 hex(x)
;          ' 3 hex
;          ' 4 dword
      ;If (xLong3 & $40000000)
      

      xLong5 = xLong3
      xLong3 = (xLong3 & $3fffffff)


      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("ReplaceBinary stuff")
        CompilerEndIf

      Select xLong3
        Case 1, 2, 7
          If AllocAndRead((xLong5 & $40000000), xLong2, 1): Goto Er2: EndIf
        Default
          If AllocAndRead(1, xLong2, 1): Goto Er2: EndIf
          
        EndSelect
      If xKeyLong2



        Select xLong3
          Case 1, 2, 7
xLong2 * 2
      PokeB(*Mem(1) + xLong2, 0) ;0 terminate!
            
            
            RetPos = ?RepPos1
RepPos1:
            Goto ReplaceNow


;            xLong2 + 1
          Default
            ;Define.l RealSize = xLong2 & 1
            ;xLong2 + RealSize
;Debug "ToProcess: " + PeekS(*Mem(0), -1, #PB_Unicode)
;Debug "  " + PeekS(*Mem(1))
;Debug "Len: " + Str(xLong2)
;xLong2 - 1
            CallFunctionFast(?MakeExW, *Mem(1), xLong2)
            xLong2 * 2

Define.l ReplaceExtra = 5

RetPos = ?RepPos2
RepPos2:
Goto ReplaceNow


ReplaceExtra = 0


            xLong2 / 2
;Debug "Len: " + Str(xLong2)
;            Gosub ReplaceNow
            CallFunctionFast(?MakeExA, *Mem(1), xLong2)

            ;xLong2 * 2
            Define.l xLong2Fix = (xLong2 & 1)
            xLong2 & $fffffffe

RetPos = ?RepPos3
RepPos3:
Goto ReplaceNow

*Mem(1) + 1
;If xLong2Fix
;  Gosub ReplaceNow
;  xLong2 + 1
;  Else
;  xLong2 - 2
;  Gosub ReplaceNow
;  xLong2 + 2
;  EndIf
RetPos = ?RepPos4
RepPos4:
Goto ReplaceNow

xLong2 + xLong2Fix
*Mem(1) - 1
;            xLong2 + xLong2Fix
            ;xLong2 / 2

;xLong2 + 1
;Debug "Len: " + Str(xLong2)


          EndSelect


        CompilerIf #Compiler_DebugMe = 1
          WriteStringX("RegSetValueEx: " + PeekS(*Mem(0), -1, #PB_Unicode))
          CompilerEndIf
      
        If IsUnicode
          RegSetValueExW(xKeyLong2, *Mem(0), 0, xLong3, *Mem(1), xLong2)
          Else
          MakeA(*Mem(0), xLong1)
          Select xLong3
            Case 1, 2, 7
              MakeA(*Mem(1), xLong2)
              xLong2 = (xLong2 >> 1) & $7fffffff ; \2
              PokeB(*Mem(1) + xLong2, 0)
            EndSelect
          RegSetValueExA(xKeyLong2, *Mem(0), 0, xLong3, *Mem(1), xLong2)
          EndIf
        EndIf
      ElseIf xKeyLong2
      RegDeleteValue(xKeyLong2, *Mem(0), xLong1)
      EndIf
    EndIf
  ;Delay(1)
  CheckProgress((LocAPI - ProgressStart) / ProgressWidth.l)
  ;If (LocAPI() - ProgressStart) / ProgressWidth.l < 0
  ;  EndIf
  Wend






















CompilerIf #Compiler_Mode = 2
  ;
  If xKeyLong2
    RegCloseKey_(xKeyLong2)
    EndIf

  xChar1 = "Software\Microsoft\Windows\CurrentVersion\Uninstall\" + xUninstIDStr
  RegDeleteKeyA(-2147483646, @xChar1)
  
  xChar2 = "Software\ctUser\ctInst\" + xUninstIDStr
  RegDeleteKeyA(-2147483646, @xChar2)
  xChar1 = xChar2 + "\Components"
  RegDeleteKeyA(-2147483646, @xChar1)
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("Self-terminating...")
    CompilerEndIf



#StackThis = $40
#StackTerm = $40
#StackFind = $20
#StackTermFind = #StackTerm + #StackFind
#StackNeed = #StackThis + #StackTerm + #StackFind ; - ...?


CloseHandle_(FileAccessID)

SUB esp, #StackNeed
          SelfTerminate()
;ADD esp, #StackNeed


Rs2:
  If xKeyLong2
    RegCloseKey_(xKeyLong2)
    EndIf





  Goto EndThisMisery

Er2:
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("Error occured")
    CompilerEndIf
  Goto Rs2






  CompilerElse
; If xLong1
;   If Left(xChar1, 3) = "R22"
;     If ReadData(xChar1, 3) = 3
;       If Left(xChar1, 3) = "R22"
;          Else
;          Goto Er2
;          EndIf
        Else
        Goto Er2
        EndIf
      Else
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("Unusable: " + Trim(Str(Asc(Left(xChar1, 1)))) + "," + Trim(Str(Asc(Mid(xChar1, 2, 1))))+ "," + Trim(Str(Asc(Mid(xChar1, 3, 1)))))
        CompilerEndIf
      Goto Er2
      EndIf
    ;Else
    ;Goto Er2
;    EndIf
;Debug "NormalExit"
;Debug *Mem(1)

Rs1:
  ;If *Mem(0): MemCheck(0, 0, *Mem(0), ""): EndIf
  ;If *Mem(1): MemCheck(0, 0, *Mem(1), ""): EndIf
  ;For xLong1 = 0 To 4
    ;If xAppPaths(xLong1)
    ;  xAppPaths(xLong1) = MemCheck(0, 0, xAppPaths(xLong1), "")
    ;  EndIf
    ;Next

  If xKeyLong2
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("Closing key (Final)")
      CompilerEndIf
    RegCloseKey_(xKeyLong2)
    EndIf
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("Done")
    CompilerEndIf
  CompilerIf #More
    MemCheck(3, 0, 0, "")
    CompilerEndIf
  Goto EndThisMisery

Er2:
  CheckProgress(-2)
  ;MessageRequester("Reg2exe 2.25","File damaged", #PB_MessageRequester_Ok)
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("######### Error File Damaged")
    CompilerEndIf
  Goto Rs1
  CompilerEndIf


;Debug "What"






ReplaceNow:
;Return

xLong5 = 0
Repeat



;  Debug xLong4
  If xLong5 < xLong2
    ;Debug xLong5
    ;Debug xLong2
  ;If xLong5 + xAppPathsRL(xLong4) * 2 < *Mem(1) + xLong2 - xLong5
    
    CompilerIf #More
;      Debug "FF"
;      Debug *Mem(1) + xLong5
;      Debug xLong2
;      Debug xLong5
      MemCheck(2, *Mem(1), *Mem(1) + xLong5 + 1, "")
      MemCheck(2, *Mem(1), *Mem(1) + xLong5 + (xLong2 - xLong5) + 1, "")
      CompilerEndIf

    
    
    CompilerIf #Compiler_Mode = 2
      xLong5 = CallFunctionFast(?FindFastWX, *Mem(1) + xLong5, xLong2 - xLong5, 60)
      CompilerElse
      xLong5 = CallFunctionFast(?FindFastWX, *Mem(1) + xLong5, xLong2 - xLong5)
      CompilerEndIf
    
    If xLong5
      ;Debug "  Maybe found at: " + Str(xLong5)
      ;Debug "    " + PeekS(*Mem(1), -1 , #PB_Unicode)


      CompilerIf #More
        Debug "--- ExtraCheck1 ---"
        ;Debug *Mem(1)
        ;Debug xLong5
        ;Debug xLong2
        MemCheck(2, *Mem(1), *Mem(1) + xLong2, "")
        CompilerEndIf
  ;
      For xLong4 = 0 To 4
  
        If xLong5 + xAppPathsRL(xLong4) * 2 < *Mem(1) + xLong2 + 2
  
          ;Debug "--- ExtraCheck2 ---"
          CompilerIf #More
            MemCheck(2, *Mem(1), xLong5 + xAppPathsRL(xLong4) * 2, "")
            CompilerEndIf
  
  
          If CallFunctionFast(?CompareMemoryFastWX, xLong5, xAppPathsR(xLong4), xAppPathsRL(xLong4))
           ; Debug "ok"
            xLong7 = xLong2 + (xAppPathsLen(xLong4) - xAppPathsRL(xLong4)) * 2
;            Debug "From: " + Str(xLong2 / 2)
;            Debug PeekS(*Mem(1), -1, #PB_Unicode)
;            Debug PeekS(*Mem(1))
;            Debug xAppPathsLen(xLong4)
;            Debug xAppPathsRL(xLong4)
;            Debug "SL: " + Str(xLong7 / 2)
            ;Debug "From: " + Str(xLong2 / 2)
            
;MessageRequester("Make","11")
            CompilerIf #More
              Define *xLong6 = MemCheck(1, #LMEM_FIXED, (xLong7 + 2) * 2, "Replace")
              CompilerElse
              Define *xLong6 = AllocateMemory((xLong7 + 2) * 2)
              CompilerEndIf
            If *xLong6
              Define.l xLong8 = (xLong5 - *Mem(1) - 1) * 2
              ;Debug "  MidDs: " + Str(*xLong6)
;              Debug "  MidTo: " + Str(xLong8)
              ;Debug "  MidLn: " + Str(xAppPathsLen(xLong4) * 2)
              ;Debug "  NewSz: " + Str(xLong7)
              ;Debug "  New1: " + Str(*xLong6 + xLong7 + 2)
              ;Debug "  New2: " + Str(*xLong6 + xLong8 + xAppPathsLen(xLong4) * 2)
              ;Debug PeekS(xAppPaths(xLong4), -1, #PB_Unicode)
              
              If xLong8 > 0
;                Debug "--- PoX1 ---"
                CompilerIf #More
                  MemCheck(2, *xLong6, *xLong6 + xLong8, "")
;                  Debug "--- PoX2 ---"
                  MemCheck(2, *Mem(1), *Mem(1) + xLong8, "")
                  CompilerEndIf
                RtlMoveMemory_(*xLong6, *Mem(1), xLong8)
                Else
                xLong8 = 0
                EndIf
              
              CompilerIf #More
                Debug "--- PosToWrite ---"
                MemCheck(2, *xLong6, *xLong6 + xLong8, "")
                Debug "--- WhenWritten ---"
                MemCheck(2, *xLong6, *xLong6 + xLong8 + xAppPathsLen(xLong4) * 2 - -1, "")
                Debug "--- ReadRead ---"
                ;Debug ReplaceExtra
                MemCheck(2, xAppPaths(xLong4 + ReplaceExtra), xAppPaths(xLong4 + ReplaceExtra) + xAppPathsLen(xLong4) * 2 - 2, "")
                CompilerEndIf
              RtlMoveMemory_(*xLong6 + xLong8, xAppPaths(xLong4 + ReplaceExtra), xAppPathsLen(xLong4) * 2)
              ;RtlMoveMemory_(*xLong6 + xLong8, *Mem(1), 16)

              CompilerIf #More
                Debug "--- PosToWrite2 ---"
                MemCheck(2, *Mem(1), xLong5 + xAppPathsRL(xLong4) * 2 + *Mem(1) + xLong2 - xAppPathsRL(xLong4) * 2 - xLong5 - 1, "")
                MemCheck(2, *xLong6, *xLong6 + xLong8 + xAppPathsLen(xLong4) * 2 + *Mem(1) + xLong2 - xAppPathsRL(xLong4) * 2 - xLong5 - 1, "")
                CompilerEndIf
              
              RtlMoveMemory_(*xLong6 + xLong8 + xAppPathsLen(xLong4) * 2, xLong5 + xAppPathsRL(xLong4) * 2, *Mem(1) + xLong2 - xAppPathsRL(xLong4) * 2 - xLong5)
  
              PokeW(*xLong6 + xLong7, 0)
  
;              Debug "  New: " + PeekS(*xLong6, -1, #PB_Unicode)
;              Debug "Len: " + Str(xLong7 / 2)
  
              ;Debug "# OffSet1: " + Str(xLong5 - *Mem(1))
              xLong5 = *xLong6 + xLong5 - *Mem(1)
              ;Debug "# OffSet2: " + Str(xLong5 - *xLong6)
  
              CompilerIf #More
                MemCheck(0, 0, *Mem(1), "")
                CompilerElse
                FreeMemory(*Mem(1))
                CompilerEndIf
              *Mem(1) = *xLong6
              xLong2 = xLong7
              EndIf
            Break
            EndIf
          ;If RtlCompareMemory_(xLong5, xAppPathsR(4), xAppPathsRL(xLong4)
          
          EndIf
        Next
      xLong5 = xLong5 - *Mem(1) + 2
      ;If xLong5 >= *Mem(0) + xLong1
      ;  Break
      ;  EndIf
      Else
      Break
      EndIf
    Else
    Break
    EndIf
  ForEver

CallFunctionFast(?ReturnPos, RetPos)
;RetPos
JMP eax



ReturnPos:
MOV eax, [esp + 4]
RET

; mem1, mem2, len(chars!)
CompareMemoryFastWX:
PUSH ebx
MOV ebx, [esp + $C]
MOV edx, [esp + $10]
SHL edx, 1 ;*2
ADD edx, ebx
SUB edx, 2
;SUB eax, 2
;SUB ebx, 2

!l_cmfloop:
MOV eax, [esp + $8]
ADD eax, 2
MOV [esp + $8], eax ;preserve
ADD ebx, 2

MOV word cx, [eax]
MOV word ax, [ebx]
CMP word cx, ax
JNE l_cmfmismatch

CMP ebx, edx
JNE l_cmfloop

MOV eax, 1
POP ebx
RET $C


!l_cmfmismatch:
;MOV eax, [esp + $8] ;restore
;MOV eax, edx
POP ebx
SUB eax, eax
;INC eax
RET $C


FindFastWX:
MOV eax, [esp + $4]
MOV edx, [esp + $8]
CompilerIf #Compiler_Mode = 2
  ; str, len(bytes!), Ascii
  ;MOV ebx, [esp + $C]
  PUSH ebx
  MOV ebx, [esp + $10]
  
  ;SHL edx, 1 ;*2
  ADD edx, eax
  SUB eax, 2
  
  !l_findfastloop:
  ADD eax, 2
  MOV cx, word [eax]
  CMP cx, bx
  JE l_findfastfound
  CMP eax, edx
  JNE l_findfastloop
  !XOR eax, eax
  
  !l_findfastfound:
  POP ebx
  RET $C
CompilerElse
  ;str, len(bytes!)
  MOV eax, [esp + $4]
  MOV edx, [esp + $8]
  ;SHL edx, 1 ;*2
  ADD edx, eax
  SUB eax, 2
  
  !l_findfastloop:
  ADD eax, 2
  MOV cx, word [eax]
  CMP cx, word 60
  JE l_findfastfound
  CMP eax, edx
  JNE l_findfastloop
  !XOR eax, eax
  
  !l_findfastfound:
  RET $8
CompilerEndIf


DataSection
RegRepPathStrs:

  IncludeBinary "reg2exe_replaces.bin"
  EndDataSection
;CompilerEndIf
















MakeExA:
;*ptrString, NumChars
MOV eax, [esp + $4]
MOV ecx, eax
MOV edx, [esp + $8]
ADD edx, eax
PUSH ebx
;JMP l_copyloopax
SUB eax, 2
DEC ecx

!l_copyloopa:
ADD eax, 2
INC ecx
;!l_copyloopax:
MOV bl, byte [eax]
MOV byte [ecx], bl
CMP ecx, edx
JNE l_copyloopa

POP ebx
RET $8

MakeExW:
;*ptrString, NumChars
MOV edx, [esp + $4]
MOV eax, [esp + $8]
MOV ecx, eax
SHL eax, 1
ADD eax, edx
ADD ecx, edx
;eax = w, ecx = a
PUSH ebx
;JMP l_copyloopwx
ADD eax, 2
INC ecx

!l_copyloopw:
SUB eax, 2
DEC ecx
;!l_copyloopwx:
MOV bl, byte [ecx]
MOV byte [eax], bl
MOV byte [eax + 1], 0
CMP ecx, edx
JNE l_copyloopw

POP ebx
RET $8



EndThisMisery:
;ProcedureReturn
;SelfTerminate()


CompilerIf #Compiler_Mode = 2
  EndProcedure
CompilerEndIf






Procedure RegDeleteValuesEx(OpenKey.l)
  ;Define.l xLong1
  Define.l xLong2
  Define.l xLong3
  ;Define.s xChar1
  Define *MemTmp
  Define.l Size

  RegDeleteValue_(OpenKey, 0)
  If RegQueryInfoKey_(OpenKey, 0, 0, 0, 0, 0, 0, 0, @Size, 0, 0, 0) = 0
    Size + 1
    CompilerIf #More
      *MemTmp = MemCheck(1, #LMEM_FIXED, Size * 2, "TempCleanKey")
      CompilerElse
      *MemTmp = AllocateMemory(Size * 2)
      CompilerEndIf
    If *MemTmp
      Repeat
        xLong2 = Size
        If IsUnicode
          xLong3 = RegEnumValueW(OpenKey, 0, *MemTmp, @xLong2, 0, 0, 0, 0)
          Else
          xLong3 = RegEnumValueA(OpenKey, 0, *MemTmp, @xLong2, 0, 0, 0, 0)
          MakeW(*MemTmp, xLong2)
          EndIf
        xLong2 + 1
        Select xLong3
          Case 0, 259
            RegDeleteValue(OpenKey, *MemTmp, xLong2)
            If xLong3 = 259: Break: EndIf
          Default
            Break
          EndSelect
        ForEver
      CompilerIf #More
        MemCheck(0, 0, *MemTmp, "")
        CompilerElse
        FreeMemory(*MemTmp)
        CompilerEndIf
      EndIf
    EndIf
  RegDeleteValue_(OpenKey, 0)
  EndProcedure


Procedure.l RegDeleteKeysRecursive(StartKey.l, *SubKey, LenSubkey.l, NoDeleteMain.l)
  Define.l xLong1
  Define.l xLong2
  Define.l xLong3
  Define.l xLong4
  Define.l nCount
  Define *MemTmp
  Define *MemTmp2
  Define.l Size
  Define.l SizeNew
  ;Define.s xChar1




  If LenSubkey
    xLong1 = RegOpenKeyEx(StartKey, *SubKey, LenSubkey)
    If IsUnicode = 0: MakeW(*SubKey, LenSubkey): EndIf
    If xLong1

;Debug "c. " + PeekS(*SubKey, -1, #PB_Unicode)
      ;If RegQueryInfoKey_(xLong1, 0, 0, 0, @nCount, @Size, 0, 0, 0, 0, 0, 0) = 0
      If RegQueryInfoKey_(xLong1, 0, 0, 0, 0, @Size, 0, 0, 0, 0, 0, 0) = 0
        Size + 1
        CompilerIf #More
          *MemTmp = MemCheck(1, #LMEM_FIXED, Size * 2, "TempEraserEnum")
          CompilerElse
          *MemTmp = AllocateMemory(Size * 2)
          CompilerEndIf
        If *MemTmp


          ;LenSubkey * 2
          
          Repeat
            xLong2 = Size
            If IsUnicode
              xLong3 = RegEnumKeyExW(xLong1, nCount, *MemTmp, @xLong2, 0, 0, 0, @xFileTime)
              ;xLong2 * 2
              Else
              xLong3 = RegEnumKeyExA(xLong1, nCount, *MemTmp, @xLong2, 0, 0, 0, @xFileTime)
;              Debug "AA: " + PeekS(*MemTmp) + " (" + Str(xLong2) + ")"
              CompilerIf #More = 2
                Debug "CheckEnum"
                MemCheck(2, *MemTmp, *MemTmp + xLong2 * 2 - 1, "")
;Debug "Ansi: " + PeekS(*MemTmp)
                CompilerEndIf
              MakeW(*MemTmp, xLong2)
;Debug "Wide:" + PeekS(*MemTmp, -1, #PB_Unicode)
              EndIf
            ;If xLong2 > Size: Break: EndIf
;Debug "Size:" + Str(Size)
;Debug PeekS(*MemTmp, -1, #PB_Unicode)

            ;xLong2 + 1
            Select xLong3
              Case 0 ;, 259
;nCount + 1
;break
                ;If SubKey
                  ;xChar1 = SubKey + "\" + xChar1
                ;SizeNew = LenSubKey + 1 + xLong2 + 1
                SizeNew = (LenSubKey + xLong2 + 1)
                CompilerIf #More
                  *MemTmp2 = MemCheck(1, #LMEM_FIXED, (SizeNew + 1) * 2, "TempEraserSub")
;                  Debug "CheckRSize"
                  MemCheck(2, *MemTmp2, *MemTmp2 + (SizeNew + 1) * 2 - 1, "")
                  Debug "CheckRSize"
                  CompilerElse
                  *MemTmp2 = AllocateMemory((SizeNew + 1) * 2)
                  CompilerEndIf
                If *MemTmp2
                  CompilerIf #More = 2
                    Debug "Check1"
                    MemCheck(2, *MemTmp2, *MemTmp2 + LenSubkey * 2 - 1, "")
                    MemCheck(2, *SubKey, *SubKey + LenSubkey * 2 - 1, "")
                    CompilerEndIf
                  RtlMoveMemory_(*MemTmp2, *SubKey, LenSubkey * 2)
                  xLong4 = *MemTmp2 + LenSubkey * 2
                  CompilerIf #More = 2
                    Debug "Check2"
                    MemCheck(2, *MemTmp2, xLong4, "")
                    MemCheck(2, *MemTmp2, xLong4 + 1, "")
                    CompilerEndIf
                  PokeW(xLong4, $5C) ; \, 0
                  xLong4 = xLong4 + 2
                  CompilerIf #More = 2
                    Debug "Check3"
                    MemCheck(2, *MemTmp2, xLong4 + xLong2 * 2 - 1, "")
                    MemCheck(2, *MemTmp, *MemTmp + xLong2 * 2 - 1, "")
                    CompilerEndIf
                  RtlMoveMemory_(xLong4, *MemTmp, xLong2 * 2)
                  PokeW(xLong4 + xLong2 * 2, 0)
                  CompilerIf #More = 2
                    
                    Debug PeekS(*MemTmp, -1 ,#PB_Unicode) + " -> " + PeekS(*MemTmp2, -1 ,#PB_Unicode)
                    Debug "Check4"
                    MemCheck(2, *MemTmp2, *MemTmp2 + SizeNew * 2 + 1, "")
                    CompilerEndIf
                  If RegDeleteKeysRecursive(StartKey, *MemTmp2, SizeNew, 0)
                    nCount + 1
                    EndIf
                  CompilerIf #More
                    MemCheck(0, 0, *MemTmp2, "")
                    CompilerElse
                    FreeMemory(*MemTmp2)
                    CompilerEndIf
                  ;If xLong3 = 259: Break: EndIf
                  Else
                  Break
                  EndIf
                ;  EndIf
                ;CompilerIf #Compiler_DebugMe = 1
                ;  WriteStringX("  SubKey: " + xChar1)
                ;  CompilerEndIf
                ;RegDeleteKeysRecursive(StartKey, xChar1, 0)
              Default
                Break
              EndSelect
            ForEver
;Debug "a11"
          CompilerIf #More
            MemCheck(0, 0, *MemTmp, "")
            CompilerElse
            FreeMemory(*MemTmp)
            CompilerEndIf
          EndIf
        EndIf
;Debug "a12"
      If NoDeleteMain
;Debug "NoDelete!"
;        ProcedureReturn xLong1 ; Key
        Else
        RegCloseKey_(xLong1) ;Key)
;        Debug "  DeleteKey: " + PeekS(*SubKey, -1, #PB_Unicode)
        If IsUnicode
          xLong1 = RegDeleteKeyW(StartKey, *SubKey)
          Else
          MakeA(*SubKey, lenSubkey)
          xLong1 = RegDeleteKeyA(StartKey, *SubKey)
;          Debug "  " + Str(xLong1)
          MakeW(*SubKey, lenSubkey)
          ;ProcedureReturn xLong1
          EndIf
        EndIf
      ElseIf NoDeleteMain = 0
      xLong1 = 1
      EndIf
    ElseIf NoDeleteMain = 0
    xLong1 = 1
    EndIf
  ProcedureReturn xLong1
  EndProcedure

CompilerIf #Compiler_DebugMe = 1
  Procedure WriteStringX(xChar1.s)
    ;WriteStringN(#DebugFileID, xChar1)
    OutputDebugString_(xChar1)
    Debug(xChar1)
    EndProcedure
  CompilerEndIf

Procedure GetXPAccess()
;  '"SE_TAKE_OWNERSHIP_NAME"
  CompilerIf #Compiler_DebugMe = 1
    ;WriteStringX("Aquirering Privileges")
    CompilerEndIf


  Define.l xLong1
  Define.l xLong2
  Define.OSVERSIONINFO xType1
  Define.TOKEN_PRIVILEGES xType2
  Define.TOKEN_PRIVILEGES xType3
  
  xType1\dwOSVersionInfoSize = SizeOf(xType1)
  If GetVersionEx_(xType1)
    CompilerIf #Compiler_DebugMe = 1
      ;WriteStringX("  GetVersionEx ok, PlattformId = " + Trim(Str(xType1\dwPlatformId)))
      CompilerEndIf
    If xType1\dwPlatformId = 2
      IsUnicode = 1
      CompilerIf #Compiler_DebugMe = 1
        ;WriteStringX("  OpenToken")
        CompilerEndIf
      If OpenProcessToken_(GetCurrentProcess_(), 40, @xLong2)
        xLong1 = LookupPrivilegeValue_(#Null, @"SeTakeOwnershipPrivilege", xType2\Privileges[0]\Luid)
        xType2\PrivilegeCount = 1
        xType2\Privileges[0]\Attributes = 2
        CompilerIf #Compiler_DebugMe = 1
          Define.l xLong999
          xLong999.l = AdjustTokenPrivileges_(xLong2, 0, xType2, SizeOf(xType3), xType3, xLong1)
          If xLong999 = 0
            ;WriteStringX("  ok")
            Else
            ;WriteStringX("  failed (" + Trim(Str(xLong999)) + ")")
            EndIf
          CompilerElse
          AdjustTokenPrivileges_(xLong2, 0, xType2, SizeOf(xType3), xType3, xLong1)
          CompilerEndIf
        EndIf
      EndIf
    EndIf
  EndProcedure

CompilerIf #Compiler_Mode = 2
;  Procedure WaitOnProgram(ProgramID.l)
;;    ;MessageRequester("Waiting for:", Hex(ProgramID))
;    If ProgramID
;;      ProgramID = OpenProcess_(2035711, #False, ProgramID)
;      Sleep(1000)
;      While (WaitForSingleObject_(ProgramID, 256) = 258)
;        Sleep(200)
;        Wend
;      CloseHandle_(ProgramID)
;      EndIf
;    EndProcedure

  Procedure DeleteFileX(xLen.l)
    Define.l xBool1
    Define.s xChar1
    Define.WIN32_Find_Data xType1
    Define.s DefDirA
    Define.s FilenameA

    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("Deletefile? " + PeekS(*Mem(1), -1, #PB_Unicode))
;Debug Len(PeekS(*Mem(1), -1, #PB_Unicode))
;Debug xLenPt
;Debug Hex(PeekL(*Mem(1) + xLen * 2 - 8))
;Debug Hex(PeekL(*Mem(1) + xLen * 2 - 4))
      CompilerEndIf

    If xLen > 4
      If PeekL(*Mem(1) + xLen * 2 - 8) = $006C002E And PeekL(*Mem(1) + xLen * 2 - 4) = $006B006E
        CompilerIf #Compiler_DebugMe = 1
          WriteStringX("  Ok, lnk")
          CompilerEndIf
        xBool1 = 1
        Goto OkToDelete
        Else
        If xLen > xAppPathsLen(0)
          If PeekW(*Mem(1) + xAppPathsLen(0) * 2) = $5C
            If CallFunctionFast(?CompareMemoryFastWX, *Mem(1), xAppPaths(0), xAppPathsLen(0))
              CompilerIf #Compiler_DebugMe = 1
                WriteStringX("  Ok, AppDir")
                CompilerEndIf
              xBool1 = 1
              EndIf
            EndIf
          EndIf
        If Not xBool1
          If xLen > xAppPathsLen(3)
            If PeekW(*Mem(1) + xAppPathsLen(3) * 2) = $5C
              ;If CompareMemory(*Mem(1), xAppPaths(3), xAppPathsLen(3) * 2)
              If CallFunctionFast(?CompareMemoryFastWX, *Mem(1), xAppPaths(3), xAppPathsLen(3))
                CompilerIf #Compiler_DebugMe = 1
                  WriteStringX("  Ok, TempDir")
                  CompilerEndIf
                xBool1 = 1
                EndIf
              EndIf
            EndIf
          EndIf
;        xBool1 = 0
        If Not xBool1
          #xMsg = "Do you want to permit deletion of this file:" + Chr(13)
          #xMsgLen = 45
          #xMsgLenW = #xMsgLen * 2
          CompilerIf #More
            xLong1 = MemCheck(1, #LMEM_FIXED, $304, "DelFileConfirm")
            CompilerElse
            xLong1 = AllocateMemory($304)
            CompilerEndIf
          If xLong1
            PokeS(xLong1, #xMsg, #xMsgLen, #PB_Unicode)
            RtlMoveMemory_(xLong1 + #xMsgLenW, *Mem(1), xLen * 2)
            PokeB(xLong1 + #xMsgLenW + xLen * 2, 0)
            If MessageBoxW(0, xLong1, 0, #MB_YESNO | #MB_ICONWARNING) = #IDYES
              xBool1 = 1
              CompilerIf #Compiler_DebugMe = 1
                WriteStringX("  Ok, Granted by user")
                CompilerEndIf
              EndIf
            CompilerIf #More
              MemCheck(0, 0, xLong1, "")
              CompilerElse
              FreeMemory(xLong1)
              CompilerEndIf
            EndIf
          EndIf
  
        If xBool1
OkToDelete:
CompilerIf 0
        If FindString(Filename, "?", 1) + FindString(Filename, "*", 1) ;Or 1
          xChar1 = InstrRev(Filename)
          If Not (Right(xChar1, 1) = "\" Or xChar1 = "")
            xChar1 + "\"
            EndIf
          ;Filename = MidX(Filename, Len(xChar1) + 2)
          xType1\dwFileAttributes = $3F
          xBool1 = FindFirstFile_(Filename, @xType1)
          If Not xBool1 = #INVALID_HANDLE_VALUE
            Repeat
               ;DeleteDirectory(xChar1, Filename, #PB_FileSystem_Force)
              Filename = PeekS(@xType1\cFileName)
              If Not (Left(FileName, 1) = "."  Or xType1\dwFileAttributes & 24)
                DeleteFile_(xChar1 + FileName)
                EndIf
              Until FindNextFile_(xBool1, @xType1) = 0
            FindClose_(xBool1)
            EndIf
          Else
          DeleteFile(Filename)
          EndIf
CompilerEndIf
          If IsUnicode
            CompilerIf #Compiler_DebugMe = 1
              WriteStringX("  RealDelNow: " + PeekS(*Mem(1), xLen, #PB_Unicode))
              CompilerEndIf
            DeleteFileW(*Mem(1))
            Else
            xChar1 = PeekS(*Mem(1), xLen, #PB_Unicode)
            CompilerIf #Compiler_DebugMe = 1
              WriteStringX("  RealDelNow: " + xChar1)
              CompilerEndIf
            DeleteFileA(@xChar1)
            EndIf
          EndIf
        EndIf
      EndIf
;    Debug "DoneDel"
    EndProcedure

  Procedure.s MidX(BaseString.s, Position.l)
    Define.l xLong1

    xLong1.l = Len(BaseString)
    If Position < xLong1
      BaseString = Mid(BaseString, Position, xLong1 - Position + 1)
      EndIf
    ProcedureReturn BaseString
    EndProcedure

  Procedure RunProgramX(RMode.l, xLen)

    If xLen > 3
      If PeekW(*Mem(1)) = 34 
        xLong1 = *Mem(1) + 2
        xLen * 2
        Repeat
          xLong2 = CallFunctionFast(?FindFastWX, xLong1 + 2, xLen, $5C) ;$7C)
          If xLong2
            xLen - (xLong2 - xLong1 + 2)
            xLong1 = xLong2
            Else
            Break
            EndIf
          ForEver
        If xLong1 > *Mem(1)
          xLong2 = (xLong1 - *Mem(1)) - 2
          CompilerIf #More
            xLong1 = MemCheck(1, #LMEM_FIXED, $304, "DelFileConfirm")
            CompilerElse
            xLong1 = AllocateMemory($304)
            CompilerEndIf
          If xLong1
            RtlMoveMemory_(xLong1, *Mem(1) + 2, xLong2)
            PokeB(xLong1 + xLong2 * 2, 0)

;Debug "RunProg"
;Debug PeekS(*Mem(1), -1, #PB_Unicode)
;Debug PeekS(xLong1, -1, #PB_Unicode)


            Define.STARTUPINFO xType1 
            Define.PROCESS_INFORMATION xType2
            With xType1
              \cb = 68
              \lpTitle = *Mem(1)
              ;If RMode = 2 Or RMode = 3
              \dwFlags = ((RMode & 4) >> 2) ; -> 0/1
                ;\wShowWindow = RMode 0
              EndWith
    
    
    ;Debug "try"
            If IsUnicode
              xLong2 = CreateProcessW(0, *Mem(1), 0, 0, 1, 0, 0, xLong1, @xType1, @xType2)
              Else
              Define.s xChar1 = PeekS(*Mem(1), -1, #PB_Unicode)
              Define.s xChar2 = PeekS(xLong1, -1, #PB_Unicode)
    ;Debug xChar1
    ;Debug xChar2
              xType1\lpTitle = @xChar1
              xLong2 = CreateProcessA(0, @xChar1, 0, 0, 1, 0, 0, @xChar2, @xType1, @xType2)
              EndIf
            
            If xLong2
;Debug "  0 - " + Str(RMode)
;Debug "  1 - " + Str((RMode & 4) >> 2)
;Debug "  2 - " + Str(RMode & 1)
              ;;;;; xType2.hProcess
              If (RMode & 1)
;                WaitOnProgram(xType2\hProcess)
;Debug "  3"
                Sleep(800)
                While (WaitForSingleObject_(xType2\hProcess, 25) = 258)
                  Sleep(75)
                  Wend
                Else
                CloseHandle_(xType2\hProcess)
                EndIf
              CloseHandle_(xType2\hThread)
              EndIf


            CompilerIf #More
              MemCheck(0, 0, xLong1, "")
              CompilerElse
              FreeMemory(xLong1)
              CompilerEndIf

;CallFunctionFast(?FindFastWX, *Mem(1), xLen * 2, 1) ;$7C)      
            EndIf
          EndIf
        EndIf
      EndIf
CompilerIf 0

    Define.l xLong1
    Define.s xChar1
    Define.s xChar2

    Filename = MidX(Filename, 2)
    xLong1 = FindString(Filename, ",", 1)
    xChar1 = Left(Filename, xLong1 - 1)
    Filename = MidX(Filename, xLong1 + 1)
    xChar2 = InstrRev(xChar1)
    
    RunProgram(xChar1, Filename, xChar2, RMode)
CompilerEndIf
    EndProcedure
  CompilerEndIf

Procedure.l DoEventsEx_IsTickCountElapsed(FirstTickCountValue.l, TimeIntervalMs.l)
  Static xLong1.l
  
  xLong1 = (GetTickCount_() & 1073741823)
  If xLong1 < FirstTickCountValue
    If (xLong1 + 1073741824 > FirstTickCountValue + TimeIntervalMs)
      ProcedureReturn 1
      EndIf
    Else
    If (xLong1 > FirstTickCountValue + TimeIntervalMs)
      ProcedureReturn 1
      EndIf
    EndIf
  EndProcedure

  Procedure Sleep(IntervalMS.l)
    ;Static xLong1.l
  
    ;xLong1 = CreateWaitableTimer_(0, -1, 0)
    ;While MsgWaitForMultipleObjects_(1, @xLong1, 0, IntervalMS, 255) = 0
    While MsgWaitForMultipleObjects_(0, 0, 0, IntervalMS, 255) = 0
      WindowEvent()
      Wend
    WindowEvent()
    ;CloseHandle_(xLong1)
    EndProcedure

Procedure.s LoadResStringA(ResID.l) ;, CanBeMultiLine.l)
    Define.l xLong1
    Define.s xChar1

    xChar1 = Space(32766)
    xLong1 = LoadString_(hInstance, ResID, @xChar1, 32766)
    If xLong1
      xChar1 = Left(xChar1, xLong1)
      ;If CanBeMultiLine
      ;  xChar1 = ReplaceString(xChar1, "|", Chr(13), 2)
      ;  EndIf
      ;MessageRequester(Str(ResID), xChar1)
      ProcedureReturn xChar1
      EndIf
  ;MessageRequester(Str(ResID), xChar1)
  EndProcedure

Procedure.l CreateInstance() ;(ResID.l)
  Define.l xLong1
  Define.l xLong2

  If OpenWindow(0, 0, 0, 264, 40, "SelfReg", #PB_Window_WindowCentered | #PB_Window_ScreenCentered)
    xLong1 = WindowID(0)
    If xLong1
      hInstance = GetWindowLong_(xLong1, #GWL_HINSTANCE)
      If hInstance
        SetWindowTitle(0, LoadResStringA(100))
        ;If CreateGadgetList(xLong1)
          xLong2 = LoadImage_(hInstance, "#1", 1, 32, 32, 32768)
          If xLong2
            SetClassLong_(xLong1, #GCL_HICON, xLong2)
            DestroyIcon_(xLong2)
            EndIf
        ;  EndIf
        EndIf
      EndIf
    EndIf
  IsInterface = 1
  EndProcedure

Procedure CheckProgress(Progress.f)
  Static xLong1.l
  ;Static xLong2.l
  
CompilerIf #Compiler_Mode = 2
  If Progress = -2 Or Progress = -3
CompilerElse
  If Progress = -2
CompilerEndIf
    If IsInterface
      FreeGadget(1)
      ResizeGadget(0, 40, 4, 164, 32)
      CompilerIf #Compiler_Mode = 2
        If Progress = -3
          SetGadgetText(0, LoadResStringA(104))
          Else
          SetGadgetText(0, LoadResStringA(103))
          EndIf
        CompilerElse
        SetGadgetText(0, LoadResStringA(102))
        CompilerEndIf
      Else
      CreateInstance() ;(102)
      CompilerIf #Compiler_Mode = 2
        If Progress = -3
          TextGadget(0, 4, 4, 164, 32, LoadResStringA(104))
          Else
          TextGadget(0, 4, 4, 164, 32, LoadResStringA(103))
          EndIf
        CompilerElse
        TextGadget(0, 4, 4, 256, 16, LoadResStringA(102))
        CompilerEndIf
      EndIf
    CompilerIf #Compiler_Mode = 2
      ButtonGadget(1, 170, 11, 90, 25, LoadResStringA(109), #PB_Button_Default)
      CompilerElse
      ButtonGadget(1, 170, 11, 90, 25, LoadResStringA(103), #PB_Button_Default)
      CompilerEndIf
    Repeat
      If WaitWindowEvent() = #PB_Event_Gadget And EventGadget() = 1
        Select EventType()
          ;Case 0
          ;  Debug "Yes!!"
          Case #PB_EventType_LeftClick
            Break
          Case #PB_EventType_RightClick
            Break
          Case #PB_EventType_LeftDoubleClick
            Break
          Case #PB_EventType_RightDoubleClick
            Break
          EndSelect
        EndIf
      ForEver
    ElseIf Progress = -1 
    xLong1 = GetTickCount_() & 1073741823
    ElseIf IsInterface = 0
CompilerIf #Compiler_Mode = 2
CompilerElse
    If DoEventsEx_IsTickCountElapsed(xLong1, 1000) And Progress < 0.25
CompilerEndIf
      CreateInstance() ;(101)
      TextGadget(0, 4, 4, 256, 16, LoadResStringA(101))
      ProgressBarGadget(1, 4, 20, 256, 16, 0, 1024)
      SetGadgetState(1, Progress * 1024)
      Sleep(200)
      xLong1 = GetTickCount_() & 1073741823
CompilerIf #Compiler_Mode = 2
CompilerElse
      EndIf
CompilerEndIf
    ElseIf DoEventsEx_IsTickCountElapsed(xLong1, 200)
    SetGadgetState(1, Progress * 1024)
    Sleep(200)
    xLong1 = GetTickCount_() & 1073741823
    EndIf
  EndProcedure

Procedure.l AllocAndRead(ReadAsW.l, Size.l, MemID.l)
  Define.l Result = 1
  Define.l xLong1
  ;Global Dim xMemSize (1)

  If ReadAsW = 1
    Define.l NoConv = 1
    Define.l Multi = 4
    ElseIf ReadAsW
    Multi = 2
    ;Debug "Unicode!"
    ReadAsW = 2
    Else
    Multi = 2
    ;Debug "Ansi"
    ReadAsW = 1
    EndIf

  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("AAR0")
    CompilerEndIf

  ;Debug "CanFree(" + Str(MemID) + "): " + Str(*Mem(MemID))
  CompilerIf #More
CompilerIf #Compiler_DebugMe = 1
  WriteStringX("AAR_F0x")
  CompilerEndIf
    If *Mem(MemID): MemCheck(0, 0, *Mem(MemID), ""): EndIf
CompilerIf #Compiler_DebugMe = 1
  WriteStringX("AAR_F1x: " + Str((Size + 2) * ReadAsW * Multi))
  CompilerEndIf
    *Mem(MemID) = MemCheck(1, #LMEM_FIXED, (Size + 2) * ReadAsW * Multi, "ReAlloc")
    CompilerElse

CompilerIf #Compiler_DebugMe = 1
  WriteStringX("AAR_F0")
  CompilerEndIf

    If *Mem(MemID): FreeMemory(*Mem(MemID)): EndIf

CompilerIf #Compiler_DebugMe = 1
  WriteStringX("AAR_F1")
  CompilerEndIf

    *Mem(MemID) = AllocateMemory((Size + 2) * ReadAsW * Multi)
    CompilerEndIf

  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("AAR1")
    CompilerEndIf

  
  If *Mem(MemID)  
    If ReadFile_(FileAccessID, *Mem(MemID), Size * ReadAsW, @xLong1, 0)
      If xLong1 = Size * ReadAsW
        Result = 0
        LocAPI + Size * ReadAsW
        If ReadAsW = 1 And NoConv = 0
          CallFunctionFast(?MakeExW, *Mem(MemID), Size)
          EndIf
        ;Debug "  " + PeekS(*Mem(MemID), -1, #PB_Unicode)
        ;Debug "NewPos: " + Hex(LocAPI)
        EndIf
      EndIf
    If Result
      CompilerIf #More
        MemCheck(0, 0, *Mem(MemID), "")
        CompilerElse
        FreeMemory(*Mem(MemID))
        CompilerEndIf
      *Mem(MemID) = 0
      EndIf
    EndIf
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("AAR9")
    CompilerEndIf

  ;Debug "SeekTo: " + Hex(LocAPI) + "(Due Size: " + Str(Size) + ")"
  ProcedureReturn Result
  EndProcedure

Procedure MakeA(*ptrString, NumChars)
  PokeS(*ptrString, PeekS(*ptrString, -1, #PB_Unicode))
  EndProcedure

Procedure MakeW(*ptrString, NumChars)
  PokeS(*ptrString, PeekS(*ptrString), -1, #PB_Unicode)
  EndProcedure

Procedure.l RegCreateKeyEx(HKey.l, SubKey.l, LenSubKey.l)
  Define.l Result
  Define.l xLong1

  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("RegCreateKeyEx: " + PeekS(SubKey, -1, #PB_Unicode))
    CompilerEndIf

  If IsUnicode
    If RegCreateKeyExW(HKey, SubKey, 0, 0, 0, 983103, 0, @Result, @xLong1): Result = 0: EndIf
    Else
    MakeA(SubKey, LenSubKey)
    If RegCreateKeyExA(HKey, SubKey, 0, 0, 0, 983103, 0, @Result, @xLong1): Result = 0: EndIf
    EndIf
  ProcedureReturn Result
  EndProcedure
  
Procedure.l RegOpenKeyEx(HKey.l, SubKey.l, LenSubKey.l)
  Define.l Result
  ;Define.l xLong1

  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("RegOpenKeyEx: " + PeekS(SubKey, -1, #PB_Unicode))
    CompilerEndIf

  If IsUnicode
    If RegOpenKeyExW(HKey, SubKey, 0, 983103, @Result): Result = 0: EndIf
    Else
    MakeA(SubKey, LenSubKey)
    If RegOpenKeyExA(HKey, SubKey, 0, 983103, @Result): Result = 0: EndIf
    EndIf
  ProcedureReturn Result
  EndProcedure

Procedure RegDeleteValue(HSKey.l, Name.l, LenName.l)
  If IsUnicode
    RegDeleteValueW(HSKey, Name)
    Else
    MakeA(Name, LenName)
    RegDeleteValueA(HSKey, Name)
    EndIf
  
  EndProcedure

Procedure.l ReadFileFailsLong(*Buffer, Bytes.l)
  Define.l Result = 1
  Define.l xLong1

  PokeL(*Buffer, 0)
  If ReadFile_(FileAccessID, *Buffer, Bytes, @xLong1, 0)
    If xLong1 = Bytes
      Result = 0
      LocAPI + Bytes
      EndIf
    EndIf
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("ReadLongPost: " + Hex(LocAPI) + ", " + Hex(PeekL(*Buffer)))
    CompilerEndIf
  ProcedureReturn Result
  EndProcedure

Procedure.l FileSeekFails(NewPos.l)
  Define.l Result

  If SetFilePointer_(FileAccessID, NewPos, 0, #FILE_BEGIN) = -1
    Result = 1
    Else
    LocAPI = NewPos
    EndIf
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("SeekTo: " + Hex(LocAPI))
    CompilerEndIf
  ProcedureReturn Result
  EndProcedure


CompilerIf #Compiler_Mode = 2
  #SelfDllKillMode = 2

  
  CompilerIf #SelfDllKillMode = 1
    ProcedureDLL.l PatchMem(*Mem)
      Define.l xLong1
      Define.MEMORY_BASIC_INFORMATION xType1
    
      If VirtualQuery_(hMem, @xType1, 28)
        VirtualProtect_(xType1\BaseAddress, xType1\RegionSize, $20, @xType1)
        EndIf
      EndProcedure
    CompilerEndIf
  
  Procedure.l SelfTerminate()

  ;MessageRequester("Loaded!", "33")
;  Uninstall()


  Define.l hKernel = GetModuleHandle_("kernel32.dll")
  Define.l hExitProcess = GetProcAddress_(hKernel, "ExitProcess")
  Define.l hUnloadDLL = GetProcAddress_(hKernel, "FreeLibrary")
  Define.l hDelFileAPI
  Define.l hRemoveDAPI
  Define.l xLong1
  CompilerIf #SelfDllKillMode = 1
    CompilerElse
    Define.l xLong2
    CompilerEndIf
  
  CompilerIf #SelfDllKillMode = 1
    MOV eax, esp
    ADD eax, #StackThis
    AND eax, $fffffffc
    MOV xLong1, eax
    
    PatchMem(xLong1)
    CompilerElse
    xLong1 = VirtualAlloc_(0, #StackNeed, $1000, $4)
If xLong1
    CompilerEndIf

;  Debug hExitProcess
;  Debug hModule
;  Debug hUnloadDLL
;  Debug xLong1
;  Debug hDelFileAPI

  RtlMoveMemory_(xLong1, ?ASMTerminate, #StackTerm)

  If IsUnicode
    GetModuleFileNameW(hModule, xLong1 + #StackTermFind, $101)
    hDelFileAPI = GetProcAddress_(hKernel, "DeleteFileW")
    hRemoveDAPI = GetProcAddress_(hKernel, "RemoveDirectoryW")
    RtlMoveMemory_(xLong1 + #StackTerm, ?FindFastWT, #StackFind)
    Else
    GetModuleFileNameA(hModule, xLong1 + #StackTermFind, $101)
    hDelFileAPI = GetProcAddress_(hKernel, "DeleteFileA")
    hRemoveDAPI = GetProcAddress_(hKernel, "RemoveDirectoryA")
    RtlMoveMemory_(xLong1 + #StackTerm, ?FindFastAT, #StackFind)
    EndIf

;  MessageRequester("1", PeekS(xLong1))
;  ProcedureReturn

  
;  RtlMoveMemory_(xLong1 - $100, ?ASMTerminate, $92)
    
;    CallFunctionFast(?ASMTerminate, hUnloadDLL, hModule, hDelFileAPI, , hExitProcess)
  CompilerIf #SelfDllKillMode = 1
    CompilerElse
If VirtualProtect_(xLong1, #StackNeed, $40, @xLong2)
    CompilerEndIf
  CallFunctionFast(xLong1, hUnloadDLL, hModule, hDelFileAPI, xLong1 + #StackTermFind, hRemoveDAPI, xLong1 + #StackTerm, hExitProcess)
  
  
  CompilerIf #SelfDllKillMode = 1
    CompilerElse
EndIf
EndIf
ExitProcess_(0)
    CompilerEndIf  
;  MessageRequester("NoFurther!", "xx")
  
    ; hUnloadDLL, hModule, hDelFileAPI, hFileNameAW, hExitProcess
ASMTerminate:
NOP
NOP
NOP
NOP
    POP eax  ; RetPtr
    POP eax  ; UnloadDLL
    CALL eax ; UnloadDLL with hModule
    POP eax  ; DelFile
MOV ecx, [esp]
PUSH ecx
    CALL eax ; DelFile with Filename
; filenameptr, removeapi, finderapi
;MOV [esp+$20], ebx
!rmdirrepeat:
MOV eax, [esp]
MOV edx, [esp + 8]
PUSH eax
!XOR ebx, ebx
CALL edx
CMP edx, 2
!JB dirnofurther
;MOV eax, [esp]
MOV [ebx], word 0
;MOV eax, [esp + 8]
;CALL eax
CALL dword [esp + 8]
!OR eax, eax
!JNZ rmdirrepeat


!dirnofurther:
;MOV ebx, [esp+$24]

ADD esp, $C ;10

    MOV eax, [esp] ;hExitProcess
    MOV [esp], dword 0   ;0 on stack
    CALL eax


;StackSub:
;    MOV eax, esp
;    SUB eax, $400
;    RET
AsmTerminateEnd:



  FindFastWT:
NOP
NOP
NOP
NOP
  !XOR edx, edx
!ffwloop:
  MOV cx, word [eax]
  OR cx, cx
  !JZ ffwnomore
  SUB cx, $5C
  !JNZ ffwnotfound
  MOV ebx, eax
  INC edx
!ffwnotfound:
  INC eax
  INC eax
  !JMP ffwloop
!ffwnomore:
  RET


  FindFastAT:
NOP
NOP
NOP
NOP
  !XOR edx, edx
!ffaloop:
  MOV cl, byte [eax]
  OR cl, cl
  !JZ ffanomore
  SUB cl, $5C
  !JNZ ffanotfound
  MOV ebx, eax
  INC edx
!ffanotfound:
  INC eax
  !JMP ffaloop
!ffanomore:
  RET



CompilerIf #Compiler_DebugMe = 1
;    End
CompilerEndIf

    EndProcedure

CompilerIf #Compiler_DebugMe = 1
  AttachProcess(GetModuleHandle_(0))
;  MessageRequester("NotDone", "4")
CompilerEndIf
  CompilerEndIf


; IDE Options = PureBasic 4.51 (Windows - x86)
; ExecutableFormat = Shared Dll
; CursorPosition = 2387
; FirstLine = 2367
; Folding = -----
; EnableAsm
; EnableAdmin
; Executable = SelfKill.dll
; DisableDebugger
; VersionField0 = 2.25
; VersionField1 = 2.25
; VersionField2 = ctuser
; VersionField3 = Reg2exe
; VersionField4 = 2.25
; VersionField5 = 2.25
; VersionField6 = Reg2exe 'converter'
; VersionField7 = Reg2exe
; VersionField8 = Reg2exe.exe
; VersionField9 = Copyright 2002-2006 by Jan Vorel; Published under the GNU General Public License
; VersionField18 = Comments
; VersionField21 = Published under the GNU General Public License; homepage: http://www.ctuser.net; Compressed with upx: http://upx.sourceforge.net
; AddResource = D:\DEV\software\Projects\ctInst\UnInst\res_ENU\_Gen.rc