EnableExplicit

#ReplaceData_IgnoreCase = 1

Procedure.s GetDateAsBuild(xParam.l)
  Define.SYSTEMTIME xType1
  If GetSystemTime_(@xType1)
    PrintN("DateOK")
    Select xParam
      Case 0
        ProcedureReturn Str(xType1\wYear) + "." + Right("00" + Str(xType1\wMonth), 2) + "." + Right("00" + Str(xType1\wDay), 2)
      Case 1
        ProcedureReturn Str(xType1\wYear) + "," + Right("00" + Str(xType1\wMonth), 2) + Right("00" + Str(xType1\wDay), 2)
      EndSelect
    Else
    PrintN("DateFail")
    EndIf
  EndProcedure

Procedure.l MaxL(Value1.l, Value2.l)
  If Value1 > Value2
    ProcedureReturn Value1
    Else
    ProcedureReturn Value2
    EndIf
  EndProcedure

; If sucessfull, returns pointer to replaced data; New size is poked to *ptrNewSize
;   the data is followed by a nullchar The returned new size does not include this nullchar.
; If not sucessfull, returns 0 and pokes -1 to *ptrNewSize
; Also returns 0 if nothing has been replaced (pokes Old/New size to *ptrNewSize)
; If len... = -1, *ptr... is a pointer to a null terminated string
; EnlargeBlockSize defines in which blocks the output memory is enlarged, on demand.
;   Relevant If lenToReplace > lenToFind
;   Use a negative value to optimize for a specific amount of replaces:
;     -5 will calculate the EnlargeBlockSize for 5 replacements
;
; When finished using the new data object, 
; flags: #ReplaceData_IgnoreCase

Procedure.l ReplaceData(*ptrMem, lenMem.l, *ptrToFind, lenToFind.l, *ptrToReplace, lenToReplace.l, *ptrNewSize, Flags.l, EnlargeBlockSize.l)
  #EnlargeBlockSize = 4096
  
  If *ptrMem And *ptrToFind And *ptrToReplace
    ;if unicode then...
    If lenMem = -1
      lenMem = lstrlen_(*ptrMem)
      EndIf
    If lenToFind = -1
      lenToFind = lstrlen_(*ptrToFind)
      EndIf
    If lenToReplace = -1
      lenToReplace = lstrlen_(*ptrToReplace)
      EndIf

    If lenMem And lenToFind
      Define.l EnlargePerReplace = lenToReplace - lenToFind
      Define.l xLong5
      If EnlargePerReplace > 0
        If EnlargeBlockSize < 0
          EnlargeBlockSize = (-EnlargeBlockSize) * EnlargePerReplace
          EndIf
        EnlargeBlockSize = MaxL(EnlargeBlockSize, MaxL(#EnlargeBlockSize, EnlargePerReplace))
        xLong5 = lenMem * lenToReplace
        If EnlargeBlockSize > xLong5
          EnlargeBlockSize = xLong5
          EndIf
        Else
        ;EnlargePerReplace = 0
        EnlargeBlockSize = 0
        EndIf
      Define *MemoryCompare
      If (Flags & #ReplaceData_IgnoreCase)
        *MemoryCompare = AllocateMemory(lenMem)
        If *MemoryCompare
          CopyMemory(*ptrMem, *MemoryCompare, lenMem)
          If CharLowerBuff_(*MemoryCompare, lenMem) = lenMem
            xLong5 = AllocateMemory(lenToFind)
            If xLong5
              CopyMemory(*ptrToFind, xLong5, lenToFind)
              *ptrToFind = xLong5
              If CharLowerBuff_(*ptrToFind, lenToFind) = lenToFind
                Else
                Goto lbl_ReplaceData_Abort2
                EndIf
              Else
              Goto lbl_ReplaceData_Abort2
              EndIf
            Else
            Goto lbl_ReplaceData_Abort2
            EndIf
          Else
          Goto lbl_ReplaceData_Abort2
          EndIf
        Else
        *MemoryCompare = *ptrMem
        EndIf
      
      ;Debug *MemoryCompare
      ;Debug *ptrToFind
      
      Define.l OutMemoryAllocated = lenMem + EnlargeBlockSize
      Define *Memory = AllocateMemory(OutMemoryAllocated + 1)
      If *Memory
        Define.l xLong1
        Define.l xLong2 = lenMem - lenToFind + 1
        ;xLong1 = 0
        Define.l xLong3
        Define.l xLong4 = lenToFind - 1
        Define.l OutMemoryCopied ; = 0
        Define.l OutMemoryRequired = lenMem
        Define.l InMemoryCopied
        Define.l *MemoryNew
        ;Debug PeekS(*ptrToFind)
        ;Debug PeekS(*MemoryCompare)
        
        Repeat
          xLong5 = *MemoryCompare + xLong1
          ;Debug xLong4
          For xLong3 = 0 To xLong4
            ;If xLong3 > -1: Debug xLong3:EndIf
            ;Debug "Test: " + Str(xLong5)
            ;Debug Str(PeekB(xLong5 + xLong3)) + " - " + Str(PeekB(*ptrToFind + xLong3))
            ;Debug xLong3
            If Not PeekB(xLong5 + xLong3) = PeekB(*ptrToFind + xLong3)
              xLong1 + 1
              Goto lbl_ReplaceData_NotFound
              EndIf
            ;Debug Str(xLong3)
            Next
          If InMemoryCopied < xLong1
            xLong3 = xLong1 - InMemoryCopied
            CopyMemory(*ptrMem + InMemoryCopied, *Memory + OutMemoryCopied, xLong3)
            ;InMemoryCopied + xLong3
            OutMemoryCopied + xLong3
            EndIf
          OutMemoryRequired + EnlargePerReplace
          If EnlargePerReplace > 0
            ;OutMemoryRequired + EnlargePerReplace
            If OutMemoryRequired > OutMemoryAllocated
              OutMemoryAllocated + EnlargeBlockSize
              *MemoryNew = ReAllocateMemory(*Memory, OutMemoryAllocated + 1)
              If *MemoryNew
                *Memory = *MemoryNew
                Else
                Goto lbl_ReplaceData_Abort
                EndIf
              EndIf
            ;Else
            ;Debug "Less: " + Str(EnlargePerReplace)
            ;OutMemoryRequired - EnlargePerReplace
            EndIf
          If lenToReplace
            CopyMemory(*ptrToReplace, *Memory + OutMemoryCopied, lenToReplace)
            OutMemoryCopied + lenToReplace
            EndIf
          ;InMemoryCopied + lenToFind
          ;InMemoryCopied = xLong1 + lenToFind
          xLong1 + lenToFind
          InMemoryCopied = xLong1
          If xLong1 > xLong2
            Break
            EndIf
lbl_ReplaceData_NotFound:
          ;xLong1 + 1
          ;Debug xLong1
          Until xLong1 = xLong2

        If InMemoryCopied
          ;Debug "1"
          If InMemoryCopied < lenMem
            xLong3 = lenMem - InMemoryCopied
            CopyMemory(*ptrMem + InMemoryCopied, *Memory + OutMemoryCopied, xLong3)
            ;InMemoryCopied + xLong3
            OutMemoryCopied + xLong3
            EndIf
          PokeL(*ptrNewSize, OutMemoryRequired)
          ;Debug InMemoryCopied
          ;Debug xLong2
          ;Debug OutMemoryCopied
          ;Debug OutMemoryRequired
          ProcedureReturn *Memory
          Else
          PokeL(*ptrNewSize, lenMem)
          ProcedureReturn 0
          EndIf
lbl_ReplaceData_Abort:
        FreeMemory(*Memory)
        EndIf
lbl_ReplaceData_Abort2:
      If *MemoryCompare And Not *ptrMem = *MemoryCompare
        FreeMemory(*MemoryCompare)
        EndIf
      EndIf
    EndIf
  PokeL(*ptrNewSize, -1)
  ProcedureReturn 0
  EndProcedure

;Debug GetDateAsBuild(0)
;Debug GetDateAsBuild(1)
;End

OpenConsole()
Define xLong1.l = OpenFile(#PB_Any, ProgramParameter())
If xLong1
  Define xLong2.l = Lof(xLong1)
  If xLong2
    Define *Mem = AllocateMemory(xLong2)
    If *Mem
      If ReadData(xLong1, *Mem, xLong2) = xLong2
        CloseFile(xLong1)
        Define.s xChar1 = GetDateAsBuild(0)
        Define.l xLong3
        Define.l xBool1
        Define *Mem2 = ReplaceData(*Mem, xLong2, @"$builddate0$", -1, @xChar1, -1, @xLong3, 1, 0)
        If *Mem2 And xLong3: xBool1 = 1: *Mem = *Mem2: xLong2 = xLong3: EndIf
        xChar1 = GetDateAsBuild(1)
        *Mem2 = ReplaceData(*Mem, xLong2, @"$builddate1$", -1, @xChar1, -1, @xLong3, 1, 0)
        If *Mem2 And xLong3: xBool1 = 1: *Mem = *Mem2: xLong2 = xLong3: EndIf
        If xBool1 = 1
          xLong1 = CreateFile(#PB_Any, ProgramParameter())
          If xLong1
            WriteData(xLong1, *Mem, xLong2)
            ;FlushFileBuffers(xLong1)
            ;FileSeek(xLong1, 0)
            ;*Mem2 = AllocateMemory(xLong2)
            ;Debug xLong2
            ;If ReadData(xLong1, *Mem2, xLong2) = xLong2
            ;xLong3 = ReadData(xLong1, *Mem2, xLong2)
            ;Debug xLong3
            ;If xLong3 = xLong2
            ;  If CompareMemory(*Mem, *Mem2, xLong2)
            ;    PrintN("Done")
            ;    Else
            ;    PrintN("Writing failed 1")
            ;    Delay(2000)
            ;    EndIf
            ;  Else
            ;  PrintN("Writing failed 2")
            ;  Delay(2000)
            ;  EndIf
            CloseFile(xLong1)
            Else
            PrintN("Cannot create new file")
            EndIf
          Else
          PrintN("Nothing found or replacing failed")
          EndIf
        Else
        PrintN("Cannot read from file")
        CloseFile(xLong1)
        EndIf
      Else
      PrintN("Out of memory")
      CloseFile(xLong1)
      EndIf
    Else
    PrintN("zero size")
    CloseFile(xLong1)
    EndIf
  ;CloseFile(xLong1)
  Else
  PrintN("File not found or access error")
  EndIf
CloseConsole()
; IDE Options = PureBasic v4.00 (Windows - x86)
; ExecutableFormat = Console
; CursorPosition = 15
; Folding = -
; Executable = VerHack.exe
; CommandLine = d:\dev\projects\qplayer\res_enu\_version.rc d:\dev\tools\temp\gaga.tmp
; DisableDebugger