; Copyright (C) 2007 Jan Vorel

; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

; This is a shared modul, class modul, usercontrol or form. It is also
; published under the GNU General Public License.

; If you have any questions, suggestions or bug reports about this product,
; contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
; language or A.P.I. issues

EnableExplicit

Import "Kernel32.lib"
  lstrlenW(ptrString.l)
  EndImport




;#QPClassName = "WinampPluginShowTitleClass"
#QPClassTitle = "Winamp"

Structure PluginInfoType
  Version.l
	Description.l
	Init.l
	Config.l
	Quit.l
	hwndParent.l
	hDllInstance.l
	EndStructure

Global HWndWinamp.l
Global PluginInfo.PluginInfoType
Global xQPClassWindowHWnd.l
;Global CurTitleNowF.l
;Global CurTitleNowFLen.l
;Global CurTitleNowS.l
;Global CurTitleNowSLen.l

Procedure.l SMQueryString(wParam.l, MapFileID.l)
  Define.l hMapFile
  Define.l hMapFileView
  Define.l hMapFileSize
  Define.s xChar1
  Define.MEMORY_BASIC_INFORMATION xType1
  Define.l Result
;  Define.l CurTitleNowX
;  Define.l CurTitleNowXLen



  If SendMessage_(HWndWinamp, #WM_USER, 0, 104) = 1
    Define.l xLong1 = SendMessage_(HWndWinamp, #WM_USER, 0, 3031)
    If xLong1
      Define.l xLong2 = lstrlenW(xLong1) * 2
      If xLong2
        hMapFile = OpenFileMapping_(2, 0, "winampshowtitleplugin_" + Str(MapFileID))
        If hMapFile
          hMapFileView = MapViewOfFile_(hMapFile, $F001F, 0, 0, 0)
          If hMapFileView
            If VirtualQuery_(hMapFileView, @xType1, 28)
              If wParam = 801
                For wParam = xLong1 To xLong1 + xLong2 - 2 Step 2
                  If PeekW(wParam) = 92
                    xLong2 = xLong2 - ((wParam + 2) - xLong1)
                    xLong1 = wParam + 2
                    EndIf
                  Next
                EndIf
              hMapFileSize = xType1\RegionSize
              If (xLong2 + 2) => hMapFileSize
                Result = hMapFileSize / 2 - 1
                Else
                Result = xLong2 / 2
                EndIf
              RtlMoveMemory_(hMapFileView, xLong1, Result * 2)
              PokeW(hMapFileView + Result * 2, 0)
              EndIf
            UnmapViewOfFile_(hMapFileView)
            EndIf
          CloseHandle_(hMapFile)
          EndIf
        EndIf
      EndIf
    EndIf
NoSplit:
  ProcedureReturn Result
  EndProcedure


Procedure.l ProcClassWnd(hWnd.l, message.l, wParam.l, lParam.l)
  Define.l ProcClassWnd
  
  Select message
    Case 2
      ProcClassWnd = 0
    Case $111
      If wParam = 800 Or wParam = 801
        ProcClassWnd = SMQueryString(wParam, lParam)
        EndIf
    Default
      ProcClassWnd = DefWindowProc_(hWnd, message, wParam, lParam)
    EndSelect
  ProcedureReturn ProcClassWnd
  EndProcedure

Procedure.w Init()
  Define.WNDCLASSEX xType1

  With xType1
    \cbsize = SizeOf(xType1)
    \style = $83
    \lpfnWndProc = @ProcClassWnd()
    \cbClsExtra = 0
    \cbWndExtra = 0
    \hInstance = PluginInfo\hDllInstance
    \hIcon = 0
    \hCursor = LoadCursor_(0, $F00)
    \hbrBackground = 6
    \lpszMenuName = #Null ;Chr(0)
    \lpszClassName = ?lbl_ClassName
    \hIconSm = 0
    EndWith
  RegisterClassEx_(xType1)

  HWndWinamp = PluginInfo\hwndparent
  If HWndWinamp
    xQPClassWindowHWnd = CreateWindowEx_($88, ?lbl_ClassName, #QPClassTitle, $8E800000, 0, 0, 400, 35, 0, 0, PluginInfo\hDllInstance, 0)
    EndIf
  EndProcedure

Procedure Config()
  EndProcedure

Procedure Quit()
  If xQPClassWindowHWnd
    DestroyWindow_(xQPClassWindowHWnd)
    UnregisterClass_(?lbl_ClassName, PluginInfo\hDllInstance)
    EndIf
  EndProcedure

ProcedureCDLL.l winampGetGeneralPurposePlugin()
  PluginInfo\Version = $10
  PluginInfo\Description = ?lbl_Description
  PluginInfo\Init = @Init()
  PluginInfo\Config = @Config()
  PluginInfo\Quit = @Quit()
  ProcedureReturn @PluginInfo
  EndProcedure
 
DataSection
  lbl_Description:
  Data.s "GetWinampTitle 1.00.2007.0930"
  lbl_ClassName:
  Data.s "WinampShowTitlePluginClass"
  EndDataSection
; IDE Options = PureBasic v4.02 (Windows - x86)
; ExecutableFormat = Shared Dll
; CursorPosition = 78
; FirstLine = 62
; Folding = --
; Executable = gen_GetTitle.dll
; DisableDebugger
; AddResource = D:\DEV\Software\Libraries\Winamp\Plugins\gen_GetTitle.rc