DECLARE SUB PrintPrg (xChar1 AS STRING, xlong1 AS LONG, xlong2 AS LONG)
DECLARE FUNCTION CharSwapDWord$ (xChar1 AS STRING)
DECLARE FUNCTION LenCharToLong& (xChar1 AS STRING)


' ParsecEx, Copyright (C) 2003,2004 by Jan Vorel

' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues


DIM xchara1(99) AS STRING  'InfosForExtractingEachMP3
DIM xlong1 AS LONG 'CurDATfile
DIM xlong2 AS LONG 'NumMP3s
DIM xlong3 AS LONG 'NumMP3sToSwapToSecondDAT
DIM xlong4 AS LONG 'TotalBytesToProcess
DIM xlong5 AS LONG 'CurMP3
DIM xlong6 AS LONG 'BytesToCopyEachMP3
DIM xlong7 AS LONG 'BytesCopiedTotal
DIM xlong8 AS LONG 'BytesToCopyQueue
DIM xChar1 AS STRING
DIM xchar2 AS STRING

COLOR 7, 0
PRINT "ParsecEx 2.00, Copyright 2003,2004 by Jan Vorel"
PRINT "http://www.ctuser.net   info@ctuser.net"
PRINT "Published under the GNU General Public License"
PRINT "Compressed with upx (http://upx.sourceforge.net)"
PRINT "Parsec homepage: http://www.parsec.org or http://openparsec.sourceforge.net"
PRINT
PRINT "This will extract Parsec LAN-Test music files to .\MP3Music. Please start it"
PRINT "from within you Parsec folder. MP3Music folder will automatically be created."
PRINT
PRINT "Press ESC to abort, ENTER to continue";

DO
  xChar1 = INKEY$
  IF xChar1 = CHR$(27) THEN
    LOCATE , 1
    PRINT LEFT$("aborted." + SPACE$(80), 80)
    END
    END IF
  IF xChar1 = CHR$(13) THEN EXIT DO
  LOOP

LOCATE , 1: PRINT LEFT$("Detecting mp3s..." + SPACE$(80), 80);
FOR xlong1 = 0& TO 3& STEP 3&
  ON ERROR GOTO er1
  CLOSE 1
  OPEN "PSCDATA" + CHR$(48& + xlong1) + ".DAT" FOR INPUT AS 1
  CLOSE 1
  OPEN "PSCDATA" + CHR$(48& + xlong1) + ".DAT" FOR BINARY ACCESS READ AS 1
  ON ERROR GOTO er2
  IF xlong1 = 3& THEN
    xlong3 = xlong2
    END IF

  xChar1 = STRING$(32, CHR$(0))
  GET #1, , xChar1
  DO
    GET #1, , xChar1
    xchar2 = UCASE$(LEFT$(xChar1, INSTR(xChar1, CHR$(0)) - 1))
    IF xchar2 = "" THEN
      EXIT DO
      END IF
    IF RIGHT$(xchar2, 4) = ".MP3" AND NOT LEFT$(xchar2, 4) = "GAME" THEN
      xchara1(xlong2) = xChar1
      xchar2 = MID$(xChar1, 21, 4)
      xlong4 = xlong4 + LenCharToLong(CharSwapDWord(xchar2))
      xlong2 = xlong2 + 1&
      END IF
    LOOP
  NEXT


LOCATE , 1: PRINT LEFT$("Creating directory MP3Music" + SPACE$(80), 80);
ON ERROR GOTO er3
MKDIR "MP3Music"
rs3:
ON ERROR GOTO er2
LOCATE , 1: PRINT LEFT$("Extracting..." + SPACE$(80), 80);


xlong1 = 0&
FOR xlong5 = 0& TO xlong2 - 1&
  IF xlong5 = 0& OR xlong5 = xlong3 THEN
    IF xlong5 = xlong3 THEN
      xlong1 = 3&
      END IF
    ON ERROR GOTO er1
    CLOSE 1
    OPEN "PSCDATA" + CHR$(48& + xlong1) + ".DAT" FOR INPUT AS 1
    CLOSE 1
    OPEN "PSCDATA" + CHR$(48& + xlong1) + ".DAT" FOR BINARY ACCESS READ AS 1
    ON ERROR GOTO er2
    END IF
  CLOSE 2
  xchar2 = LEFT$(xchara1(xlong5), INSTR(xchara1(xlong5), CHR$(0)) - 1)
  ON ERROR GOTO er4
  OPEN "MP3Music\" + xchar2 FOR OUTPUT AS 2
  CLOSE 2
  OPEN "MP3Music\" + xchar2 FOR BINARY ACCESS WRITE AS 2
  ON ERROR GOTO er2
  xlong6 = LenCharToLong&(CharSwapDWord$(MID$(xchara1(xlong5), 21, 4)))
  SEEK 2, LenCharToLong&(CharSwapDWord$(MID$(xchara1(xlong5), 17, 4))) + 1&
  PrintPrg xchar2, xlong7, xlong4
  DO UNTIL xlong6 = 0&
    xlong8 = xlong6
    IF xlong8 > &H1000 THEN
      xlong8 = &H1000
      END IF
    xChar1 = STRING$(xlong8, CHR$(0))
    ON ERROR GOTO er1
    GET #1, , xChar1
    ON ERROR GOTO er4
    PUT #2, , xChar1
    xlong7 = xlong7 + xlong8
    xlong6 = xlong6 - xlong8
    PrintPrg xchar2, xlong7, xlong4
    LOOP
  CLOSE 2
  NEXT
LOCATE , 1
PRINT LEFT$("Successfully extracted " + LTRIM$(RTRIM$(STR$(xlong4))) + " bytes in " + LTRIM$(RTRIM$(STR$(xlong2))) + " files" + SPACE$(80), 80)

rs1:
CLOSE 1
END

er1:
LOCATE , 1
PRINT LEFT$("PSCDATA" + CHR$(48& + xlong1) + ".DAT not found. Please start from Parsec directory" + SPACE$(80), 80)
RESUME rs1

er2:
LOCATE , 1
PRINT LEFT$("Error processing PSCDATA" + CHR$(48& + xlong1) + ".DAT" + SPACE$(80), 80)
RESUME rs1

er3:
LOCATE , 1
PRINT LEFT$("Cannot create directory MP3Music" + SPACE$(80), 80)
IF ERR = 75 THEN
  RESUME rs3
  END IF
RESUME rs1

er4:
LOCATE , 1
PRINT LEFT$("Cannot create/write: " + xchar2 + SPACE$(80), 80)
RESUME rs1

FUNCTION CharSwapDWord$ (xChar1 AS STRING)
DIM xlong1 AS LONG
DIM xchar2 AS STRING


FOR xlong1 = LEN(xChar1) TO 1 STEP -1
  xchar2 = xchar2 + MID$(xChar1, xlong1, 1)
  NEXT

CharSwapDWord$ = xchar2
END FUNCTION

FUNCTION LenCharToLong& (xChar1 AS STRING)
LenCharToLong& = ASC(LEFT$(xChar1, 1&)) * &H1000000 + ASC(MID$(xChar1, 2&, 1&)) * &H10000 + ASC(MID$(xChar1, 3&, 1&)) * &H100& + ASC(MID$(xChar1, 4&, 1&))
END FUNCTION

SUB PrintPrg (xChar1 AS STRING, xlong1 AS LONG, xlong2 AS LONG)
DIM xlong3 AS LONG
DIM xchar2 AS STRING

IF xlong2 = 0& THEN
  COLOR 0, 7
  LOCATE , 1
  PRINT LEFT$("100.00% Extracting: " + xChar1 + SPACE$(80), 80);
  ELSE
  xlong3 = xlong1
  IF xlong3 > xlong2 THEN
    xlong3 = xlong2
    END IF
 
  xchar2 = LTRIM$(RTRIM$(STR$(CINT(xlong3 / xlong2 * 10000) / 100 + .001)))
  xchar2 = LEFT$(xchar2, LEN(xchar2) - 1) + "%"
  IF xlong3 / xlong2 < .01 THEN
    xchar2 = "0" + xchar2
    END IF

  xchar2 = LEFT$(xchar2 + " Extracting: " + xChar1 + SPACE$(80), 80)
  xlong3 = CINT(xlong3 / xlong2 * 80)
  COLOR 0, 7
  LOCATE , 1
  PRINT LEFT$(xchar2, xlong3);
  COLOR 7, 0
  PRINT MID$(xchar2, xlong3 + 1&);
  END IF
END SUB

