Attribute VB_Name = "MODUL_ctPackage"
' Modul for Visual Basic 6
' Copyright (C) 2003,2004 Jan Vorel

' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues

Option Explicit
Option Base 0

'#Const ctPackage_ProgressCTA = True
'#Const ctPackage_UseGetFileList = True
'#Const ctPackage_UseGetFileListLight = True
'#Const ctPackage_UseGetFileListEx = True
'#Const ctPackage_UseGetRawData = True
'#Const ctPackage_UseGetFileListRawData = True
'#Const ctPackage_UseCoding = True


Private Const FilenameOffset As Long = 14&
''Private Const FilenameWidth As Long = 4&
Private Const FilePosOffset As Long = 2&
'Private Const FilePosWidth As Long = 4&
Private Const FileIntOffset As Long = 6&
'Private Const FileIntWidth As Long = 4&
Private Const FileExtOffset As Long = 10&
'Private Const FileExtWidth As Long = 4&


#If ctPackage_ProgressCTA Then
  Public ctPackage_ctProgressBarActl As ctProgressA
  #End If

#If ctPackage_ProgressCTA Then
  Public ctPackage_DefaultBlockSize As Long
  #Else
  Public Const ctPackage_DefaultBlockSize As Long = BinaryMoveFileData_DefaultBlockSize
  #End If
  
Public Const ctPackage_ZLibMinimumCompress As Long = 95&
Public Const ctPackage_VersionInfo As String = "ctpA 1.03.00 2004/05/27"
Public Const ctPackage_Version As Single = 1

#If ctPackage_UseCoding Then
  Public Enum ctPackage_Coding7_Flags
    ctCoding7_CodingNever = -1&
    ctCoding7_FixedCoding0_63 = 0&
    ctCoding7_VariantCoding64_127 = 64&
    ctCoding7_FixedCodingIfPasswordSet128_191 = 128&
    ctCoding7_VariantCodingIfPasswordSet192_255 = 192&
    End Enum
  #End If

Public Enum ctPackage_IfExistsModes
  ctPackage_Exists_NoCheck = 0&
  ctPackage_Exists_Break = 1&
  ctPackage_Exists_Update = 2&
  ctPackage_Exists_Skip = 3&
  ctPackage_Exists_ExceptionError1 = 4&
  ctPackage_Exists_ExceptionStop = 5&
  ctPackage_Exists_ExceptionEnd = 6&
  ctPackage_Exists_ExceptionCrash = 7&
  End Enum

Public Enum ctPackage_DoubleNewFilesModes
  ctPackage_DoubleNewFiles_NoCheck = 0&
  ctPackage_DoubleNewFiles_Break = 1&
  ctPackage_DoubleNewFiles_SkipFirst = 2&
  ctPackage_DoubleNewFiles_SkipLast = 3&
  ctPackage_DoubleNewFiles_ExceptionError1 = 4&
  ctPackage_DoubleNewFiles_ExceptionStop = 5&
  ctPackage_DoubleNewFiles_ExceptionEnd = 6&
  ctPackage_DoubleNewFiles_ExceptionCrash = 7&
  End Enum

#If ctPackage_UseGetFileListEx Then
  Public Enum ctPackage_DisplayModes
    ctPackage_Display_0None = 0&
    ctPackage_Display_1Flags = 1&
    ctPackage_Display_2Accessparams = 2&
    ctPackage_Display_3AccessparamsFlags = 3&
    ctPackage_Display_4Details = 4&
    ctPackage_Display_5DetailsFlags = 5&
    ctPackage_Display_6DetailsAccessparams = 6&
    ctPackage_Display_7DetailsAccessparamsFlags = 7&
    End Enum
  #End If

Public Const ctPackageConst_GetFileList_PosFlag7 As Long = 1&
Public Const ctPackageConst_GetFileList_PosOffset7 As Long = 2&
Public Const ctPackageConst_GetFileList_PosIntSize7 As Long = 6&
Public Const ctPackageConst_GetFileList_PosExtSize7 As Long = 10&
Public Const ctPackageConst_GetFileList_PosFilename7 As Long = 14&

Public Const ctPackageConst_GetFileList_PWParams7 As Long = 13&
'Public Const ctPackageConst_GetFileList_PWFlag As Long = 1&


'Private sChar1 As String
'Private sChar2 As String
'Private sLong1 As Long
'Private sLong2 As Long

Private Const MinFileSize As Long = 26&
Private Const HeaderPreopenSize As Long = 12&
Private Const HeaderPosInfo As Long = 1&
Private Const HeaderPWInfo As Long = 4&
Public Const ctPackageConst_HeaderPosFileCount As Long = 5&
Public Const ctPackageConst_HeaderPosFileNames As Long = 9&
Public Const ctPackageConst_HeaderPosDataSize As Long = 13&
Public Const ctPackageConst_HeaderPWDataSize As Long = 4&

Public Const ctPackageConst_HeaderSize As Long = 16&
Public Const ctPackageConst_HeaderInfoText As String = "ctpA"
Public Const ctPackageConst_HeaderEmptyNullsWidth As Long = 12&

Public Const ctPackageConst_TOCWidth As Long = 13&
Public Const ctPackageConst_TOCPosFlags As Long = 1&
Public Const ctPackageConst_TOCPWFlags As Long = 1&
Public Const ctPackageConst_TOCPosFileNameSize As Long = 2&
Public Const ctPackageConst_TOCPosIntSize As Long = 6&
Public Const ctPackageConst_TOCPosExtSize As Long = 10&
Private Const TOCSizeHolderSmall As Long = 4&

Public Const ctPackageConst_TOCOverWriteExtSizePos As Long = 9&
Public Const ctPackageConst_TOCOverWriteExtSizePosRs As Long = 14&
Public Const ctPackageConst_TOCParamPosExtSize As Long = 10&
'Public Const ctPackageConst_TOCOverWriteExtSizePos As Long = 5&
'Public Const ctPackageConst_TOCOverWriteExtSizePosRs As Long = 10&
'Public Const ctPackageConst_TOCParamPosExtSize As Long = 6&

'Private Const TOCPWFirst As Long = 5& ''''4&?
'Private Const TOCPWFirstStart As Long = 0&
'Private Const TOCPWFirstSpace As Long = 4&
'Private Const TOCPWFirstWidth As Long = 0&
Public Const ctPackageConst_TOCPWSecondStart As Long = 2&
Public Const ctPackageConst_TOCPWSecondWidth As Long = 4&
Public Const ctPackageConst_TOCPosLast As Long = 10&
Public Const ctPackageConst_TOCSizeTotal As Long = 26& '(minfilesize)

Public Const ctPackageConst_EndSize As Long = 10&
Public Const ctPackageConst_EndSizeMinus As Long = 9&
Public Const ctPackageConst_EndSizeLeft As Long = 3&
Public Const ctPackageConst_EndSizeRight As Long = 3&
Public Const ctPackageConst_EndSizeStart As Long = 4&
Public Const ctPackageConst_EndSizeWidth As Long = 4&
Public Const ctPackageConst_EndSizeText As String = "eofctp"
Public Const ctPackageConst_EndSizeText1 As String = "eof"
Public Const ctPackageConst_EndSizeText2 As String = "ctp"

#If ctPackage_ProgressCTA Then
  Public Sub ctPackage_Init(ByVal ProgressControl As ctProgressA, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize) ', ByVal ResStartID As Long)
    Set ctPackage_ctProgressBarActl = ProgressControl
    ctPackage_DefaultBlockSize = BlockSize 'BinaryMoveFileData_DefaultBlockSize
    End Sub
  '#Else
'  Public Sub ctPackage_Init(ByVal BlockSize As Long)
  #End If

Public Function ctPackage_GetHeaderPos(ByVal FileID As Long) As Long
Dim xLong1 As Long
Dim xChar1 As String

xChar1 = String(ctPackageConst_EndSize, vbNullChar)
xLong1 = LOF(FileID)
If xLong1 < MinFileSize Then
  ctPackage_GetHeaderPos = -1
  Else
  Get FileID, xLong1 - ctPackageConst_EndSizeMinus, xChar1
  If Left(xChar1, ctPackageConst_EndSizeLeft) & Right(xChar1, ctPackageConst_EndSizeRight) = ctPackageConst_EndSizeText Then
    ctPackage_GetHeaderPos = LenCharToLong(xChar1, ctPackageConst_EndSizeStart)
    xChar1 = String(HeaderPWInfo, vbNullChar)
    Get FileID, ctPackage_GetHeaderPos + 1&, xChar1
    If Not xChar1 = ctPackageConst_HeaderInfoText Then
      ctPackage_GetHeaderPos = -1
      End If
    Else
    ctPackage_GetHeaderPos = -1&
    End If
  End If
End Function


#If ctPackage_UseGetFileList Or ctPackage_UseGetFileListEx Or ctPackage_UseGetFileListlight Or ctPackage_UseGetRawData Or ctPackage_UseGetFileListRawData Then
  #If ctPackage_UseGetFileListEx Or ctPackage_UseGetRawData Or ctPackage_UseGetFileListRawData Then
    #If ctPackage_UseGetFileListEx Then
      Public Function ctPackage_GetFileList(ByVal FileID As Long, ByVal HeaderPos As Long, ByRef FileArray() As String, ByVal FileArraySize As Long, Optional ByVal DisplayMode As ctPackage_DisplayModes = ctPackage_Display_7DetailsAccessparamsFlags, Optional ByRef UncompressedSize As Long, Optional ByVal IndexStep As Long = 1&, Optional ByVal IndexStart As Long = 0&) As Long
      #Else
      Public Function ctPackage_GetFileList(ByVal FileID As Long, ByVal HeaderPos As Long, ByRef FileArray() As String, ByVal FileArraySize As Long) As Long
      #End If
    #Else
    #If ctPackage_UseGetFileListlight Then
      Public Function ctPackage_GetFileList(ByVal FileID As Long, ByVal HeaderPos As Long, ByRef FileArray() As String, ByVal FileArraySize As Long) As Long
      #Else
      Public Function ctPackage_GetFileList(ByVal FileID As Long, ByVal HeaderPos As Long, ByRef FileArray() As String, ByVal FileArraySize As Long, Optional ByVal IndexStep As Long = 1&, Optional ByVal IndexStart As Long = 0&) As Long
      #End If
    #End If

Dim xLong1 As Long
Dim xLong2 As Long
Dim xChar1 As String
Dim xChar2 As String
#If ctPackage_UseGetFileListlight Or ctPackage_UseGetRawData Or ctPackage_UseGetFileListRawData Then
  Dim IndexStart As Long
  #End If
#If ctPackage_UseGetFileListlight = False Then
  Dim xDataPos As Long
  #End If

If HeaderPos = -1& Then
  ctPackage_GetFileList = -1&
  Else
  xChar1 = String(ctPackageConst_HeaderSize, vbNullChar)
  Get FileID, HeaderPos + 1&, xChar1
  ctPackage_GetFileList = LenCharToLong(xChar1, ctPackageConst_HeaderPosFileCount)
  xLong1 = LenCharToLong(xChar1, ctPackageConst_HeaderPosFileNames)
  xChar1 = String(ctPackage_GetFileList * ctPackageConst_TOCWidth, vbNullChar)
  xChar2 = String(xLong1, vbNullChar)
  Get FileID, HeaderPos + ctPackageConst_HeaderSize + 1&, xChar1
  xDataPos = HeaderPos + ctPackageConst_HeaderSize + ctPackage_GetFileList * ctPackageConst_TOCWidth + xLong1
  Get FileID, , xChar2
  If ctPackage_GetFileList > FileArraySize Then
    ctPackage_GetFileList = FileArraySize
    End If
  #If ctPackage_UseGetFileListEx Then
    UncompressedSize = 0&
    #End If
  For xLong1 = 0& To ctPackage_GetFileList - 1&
    xLong2 = LenCharToLong(xChar1, xLong1 * ctPackageConst_TOCWidth + ctPackageConst_TOCPosFileNameSize)
    
    #If ctPackage_UseGetRawData Or ctPackage_UseGetFileListRawData Then
      FileArray(IndexStart) = Mid(xChar1, xLong1 * ctPackageConst_TOCWidth + ctPackageConst_TOCPosFlags, ctPackageConst_TOCPWFlags) & _
                              LenLongToChar(xDataPos) & FileArray(IndexStart) & _
                              Mid(xChar1, xLong1 * ctPackageConst_TOCWidth + ctPackageConst_TOCPosIntSize, 4& + 4&) & _
                              Left(xChar2, xLong2)
      xDataPos = xDataPos + LenCharToLong(xChar1, xLong1 * ctPackageConst_TOCWidth + ctPackageConst_TOCPosIntSize)
      #Else
      FileArray(IndexStart) = Left(xChar2, xLong2)
      #End If
    
    #If ctPackage_UseGetFileListEx Then
      If (DisplayMode And 4&) = 4& Then
        FileArray(IndexStart) = Mid(xChar1, xLong1 * ctPackageConst_TOCWidth + ctPackageConst_TOCPosIntSize, 4& + 4&) & FileArray(IndexStart)
        End If
      If (DisplayMode And 2&) = 2& Then
        FileArray(IndexStart) = LenLongToChar(xDataPos) & FileArray(IndexStart)
        xDataPos = xDataPos + LenCharToLong(xChar1, xLong1 * ctPackageConst_TOCWidth + ctPackageConst_TOCPosIntSize)
        End If
      If (DisplayMode And 1&) = 1& Then
        FileArray(IndexStart) = Mid(xChar1, xLong1 * ctPackageConst_TOCWidth + ctPackageConst_TOCPosFlags, ctPackageConst_TOCPWFlags) & FileArray(IndexStart)
        End If
      #End If
    #If ctPackage_UseGetFileListEx Then
      End If
      UncompressedSize = UncompressedSize + LenCharToLong(xChar1, xLong1 * ctPackageConst_TOCWidth + ctPackageConst_TOCPosExtSize)
      #End If
    xChar2 = Mid(xChar2, xLong2 + 1&)
    #If ctPackage_UseGetFileListEx Or ctPackage_UseGetFileList Then
      IndexStart = IndexStart + IndexStep
      #Else
      #If ctPackage_UseGetFileListRawData Then
        IndexStart = IndexStart + 2&
        #Else
        IndexStart = IndexStart + 1&
        #End If
      #End If
    Next
  End If
End Function

#End If

#If ctPackage_UseGetRawData Or ctPackage_UseGetFileListRawData Then
  #If ctPackage_UseCoding Then
    Public Function ctPackage_GetRawFileData(ByVal FileID As Long, ByVal IntExtFilesData As String, Optional ByVal Password As String, Optional ByVal Code7Flags As ctPackage_Coding7_Flags = ctCoding7_VariantCodingIfPasswordSet192_255, Optional ByRef ReturnSize As Long) As String
    #Else
    Public Function ctPackage_GetRawFileData(ByVal FileID As Long, ByVal IntExtFilesData As String, Optional ByRef ReturnSize As Long) As String
    #End If
  
    ctPackage_GetRawFileData = String(LenCharToLong(IntExtFilesData, FileIntOffset), vbNullChar)
    Get FileID, LenCharToLong(IntExtFilesData, FilePosOffset) + 1&, ctPackage_GetRawFileData
    ReturnSize = LenCharToLong(IntExtFilesData, FileExtOffset)
    FileID = Asc(Left(IntExtFilesData, 1))
    #If ctPackage_UseCoding Then
      If (FileID And 2&) = 2& Then
        ctPackage_GetRawFileData = ctCoding7_Decode(ctPackage_GetRawFileData, Password, Code7Flags)
        End If
      #End If
    If (FileID And 1&) = 1& Then
      Stop
      ctPackage_GetRawFileData = ZLibDecompress(ctPackage_GetRawFileData, ReturnSize)
      End If
    End Function
  #End If

#If ctPackage_UseGetRawDataContent Then
  Public Function ctPackage_GetRawFileDataContent(ByVal FileID As Long, ByVal IntExtFilesData As String) As String
'    Stop
    ctPackage_GetRawFileDataContent = String(LenCharToLong(IntExtFilesData, FileIntOffset), vbNullChar)
    Get FileID, LenCharToLong(IntExtFilesData, FilePosOffset) + 1&, ctPackage_GetRawFileDataContent
    ctPackage_GetRawFileDataContent = Left(IntExtFilesData, 1&) & String(4&, vbNullChar) & Mid(IntExtFilesData, 6&, 8&) & ctPackage_GetRawFileDataContent
    End Function
  
  #If ctPackage_UseGetRawDataContentUse Then
    #If ctPackage_UseCoding Then
      Public Function ctPackage_GetRawFileDataContent_Use(ByVal RawDataContent As String, Optional ByVal Password As String, Optional ByVal Code7Flags As ctPackage_Coding7_Flags = ctCoding7_VariantCodingIfPasswordSet192_255, Optional ByRef ReturnSize As Long) As String
      #Else
      Public Function ctPackage_GetRawFileDataContent_Use(ByVal RawDataContent As String, Optional ByRef ReturnSize As Long) As String
      #End If

    ReturnSize = Asc(Left(RawDataContent, 1&))
    ctPackage_GetRawFileDataContent_Use = Mid(RawDataContent, 14&)
    #If ctPackage_UseCoding Then
      If (ReturnSize And 2&) = 2& Then
        ctPackage_GetRawFileDataContent_Use = ctCoding7_Decode(ctPackage_GetRawFileDataContent_Use, Password, Code7Flags)
        End If
      #End If
    If (ReturnSize And 1&) = 1& Then
'      Stop
      ctPackage_GetRawFileDataContent_Use = ZLibDecompress(ctPackage_GetRawFileDataContent_Use, ReturnSize)
      End If

    ReturnSize = LenCharToLong(RawDataContent, FileExtOffset)
    End Function
    #End If
  #End If

