Attribute VB_Name = "mod_DrawRawBMP"
Option Explicit
Option Base 0

Private Type BITMAPINFOHEADER   '40 bytes
  biSize As Long
  biWidth As Long
  biHeight As Long
  biPlanes As Integer
  biBitCount As Integer
  biCompression As Long
  biSizeImage As Long
  biXPelsPerMeter As Long
  biYPelsPerMeter As Long
  biClrUsed As Long
  biClrImportant As Long
  End Type

Private Type RGBQUAD
  rgbBlue As Byte
  rgbGreen As Byte
  rgbRed As Byte
  rgbReserved As Byte
  End Type

Private Type BITMAPINFO_4
   bmiHeader As BITMAPINFOHEADER
   bmiColors(15) As RGBQUAD
End Type

Private Type BITMAPINFO_8
  bmiHeader As BITMAPINFOHEADER
  bmiColors(255) As RGBQUAD
  End Type

Private Type BITMAPINFO_24
  bmiHeader As BITMAPINFOHEADER
  End Type

Private Declare Function CreateCompatibleBitmap Lib "gdi32" (ByVal HDC As Long, ByVal nWidth As Long, ByVal nHeight As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal HDC As Long, ByVal hObject As Long) As Long
Private Declare Function SetDIBits_4 Lib "gdi32" Alias "SetDIBits" (ByVal aHDC As Long, ByVal hBitmap As Long, ByVal nStartScan As Long, ByVal nNumScans As Long, lpBits As Any, lpBI As BITMAPINFO_4, ByVal wUsage As Long) As Long
Private Declare Function SetDIBits_8 Lib "gdi32" Alias "SetDIBits" (ByVal aHDC As Long, ByVal hBitmap As Long, ByVal nStartScan As Long, ByVal nNumScans As Long, lpBits As Any, lpBI As BITMAPINFO_8, ByVal wUsage As Long) As Long
Private Declare Function SetDIBits_24 Lib "gdi32" Alias "SetDIBits" (ByVal aHDC As Long, ByVal hBitmap As Long, ByVal nStartScan As Long, ByVal nNumScans As Long, lpBits As Any, lpBI As BITMAPINFO_24, ByVal wUsage As Long) As Long
Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long


#If DrawRawBMP_Extended Then
  Private Declare Function GetDC Lib "user32" (ByVal hWnd As Long) As Long
  Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal HDC As Long) As Long
  Private Declare Function ReleaseDC Lib "user32" (ByVal hWnd As Long, ByVal HDC As Long) As Long
  #End If

Private Declare Sub RtlMoveMemory Lib "kernel32" (lpvDest As Any, lpvSource As Any, ByVal cbCopy As Long)

#If DrawRawBMP_Extended Then
  Public Function DrawRawBMP(ByVal DestHDc As Long, ByVal xData As String, Optional ByVal OffsetLeft As Long = 0&, Optional ByVal OffsetTop As Long = 0&, Optional ByRef Width As Long = -1&, Optional ByRef Height As Long = -1&) As Boolean
  #Else
  Public Function DrawRawBMP(ByVal DestHDc As Long, ByVal xData As String) As Boolean
  #End If

Dim xType1 As BITMAPINFOHEADER
Dim xType2 As BITMAPINFO_24
Dim xType3 As BITMAPINFO_8
Dim xType4 As BITMAPINFO_4
Dim xLong1 As Long

#If DrawRawBMP_Extended Then
  Dim ScreenDC As Long
  Dim PicDC As Long
  #End If

' 14+40-1  + 40(10xx)
If Len(xData) > 93& Then
  xData = Mid(xData, 15&)
  Call RtlMoveMemory(xType1, ByVal xData, 40&)
  If xType1.biBitCount = 24 Then
    Call RtlMoveMemory(xType2, ByVal xData, 40&)
    xData = Mid(xData, 41&)
    ElseIf xType1.biBitCount = 8 And Len(xData) > 1064& Then
    Call RtlMoveMemory(xType3, ByVal xData, 1064&)
    xData = Mid(xData, 1065&)
    ElseIf xType1.biBitCount = 4 And Len(xData) > 0& Then
    Call RtlMoveMemory(xType4, ByVal xData, 104&)
    xData = Mid(xData, 105&)
    Else
    Exit Function
    End If
    
  #If DrawRawBMP_Extended Then
    ScreenDC = GetDC(0)
    PicDC = CreateCompatibleDC(ScreenDC)
    #End If
  
  xLong1 = CreateCompatibleBitmap(DestHDc, xType1.biWidth, xType1.biHeight)
  If Not xLong1 = 0& Then
    If xType1.biBitCount = 24 Then
      #If DrawRawBMP_Extended Then
        Call SetDIBits_24(PicDC, xLong1, 0&, xType1.biHeight, ByVal xData, xType2, 0&)
        #Else
        Call SetDIBits_24(DestHDc, xLong1, 0&, xType1.biHeight, ByVal xData, xType2, 0&)
        #End If
      ElseIf xType1.biBitCount = 8 Then
      #If DrawRawBMP_Extended Then
        Call SetDIBits_8(PicDC, xLong1, 0&, xType1.biHeight, ByVal xData, xType3, 0&)
        #Else
        Call SetDIBits_8(DestHDc, xLong1, 0&, xType1.biHeight, ByVal xData, xType3, 0&)
        #End If
      Else
      #If DrawRawBMP_Extended Then
        Call SetDIBits_4(PicDC, xLong1, 0&, xType1.biHeight, ByVal xData, xType4, 0&)
        #Else
        Call SetDIBits_4(DestHDc, xLong1, 0&, xType1.biHeight, ByVal xData, xType4, 0&)
        #End If
      End If
    #If DrawRawBMP_Extended Then
      If Height = -1& Then Height = xType1.biHeight
      If Width = -1& Then Width = xType1.biWidth
      Call SelectObject(PicDC, xLong1)
      Call BitBlt(DestHDc, OffsetLeft, OffsetTop, Width, Height, PicDC, 0&, 0&, vbSrcCopy)
      Call DeleteObject(xLong1)
      Call ReleaseDC(0, ScreenDC)
      Height = xType1.biHeight
      Width = xType1.biWidth
      #Else
      Call SelectObject(DestHDc, xLong1)
      Call DeleteObject(xLong1)
      #End If
    DrawRawBMP = True
    End If
  End If
End Function


