Attribute VB_Name = "Huffman"
Option Explicit
Option Base 0

Private Declare Sub RtlMoveMemory Lib "kernel32" (Destination As Any, Source As Any, ByVal Length As Long)

#If SpecialTestVersion Then
'Public Function Compress_HuffMan(ByVal Data As String) As String
Public Function ZLibCompress(ByRef Data As String) As String
  Dim FileArray() As Byte
  Dim X As Long
  Dim Y As Long
  Dim Z As Long
  Dim Char As Long
  Dim Bitlen As Long
  Dim FileLen As Long
  Dim TelBits As Long
  Dim TotBits As Long
  Dim OutStream() As Byte
  Dim TreeNodesA(511) As Long
  Dim TreeNodesB(511) As Long
  Dim TreeNodesC(511) As Long
  Dim TreeNodesD(511) As Long
  Dim TreeNodesE(511) As Long
  Dim BitValue(7) As Long
  Dim ByteValue As Long
  Dim ByteBuff As String
  Dim NumberOfNodes As Long
  Dim OrgNumberOfNodes As Long
  Dim PackedSize As Long
  Dim DictSize As Long
  Dim OutPutSize As Long
  Dim CharCount(255) As Long
  Dim Bits(255) As String
  Dim Nubits As String
  Dim TempBits As String
  Dim lTemp As Long
  Dim lWeight As Long
  Dim rWeight As Long
  Dim MaxWeight As Long
  Dim NowWeight As Long
  Dim lNode As Long
  Dim rNode As Long
  Dim StringBuffer As String
    
  FileLen = Len(Data) - 1&
  If Not FileLen = -1& Then
  
    ReDim FileArray(FileLen)
    Call RtlMoveMemory(FileArray(0), ByVal Data, FileLen + 1&)
    
    OutPutSize = -1&
    If Not (FileLen = 0) Then
      For X = 0 To FileLen
        CharCount(FileArray(X)) = CharCount(FileArray(X)) + 1
        Next
      MaxWeight = FileLen + 1
      Z = -1
      For X = 0 To 255
        If Not CharCount(X) = 0 Then
          Z = Z + 1
          TreeNodesA(Z) = CharCount(X)
          TreeNodesB(Z) = X
          TreeNodesC(Z) = -1     'leftnode
          TreeNodesD(Z) = -1     'rightnode
          TreeNodesE(Z) = -1     'parentnode
          End If
        Next
      NumberOfNodes = Z
      OrgNumberOfNodes = NumberOfNodes
      For X = NumberOfNodes + 1 To 2 Step -1
        lWeight = MaxWeight * 2: rWeight = MaxWeight * 2
        For Y = 0 To NumberOfNodes + 1
          If TreeNodesE(Y) = -1 Then
            NowWeight = TreeNodesA(Y)
            If NowWeight < rWeight Or NowWeight < lWeight Then
              If rWeight > lWeight Then
                rWeight = NowWeight
                rNode = Y
                Else
                lWeight = NowWeight
                lNode = Y
                End If
              End If
            End If
          Next Y
        NumberOfNodes = NumberOfNodes + 1
        TreeNodesE(lNode) = NumberOfNodes
        TreeNodesE(rNode) = NumberOfNodes
        TreeNodesA(NumberOfNodes) = lWeight + rWeight
        TreeNodesB(NumberOfNodes) = -1
        TreeNodesC(NumberOfNodes) = lNode
        TreeNodesD(NumberOfNodes) = rNode
        TreeNodesE(NumberOfNodes) = -1
        Next
      TotBits = 0
      For X = 0 To OrgNumberOfNodes
        Char = TreeNodesB(X)
        Y = X
        Z = Y
        Do Until TreeNodesE(Y) = -1&
          Y = TreeNodesE(Y)
          If TreeNodesC(Y) = Z Then
            Bits(Char) = vbNullChar & Bits(Char)
            ElseIf TreeNodesD(Y) = Z Then
            Bits(Char) = Chr(1) & Bits(Char)
            Else
            MsgBox "error creating bitpatern"
            Exit Function
            End If
          TotBits = TotBits + 1
          Z = Y
          Loop
        PackedSize = PackedSize + (TreeNodesA(X) * (Len(Bits(Char))))
        DictSize = DictSize + 2
        Next
      PackedSize = (PackedSize + 7&) \ 8&
      Bitlen = (TotBits + 7&) \ 8&
      
      ReDim OutStream(4 + DictSize + Bitlen + 4 + PackedSize + 1)   '-2 tolerate
      For X = 0& To 7&
        BitValue(X) = 2& ^ X
        Next
      TotBits = 0&
      TelBits = 7&
      ByteBuff = ""
      For X = 0& To OrgNumberOfNodes
        Char = TreeNodesB(X)
        Bitlen = Len(Bits(Char))
        TotBits = TotBits + Bitlen
        StringBuffer = StringBuffer & Chr(Char) & Chr(Bitlen)
        For Y = 1& To Bitlen
          If Mid(Bits(Char), Y, 1) = vbNullChar Then
            ByteValue = ByteValue + BitValue(TelBits)
            End If
          TelBits = TelBits - 1
          If TelBits = -1 Then
            ByteBuff = ByteBuff & Chr(ByteValue)
            TelBits = 7
            ByteValue = 0
            End If
          Next
        Next
      If Not TelBits = 7& Then
        ByteBuff = ByteBuff & Chr(ByteValue)
        End If
      StringBuffer = StringBuffer & ByteBuff
      Call AddLong2Array(OutStream, OutPutSize, DictSize)
      ByteValue = Len(StringBuffer)
      For TelBits = 1 To ByteValue
        OutStream(OutPutSize + TelBits) = Asc(Mid(StringBuffer, TelBits, 1&))
        Next
      OutPutSize = OutPutSize + ByteValue
      Call AddLong2Array(OutStream, OutPutSize, FileLen + 1&)
      TelBits = 7
      ByteValue = 0
      For X = 0 To FileLen
        For Y = 1 To Len(Bits(FileArray(X)))
          If Mid(Bits(FileArray(X)), Y, 1) = vbNullChar Then
            ByteValue = ByteValue + BitValue(TelBits)
            End If
          TelBits = TelBits - 1
          If TelBits = -1 Then
            OutPutSize = OutPutSize + 1
            OutStream(OutPutSize) = ByteValue
            TelBits = 7
            ByteValue = 0
            End If
          Next
        Next
      If TelBits <> 7 Then
        OutPutSize = OutPutSize + 1
        OutStream(OutPutSize) = ByteValue
        End If
        
      ReDim Preserve OutStream(OutPutSize)
      OutPutSize = OutPutSize + 1&
      ZLibCompress = String(OutPutSize, vbNullChar)
      Call RtlMoveMemory(ByVal ZLibCompress, OutStream(0), OutPutSize)
      End If
    End If
  End Function
#End If

Public Function ZLibDecompress(ByRef Data As String, ByVal OldSize As Long) As String
'Public Function Decompress_Huffman(ByVal Data As String) As String
  Dim FileArray() As Byte
  Dim DeCompressed() As Byte
  Dim X As Long
  Dim Y As Long
  Dim Z As Long
  Dim TreeNodesA(511) As Long
  Dim TreeNodesB(511) As Long
  Dim TreeNodesC(511) As Long
  Dim TreeNodesD(511) As Long
  Dim TreeNodesE(511) As Long
  Dim LeafA(255) As Long
  Dim LeafB(255) As Long
  Dim ByteValue As Long
  Dim BitValue(7) As Long
  Dim NumberOfNodes As Long
  Dim NuNode As Long
  Dim ToNode As Long
  Dim Char As Long
  Dim Bitlen As Long
  Dim Bits(255) As String
  Dim TempBits As String
  Dim StringBuffer As String
  Dim TotBits As Long
  Dim TelBits As Long
  Dim DictSize As Long
  Dim InpPos As Long
  Dim OrgLen As Long
  Dim Nulen As Long

  'Exit Function
  TotBits = Len(Data)
  If Not TotBits = 0& Then
    ReDim FileArray(TotBits - 1&)
    Call RtlMoveMemory(FileArray(0), ByVal Data, TotBits)
    DictSize = GetLongFromArray(FileArray, InpPos)
    For X = 0 To 7
      BitValue(X) = 2 ^ X
      Next
    TotBits = 0
    Do While InpPos < DictSize + 3&
      LeafA(TotBits) = FileArray(InpPos)
      LeafB(TotBits) = FileArray(InpPos + 1&)
      InpPos = InpPos + 2&
      TotBits = TotBits + 1&
      Loop
    TelBits = -1
    For X = 0 To TotBits - 1
      For Y = 1 To LeafB(X)
        If TelBits = -1 Then
          ByteValue = FileArray(InpPos)
          InpPos = InpPos + 1&
          TelBits = 7
          End If
        Bits(LeafA(X)) = Bits(LeafA(X)) & Chr(-1& * ((ByteValue And BitValue(TelBits)) > 0))
        TelBits = TelBits - 1
        Next Y
      Next X
    NumberOfNodes = -1
    NuNode = -1
    GoSub Create_New_Node
    For X = 0 To 255
      If Not Bits(X) = "" Then
        NuNode = 0
        For Y = 1 To Len(Bits(X))
          If Mid(Bits(X), Y, 1&) = vbNullChar Then
            ToNode = TreeNodesC(NuNode)
            If ToNode = -1 Then GoSub Create_New_Node
            TreeNodesC(NuNode) = ToNode
            Else
            ToNode = TreeNodesB(NuNode)
            If ToNode = -1 Then GoSub Create_New_Node
            TreeNodesB(NuNode) = ToNode
            End If
          NuNode = ToNode
          Next
        TreeNodesA(NuNode) = X
        TreeNodesE(NuNode) = 255
        End If
      Next
      
    OrgLen = GetLongFromArray(FileArray, InpPos)
    ReDim DeCompressed(OrgLen - 1)
    Nulen = 0
    NuNode = 0
    StringBuffer = ""
    TelBits = 7
    Do While Nulen < OrgLen
      If TelBits = -1 Then
        InpPos = InpPos + 1
        TelBits = 7
        End If
      If (FileArray(InpPos) And 2 ^ TelBits) > 0 Then
        NuNode = TreeNodesB(NuNode)    'left
        Else
        NuNode = TreeNodesC(NuNode)    'right
        End If
      If NuNode = 0 Then
        Err.Raise vbError, "DecompressHuffman", "We zijn de boom tot op een dood punt genaderd, waarschijnlijk is de header beschadigd"
        Exit Function
        End If
      If TreeNodesE(NuNode) = 255 Then           'we zijn bij het blaadje
        DeCompressed(Nulen) = TreeNodesA(NuNode)
        Nulen = Nulen + 1
        NuNode = 0
        End If
      TelBits = TelBits - 1
      Loop
    ZLibDecompress = String(OrgLen, vbNullChar)
    Call RtlMoveMemory(ByVal ZLibDecompress, DeCompressed(0), OrgLen)
    End If
  Exit Function
    
Create_New_Node:
  NumberOfNodes = NumberOfNodes + 1
  TreeNodesA(NumberOfNodes) = -1
  TreeNodesB(NumberOfNodes) = -1
  TreeNodesC(NumberOfNodes) = -1
  TreeNodesD(NumberOfNodes) = NuNode
  TreeNodesE(NumberOfNodes) = -1
  ToNode = NumberOfNodes
  Return
End Function

Private Sub AddLong2Array(ByRef WichArray() As Byte, ByRef StartPos As Long, ByVal xLong1 As Long)
  Dim xLong2 As Long
  
  xLong2 = xLong1 \ &H1000000
  xLong1 = xLong1 - xLong2 * &H1000000
  WichArray(StartPos + 1&) = xLong2
  
  xLong2 = xLong1 \ &H10000
  xLong1 = xLong1 - xLong2 * &H10000
  WichArray(StartPos + 2&) = xLong2
  
  xLong2 = xLong1 \ &H100&
  WichArray(StartPos + 3&) = xLong2
  WichArray(StartPos + 4&) = xLong1 - xLong2 * &H100&
  
  StartPos = StartPos + 4
  End Sub

Private Function GetLongFromArray(ByRef WichArray() As Byte, ByRef StartPos As Long) As Long
  GetLongFromArray = WichArray(StartPos) * &H1000000 + _
                     WichArray(StartPos + 1&) * &H10000 + _
                     WichArray(StartPos + 2&) * &H100& + _
                     WichArray(StartPos + 3&)
  StartPos = StartPos + 4&
  End Function

