Attribute VB_Name = "MODUL_BinaryMoveFileData"
' modul for Visual Basic 6
' Copyright (C) 2003,2004 Jan Vorel

' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues

'#Const BinaryMoveFileData_ProgressCTA = True
'#Const BinaryMoveFileData_ProgressCallBack = True
'   Public Function BinaryMoveFileData_CallBack(ByVal Value As Single)
'#Const BinaryMoveFileData_ProgressCallBackEx = True
'   Public Function BinaryMoveFileData_CallBack(ByVal Value As Single, ByVal xEvent As Long, ByVal MoreToDo As Boolean, ByVal BytesProcessed As Long)
'#Const BinaryMoveFileData_ProgressExtraLarge = True


' 0 clearing (1)
' 1 clearing (1) finished
' 2 copying
' 3 (copying) finished
' 4 clearing (1)
' 5 clearing (1) finished

Option Explicit
Option Base 0

Public Const BinaryMoveFileData_DefaultBlockSize As Long = &H3FFF00


#If BinaryMoveFileData_CanAbortCopying Then
  Public BinaryMoveFileData_AbortCopying As Boolean
  #End If
  


Public Enum BinaryMoveFileData_OverwriteWithNullcharModes
  BinaryMoveFileData_NullstringNo = 0&
  BinaryMoveFileData_NullstringNew = 1&
  BinaryMoveFileData_NullstringOld = 2&
  BinaryMoveFileData_NullstringBoth = 3&
  BinaryMoveFileData_NullstringIfLarger = 4&
  End Enum
  
#If BinaryMoveFileData_ProgressCTA Then
  #If BinaryMoveFileData_ProgressExtraLarge Then
    Public Function BinaryMoveFileData(ByVal FileMode As Long, ByVal Size As Long, ByVal StartPos As Long, ByVal NewPos As Long, ByVal ProgressControl As ctProgressA, Optional ByVal OutFileMode As Long = -1&, Optional ByVal OverwriteWithNullchars As BinaryMoveFileData_OverwriteWithNullcharModes = BinaryMoveFileData_NullstringIfLarger, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize, Optional ByVal ProgressStart As Double = 0#, Optional ByVal ProgressTotal As Double = 0#) As Boolean
    #Else
    Public Function BinaryMoveFileData(ByVal FileMode As Long, ByVal Size As Long, ByVal StartPos As Long, ByVal NewPos As Long, ByVal ProgressControl As ctProgressA, Optional ByVal OutFileMode As Long = -1&, Optional ByVal OverwriteWithNullchars As BinaryMoveFileData_OverwriteWithNullcharModes = BinaryMoveFileData_NullstringIfLarger, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize, Optional ByVal ProgressStart As Long = 0&, Optional ByVal ProgressTotal As Long = 0&) As Boolean
    #End If
  #Else
  #If BinaryMoveFileData_ProgressCallBack Or BinaryMoveFileData_ProgressCallBackEx Then
    #If BinaryMoveFileData_ProgressExtraLarge Then
      Public Function BinaryMoveFileData(ByVal FileMode As Long, ByVal Size As Long, ByVal StartPos As Long, ByVal NewPos As Long, Optional ByVal OutFileMode As Long = -1&, Optional ByVal OverwriteWithNullchars As BinaryMoveFileData_OverwriteWithNullcharModes = BinaryMoveFileData_NullstringIfLarger, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize, Optional ByVal ProgressStart As Double = 0#, Optional ByVal ProgressTotal As Double = 0#) As Boolean
      #Else
      Public Function BinaryMoveFileData(ByVal FileMode As Long, ByVal Size As Long, ByVal StartPos As Long, ByVal NewPos As Long, Optional ByVal OutFileMode As Long = -1&, Optional ByVal OverwriteWithNullchars As BinaryMoveFileData_OverwriteWithNullcharModes = BinaryMoveFileData_NullstringIfLarger, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize, Optional ByVal ProgressStart As Long = 0&, Optional ByVal ProgressTotal As Long = 0&) As Boolean
      #End If
    #Else
    Public Function BinaryMoveFileData(ByVal FileMode As Long, ByVal Size As Long, ByVal StartPos As Long, ByVal NewPos As Long, Optional ByVal OutFileMode As Long = -1&, Optional ByVal OverwriteWithNullchars As BinaryMoveFileData_OverwriteWithNullcharModes = BinaryMoveFileData_NullstringIfLarger, Optional ByVal BlockSize As Long = BinaryMoveFileData_DefaultBlockSize) As Boolean
    #End If
  #End If
Dim xLong1 As Long
Dim xLong2 As Long
Dim xLong3 As Long
Dim xLong4 As Long
Dim xLong5 As Long
Dim xChar1 As String
#If BinaryMoveFileData_ProgressCallBackEx Then
  Dim CallBackModeAdding As Long
  Dim xMoreJobs As Boolean
  Dim xMustDelAfterCopying As Boolean
  #End If

On Error GoTo Er1
On Error GoTo 0

#If BinaryMoveFileData_CanAbortCopying Then
  BinaryMoveFileData_AbortCopying = False
  #End If

If OutFileMode = -1& Then
  OutFileMode = FileMode
  End If


If FileMode = OutFileMode Then
  If NewPos > StartPos Then
    xLong1 = NewPos - StartPos
    Else
    xLong1 = StartPos - NewPos
    End If
  If xLong1 > Size Then xLong1 = Size
  Else
  xLong1 = Size
  End If

'Select Case OverwriteWithNullchars
'  Case BinaryMoveFileData_NullstringNew, BinaryMoveFileData_NullstringOld
'    xLong5 = Size + xLong1
'  Case BinaryMoveFileData_NullstringBoth
'    xLong5 = Size + 2 * xLong1
'  Case BinaryMoveFileData_NullstringIfLarger
'    If NewPos > StartPos Then
'      xLong5 = Size + xLong1
'      Else
'      xLong5 = Size
'      End If
'  Case Else
'    xLong5 = Size
'  End Select


xLong5 = Size
If (Not NewPos = StartPos And FileMode = OutFileMode) Or _
  Not FileMode = OutFileMode And _
  (OverwriteWithNullchars = 1& Or OverwriteWithNullchars = 3& Or _
  OverwriteWithNullchars = 4& And NewPos > StartPos) Then
  xLong5 = xLong5 + xLong1
  End If

'If (Not NewPos = StartPos And FileMode = OutFileMode) Or _
'  Not FileMode = OutFileMode And _
'  (OverwriteWithNullchars = 1& Or OverwriteWithNullchars = 3& Or _
'  OverwriteWithNullchars = 4& And NewPos > StartPos) Then
'  xLong5 = xLong5 + xLong1
'  End If
If Not NewPos = StartPos And FileMode = OutFileMode And _
  (OverwriteWithNullchars = 2& Or OverwriteWithNullchars = 3&) Then
  xLong5 = xLong5 + xLong1
  End If

#If BinaryMoveFileData_ProgressCallBackEx Then
  xMustDelAfterCopying = _
    (Not NewPos = StartPos And FileMode = OutFileMode And _
    (OverwriteWithNullchars = 2& Or OverwriteWithNullchars = 3&))
  xMoreJobs = (Not Size = 0& Or xMustDelAfterCopying)
  #End If




If (Not NewPos = StartPos And FileMode = OutFileMode) Or _
  Not FileMode = OutFileMode And _
  (OverwriteWithNullchars = 1& Or OverwriteWithNullchars = 3& Or _
  OverwriteWithNullchars = 4& And NewPos > StartPos) Then
  
  If FileMode = OutFileMode And NewPos > StartPos Then
    xLong1 = NewPos - StartPos
    If xLong1 > Size Then xLong1 = Size
    xLong2 = NewPos + Size - xLong1 + 2&
    Else
    xLong2 = NewPos + 1&
'    xLong1 = Size
    End If
  GoSub NullWrite
  End If



DoEvents
#If BinaryMoveFileData_CanAbortCopying Then
  If BinaryMoveFileData_AbortCopying Then GoTo Rs1
  #End If

#If BinaryMoveFileData_ProgressCallBackEx Then
  xMoreJobs = False
  #End If


If NewPos > StartPos And FileMode = OutFileMode Then ' And Not FileMode = OutFileMode Then
  xLong2 = Size
  Do
    If xLong2 = 0& Then Exit Do
    xLong1 = xLong2
    If xLong1 > BlockSize Then xLong1 = BlockSize
    xChar1 = String(xLong1, vbNullChar)
    xLong2 = xLong2 - xLong1
    Get FileMode, (StartPos + xLong2 + 1&), xChar1
    Put OutFileMode, (NewPos + xLong2 + 1&), xChar1
    'xLong2 = xLong2 - xLong1
    xLong4 = xLong4 + xLong1
    
    #If BinaryMoveFileData_ProgressCTA Or BinaryMoveFileData_ProgressCallBack Or BinaryMoveFileData_ProgressCallBackEx Then

      #If BinaryMoveFileData_ProgressExtraLarge Then
        If Not ProgressTotal = 0# Then
        #Else
        If Not ProgressTotal = 0& Then
        #End If

        #If BinaryMoveFileData_ProgressCTA Then
          ProgressControl.ValueSet (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal
          #Else
          #If BinaryMoveFileData_ProgressCallBackEx Then
            If xLong2 = 0& Then
              BinaryMoveFileData_CallBack (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal, 3&, xMustDelAfterCopying, xLong1
              Else
              BinaryMoveFileData_CallBack (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal, 2&, True, xLong1
              End If
            #Else
            BinaryMoveFileData_CallBack (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal
            #End If
          #End If
        End If
      #End If
    DoEvents
    #If BinaryMoveFileData_CanAbortCopying Then
      If BinaryMoveFileData_AbortCopying Then GoTo Rs1
      #End If
    Loop
  xLong2 = StartPos + 1& '''' 2&
  xLong1 = Size
'  If xLong1 > Size Then xLong1 = Size
  ElseIf NewPos < StartPos Or Not FileMode = OutFileMode Then
  xLong2 = 0&
  Do
    If xLong2 = Size Then Exit Do
    xLong1 = Size - xLong2
    If xLong1 > BlockSize Then xLong1 = BlockSize
    xChar1 = String(xLong1, vbNullChar)
    Get FileMode, (StartPos + xLong2 + 1&), xChar1
    
    
    Put OutFileMode, (NewPos + xLong2 + 1&), xChar1
    xLong2 = xLong2 + xLong1
    xLong4 = xLong4 + xLong1
    #If BinaryMoveFileData_ProgressCTA Or BinaryMoveFileData_ProgressCallBack Or BinaryMoveFileData_ProgressCallBackEx Then

      #If BinaryMoveFileData_ProgressExtraLarge Then
        If Not ProgressTotal = 0# Then
        #Else
        If Not ProgressTotal = 0& Then
        #End If

        #If BinaryMoveFileData_ProgressCTA Then
          ProgressControl.ValueSet (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal
          #Else
          #If BinaryMoveFileData_ProgressCallBackEx Then
            If xLong2 = Size Then
              BinaryMoveFileData_CallBack (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal, 3&, xMustDelAfterCopying, xLong1
              Else
              BinaryMoveFileData_CallBack (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal, 2&, True, xLong1
              End If
            #Else
            BinaryMoveFileData_CallBack (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal
            #End If
          #End If
        End If
      #End If
    DoEvents
    #If BinaryMoveFileData_CanAbortCopying Then
      If BinaryMoveFileData_AbortCopying Then GoTo Rs1
      #End If
    Loop
  xLong1 = StartPos - NewPos
  If xLong1 > Size Then xLong1 = Size
  xLong2 = StartPos + Size - xLong1 + 1& '2&
  End If

#If BinaryMoveFileData_ProgressCallBackEx Then
  If xMustDelAfterCopying Then
    CallBackModeAdding = 4&
  #Else
  If Not NewPos = StartPos And FileMode = OutFileMode And _
    (OverwriteWithNullchars = 2& Or OverwriteWithNullchars = 3&) Then
    #End If
  OutFileMode = FileMode
  GoSub NullWrite
  End If
xChar1 = ""
BinaryMoveFileData = True

Rs1:
On Error GoTo 0
Exit Function

Er1:
Resume Rs1

NullWrite:
'If xLong1 > Size Then xLong1 = Size

If FileMode = OutFileMode Then
  If NewPos > StartPos Then
    xLong1 = NewPos - StartPos
    Else
    xLong1 = StartPos - NewPos
    End If
  Else
  xLong1 = Size
  End If
If xLong1 > Size Then xLong1 = Size
DoEvents
#If BinaryMoveFileData_CanAbortCopying Then
  If BinaryMoveFileData_AbortCopying Then Resume Rs1
  #End If
Do
  If xLong1 = 0 Then Exit Do
  xLong3 = xLong1
  If xLong3 > BlockSize Then xLong3 = BlockSize
  xChar1 = String(xLong3, vbNullChar)
  Put OutFileMode, xLong2, xChar1
  xLong1 = xLong1 - xLong3
  xLong2 = xLong2 + xLong3
  xLong4 = xLong4 + xLong3
    #If BinaryMoveFileData_ProgressCTA Or BinaryMoveFileData_ProgressCallBack Or BinaryMoveFileData_ProgressCallBackEx Then

      #If BinaryMoveFileData_ProgressExtraLarge Then
        If Not ProgressTotal = 0# Then
        #Else
        If Not ProgressTotal = 0& Then
        #End If

        #If BinaryMoveFileData_ProgressCTA Then
          ProgressControl.ValueSet (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal
          #Else
          #If BinaryMoveFileData_ProgressCallBackEx Then
            If xLong1 = 0& Then
              BinaryMoveFileData_CallBack (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal, CallBackModeAdding + 1&, xMoreJobs, xLong3
              Else
              BinaryMoveFileData_CallBack (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal, CallBackModeAdding, True, xLong3
              End If
            #Else
            BinaryMoveFileData_CallBack (ProgressStart + xLong4 / xLong5 * Size) / ProgressTotal
            #End If
          #End If
        End If
      #End If
  DoEvents
  #If BinaryMoveFileData_CanAbortCopying Then
    If BinaryMoveFileData_AbortCopying Then Resume Rs1
    #End If
  Loop
Return
End Function

