Attribute VB_Name = "MODUL_GetWinPaths"
' Modul for Visual Basic 6
' Copyright (C) 2003 Jan Vorel
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues




Option Explicit
Option Base 0

Private Declare Function GetTempPathA Lib "kernel32" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Private Declare Function GetWindowsDirectoryA Lib "kernel32" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Private Declare Function GetSystemDirectoryA Lib "kernel32" (ByVal lpBuffer As String, ByVal nSize As Long) As Long

Public Enum enumWinPaths
  ewWindows = 0
  ewSystem = 1
  ewTemp = 2
  End Enum

Private Const xMaxPathLen = 256

Public Function GetWinPath(ByVal xLong1 As enumWinPaths, Optional ByVal EndWithSeperator As Boolean = True) As String

GetWinPath = String(xMaxPathLen, Chr(0))
    
Select Case xLong1
  Case 0&
    Call GetWindowsDirectoryA(GetWinPath, xMaxPathLen)
  Case 1&
    Call GetSystemDirectoryA(GetWinPath, xMaxPathLen)
  'Case 2 = temppath
  Case Else
    Call GetTempPathA(xMaxPathLen, GetWinPath)
  End Select

xLong1 = InStr(GetWinPath, Chr(0)) - 1
If xLong1 = -1 Then
  GetTempPathA xMaxPathLen, GetWinPath
  xLong1 = InStr(GetWinPath, Chr(0) - 1)
  If xLong1 = -1 Then
    GetWinPath = ""
    Error 1
    Exit Function
    End If
  End If

GetWinPath = Left(GetWinPath, xLong1)
If Right(GetWinPath, 1) = "\" Then
  If Not EndWithSeperator Then
    GetWinPath = Left(GetWinPath, Len(GetWinPath) - 1)
    End If
  Else
  If EndWithSeperator Then
    GetWinPath = GetWinPath + "\"
    End If
  End If
End Function
    
    
    
    





