; Copyright (C) 2001-2005 Jan Vorel

; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.

; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

; This is a shared modul, class modul, usercontrol or form. It is also
; published under the GNU General Public License.

; If you have any questions, suggestions or bug reports about this product,
; contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
; language or A.P.I. issues

#Compiler_Mode = 2
#Compiler_DebugMe = 0

; 0 = default
; 1 = debug
; 2 = ctuninst


; PRGNAME=Reg2exe 2.24
; VERSION=2,24,0,0
; COMMENTS=Compressed with UPX (http://upx.sourceforge.net)
; COMPANY=ctuser
; DESCRIP=Reg2exe 'converter'
; LEGALCOPYRIGHT=2001-2005 by Jan Vorel
; E-MAIL=info@ctuser.net
; WEB=http://www.ctuser.net

Declare.s AppBase()
Declare.s GetCharEx(xChar1$, xLong1.l)
Declare.s InstrRev(xChar1$)
xLong1.l





;CompilerIf #Compiler_DebugMe = 1
;  WriteStringX("Init GetTempDir")
;  CompilerEndIf
xChar1$ = Space(256)
xLong1 = GetTempPath_(256, xChar1$)
AppPathTemp$ = GetCharEx(xChar1$, xLong1)

;Debug ProgramParameter() 



Declare RegDeleteValuesEx(OpenKey.l)
Declare.l RegDeleteKeysRecursive(StartKey.l, SubKey.s, NoDeleteMain.l)
Declare.l InstrA(StartPos.l)
Declare.l ReplaceBinary (NewString$, BinaryStart.l, BinaryEnd.l, OrigString.s)
Declare.s GetProgramsPath()
Declare.s RegReadString(uRGSection.s, uRGName.s)
Declare GetXPAccess()
CompilerIf #Compiler_Mode = 2
  Declare.l ReadLongX()
  Declare.s ReadStringX()
  Declare.s DeleteFileX(DefDir.s, Filename.s)
  Declare.s MidX(BaseString.s, Position.l)
  Declare RunProgramX(FileName.s, RMode.l)
  CompilerEndIf

CompilerIf #Compiler_DebugMe = 1
  Declare WriteStringX(xChar1.s)
  #DebugFileID = 1
  #RegFileID = 2
  xChar1$ = AppBase()
  xChar1$ = Left(xChar1$, Len(xChar1$) - 3) + "log"
  CreateFile(#DebugFileID, xChar1$)
;  Debug(xChar1$)
  UseFile(#DebugFileID)
  WriteStringX("Started")
  Global FileOpened.l
  CompilerEndIf

Dim xByteA1.b(1048575)
xLong2.l
xLong3.l
xLong4.l
xLong5.l
xKeyLong2.l



CompilerIf #Compiler_DebugMe = 1
  WriteStringX("Declared, init GetWindowsDir")
  CompilerEndIf
xChar1$ = Space(256)
xLong1 = GetWindowsDirectory_(xChar1$, 256)
AppPathWin$ = GetCharEx(xChar1$, xLong1)



CompilerIf #Compiler_DebugMe = 1
  WriteStringX("Init GetSystemDir")
  CompilerEndIf
xChar1$ = Space(256)
xLong1 = GetSystemDirectory_(xChar1$, 256)
AppPathSys$ = GetCharEx(xChar1$, xLong1)






CompilerIf #Compiler_DebugMe = 1
  WriteStringX("Init GetProgDir")
  CompilerEndIf
xAppPathProgs$ = GetProgramsPath()




CompilerIf #Compiler_DebugMe = 1
;  xChar1$ = ProgramParameter()
;  xChar1$ = "C:\Q03311\Programs\ctuser\QuickPlayer\ctuninst.tmp"
;  xChar1$ = "C:\Q03311\temp\ctuninst.tmp"
  xChar1$ = "C:\Q03311\temp\ctuninst2.tmp"
  WriteStringX("Attempting file: " + xChar1$)
  CompilerElse
  xChar1$ = AppBase()
  CompilerEndIf

;  xChar1$ = "C:\Q03311\Programs\ctuser\QuickPlayer\ctuninst.tmp"
;AppPath$ = InstrRev(xChar1$)
;WriteStringX("ReadFile: " + xChar1$)



GetXPAccess()






CompilerIf #Compiler_Mode = 2
;  xLong1 = ReadFile(#PB_Any, xChar1$)

  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("ReadFile: " + xChar1$)
    xLong1 = ReadFile(#RegFileID, xChar1$)
    If xLong1
      FileOpened = 1
      EndIf
    WriteStringX("ReadFile: " + Trim(Str(xLong1)))
    CompilerElse
    xLong1 = ReadFile(#PB_Any, xChar1$)
    CompilerEndIf

  FileSeek (Lof() - 3)
  xChar1$ = Space(3)
  xLong1 = ReadData(xChar1$, 3)
;Debug ("1" + xChar1$)
  If xChar1$ = "ctU"
    FileSeek(Lof() - 15)
    xChar1$ = Space(8)
    xLong1 = ReadData(xChar1$, 8)
;Debug(xChar1$)
;Debug ("2")
    If xChar1$ = "ctUninst"
;Debug ("2.1" + Str(xLong1))
      xLong1 = ReadLongX()
;Debug ("2.2" + Str(xLong1))
      FileSeek(xLong1)
      xLong2 = xLong1 + 16 ; 8 + 8 (4+4)
      xChar1$ = Space(8)
      xLong1 = ReadData(xChar1$, 8)
;Debug ("3 "+ xChar1$)
      If xChar1$ = "ctUninst"
        xLong1 = ReadLongX()
        If xLong1 = 1
;Debug ("4")
          xLong1 = ReadLongX()
          ;xLong5 = ReadLongX()
          xChar1$ = ReadStringX()
          xChar2$ = ReadStringX()
          AppPath$ = ReadStringX()

;          Debug "0.1 " + xChar3$
          AppPath$ = LCase(AppPath$)
;          Debug "0.2 " + xChar3$
          xLong2 = xLong2 + xLong1

          If LCase(AppBase()) = LCase(AppPathTemp$) + "\ctuninst.tmp"
            Sleep_(5000)
            Else
            If MessageRequester("Warning", xChar2$ + Chr(13) + "(Please ensure the programm is not running before continuing)", #PB_MessageRequester_YesNo) = 6
              xChar1$ = "Software\Microsoft\Windows\CurrentVersion\Uninstall\" + xChar1$
              RegDeleteKey_(-2147483646, @xChar1$)
              ;CopyFile(AppBase(), AppPathTemp$ + "\ctuninst.exe")
              CopyFile(AppBase(), AppPathTemp$ + "\ctuninst.tmp")
              OnErrorResume()
              ;RunProgram(AppPathTemp$ + "\ctuninst.exe", "DoIt", AppPathTemp$)
              xType1.StartupInfo
              xType2.Process_Information
              xType1\cb = 68
              CreateProcess_(AppPathTemp$ + "\ctuninst.tmp", 0, 0, 0, 0, 0, 0, AppPathTemp$, @xType1, @xType2)
              OnErrorGoto(0)
              EndIf
            End
            EndIf

          While Loc() < xLong2
            xChar1$ = ReadStringX()
            Select Asc(xChar1$)
              Case 1
                xChar1$ = MidX(xChar1$, 2)
                RemoveDirectory_(@xChar1$)
              Case 2 
                RunProgramX(xChar1$, 0)
              Case 3 ;hidden
                RunProgramX(xChar1$, 2)
              Case 4 ;wait
                RunProgramX(xChar1$, 1)
              Case 5 ;wait hidden
                RunProgramX(xChar1$, 3)
              Default
                DeleteFileX(AppPath$, xChar1$)
              EndSelect
            Wend
          FileSeek (xLong2)




  CompilerElse


  CompilerIf #Compiler_DebugMe = 1
    xLong1 = ReadFile(#RegFileID, xChar1$)
    If xLong1 <> 0
      FileOpened = 1
      EndIf
    WriteStringX("ReadFile: " + Trim(Str(xLong1)))
    CompilerElse
    xLong1 = ReadFile(#PB_Any, xChar1$)
    CompilerEndIf
  If xLong1 <> 0
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("Seeking...")
        WriteStringX("Returns: " + Trim(Str(FileSeek (Lof() - 5))))
      CompilerElse
      FileSeek (Lof() - 5)
      CompilerEndIf
    xChar1$ = Space(3)
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("ReadData...")
      CompilerEndIf
    xLong1 = ReadData(xChar1$, 3)
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("Comparing")
      CompilerEndIf
    If Left(xChar1$, 3) = "R22"
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("Useable")
        CompilerEndIf
        
    
      xLong1 = ReadByte()
      xLong2 = ReadByte()
      xLong1 = xLong1 * 256 + xLong2
      FileSeek (xLong1)
      If ReadData(xChar1$, 3) = 3
        If Left(xChar1$, 3) = "R22"
  CompilerEndIf







CompilerIf #Compiler_DebugMe = 1
  WriteStringX(Str(Loc()) + " - " + Str(Lof()))
  CompilerEndIf

CompilerIf #Compiler_Mode = 2
While Loc() < Lof() - 17
CompilerElse
While Loc() < Lof() - 7
CompilerEndIf
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("<< Loop >>")
    CompilerEndIf
  xLong2 = ReadByte()
  xLong1 = ReadByte()
  xLong3 = ReadByte()
  xLong3 = xLong1 * 256 + xLong3
  xLong1 = (xLong2 & 240) / 16 ;Int (xLong2 / 16)
  If xLong1 > 7 
    If xKeyLong2 <> 0
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("Closing key")
        CompilerEndIf
      RegCloseKey_(xKeyLong2)
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("  done")
        CompilerEndIf
      xKeyLong2 = 0
      EndIf
    xLong2 = -2147483648 + (xLong2 & 15)
    Else
    xLong3 = (xLong2 & 15) * 65536 + xLong3
    If xLong1 = 2 
      xLong3 = xLong3 + 2
      EndIf
    EndIf
  If xLong1 < 8 
    For xLong4 = 0 To xLong3 - 1
      xByteA1(xLong4) = ReadByte()
      Next

    xChar1$ = ""
    If xLong1 = 2 
      xLong4 = InstrA(2)
      For xLong5 = 2 To xLong4 - 1
        xChar1$ = xChar1$ + Chr(xByteA1(xLong5))
        Next
      Else
      xLong4 = InstrA(0)
      For xLong5 = 0 To xLong4 - 1
        xChar1$ = xChar1$ + Chr(xByteA1(xLong5))
        Next
      EndIf
    Else
    xChar1$ = Space(xLong3)
    If ReadData(xChar1$, xLong3) <> xLong3 
      Goto Er2
      EndIf
    EndIf

;          ' 0 delvalue
;          ' 1 string
;          ' 2 hex(x)
;          ' 3 hex
;          ' 4 dword
;          ' 8 makedir       'xxxxxxxxxxx
;          ' 9 opendir       'xxxxxxxxxxx (does not create if not exists!!!)
;          '10 deldir        'xxxxxxxxxxx
;          '11 delsubdirs    'deletes all subkeys. key left open for writting values
;          '12 delmainvalues 'deletes all values in the directory itself. key left open for writting values


  If xLong1 = 0
    If xKeyLong2 <> 0 
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("RegDeleteKey: " + xChar1$)
        DebugResult = RegDeleteValue_(xKeyLong2, @xChar1$)
        If DebugResult = 0
          WriteStringX("  ok?")
          Else
          WriteStringX("  failed (" + Trim(Str(DebugResult)) + ")?")
          EndIf
        CompilerElse
        RegDeleteValue_(xKeyLong2, @xChar1$)
        CompilerEndIf
      EndIf
    ElseIf xLong1 < 5
    If xKeyLong2 <> 0
      If xLong1 = 2 
        xLong1 = xByteA1(0) * 256 + xByteA1(1)
        EndIf
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("ReplaceBinary stuff")
        CompilerEndIf
      xLong3 = Replacebinary(AppPath$, xLong4 + 1, xLong3, "reg2exepath")
      xLong3 = Replacebinary(AppPathWin$, xLong4 + 1, xLong3, "reg2exewinpath")
      xLong3 = Replacebinary(AppPathSys$, xLong4 + 1, xLong3, "reg2exesyspath")
      xLong3 = Replacebinary(AppPathTemp$, xLong4 + 1, xLong3, "reg2exetemppath")
      xLong3 = Replacebinary(AppPathProgs$, xLong4 + 1, xLong3, "reg2exeprogspath")
      xByteA1(xlong3) = 0

      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("RegSetValueEx: " + xChar1$)
        DebugResult = RegSetValueEx_(xKeyLong2, @xChar1$, 0, xLong1, @xByteA1(xLong4 + 1), xLong3 - 1 - xLong4)
        If DebugResult = 0
          WriteStringX("  ok?")
          Else
          WriteStringX("  failed (" + Trim(Str(DebugResult)) + ")?")
          EndIf
        CompilerElse
        RegSetValueEx_(xKeyLong2, @xChar1$, 0, xLong1, @xByteA1(xLong4 + 1), xLong3 - 1 - xLong4)
        CompilerEndIf
      EndIf
    ElseIf xLong1 = 8
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("RegCreateKeyEx: " + xChar1$)
      DebugResult = RegCreateKeyEx_(xLong2, @xChar1$, 0, 0, 0, 983103, 0, @xKeyLong2, @xLong5)
      If DebugResult = 0
        WriteStringX("  ok?")
        Else
        WriteStringX("  failed (" + Trim(Str(DebugResult)) + ")?")
        xKeyLong2 = 0
        EndIf
      CompilerElse
      If RegCreateKeyEx_(xLong2, @xChar1$, 0, 0, 0, 983103, 0, @xKeyLong2, @xLong5) <> 0 
        xKeyLong2 = 0
        EndIf
      CompilerEndIf
    ElseIf xLong1 = 9 Or xLong1 = 12
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("RegOpenKeyEx: " + xChar1$)
      DebugResult = RegOpenKeyEx_(xLong2, @xChar1$, 0, 983103, @xKeyLong2)
      If DebugResult = 0
        WriteStringX("  ok?")
        If xLong1 = 12
          WriteStringX("RegDeleteValuesEx_Sub")
          RegDeleteValuesEx(xKeyLong2)
          WriteStringX("  done")
          EndIf
        Else
        WriteStringX("  failed (" + Trim(Str(DebugResult)) + ")?")
        xKeyLong2 = 0
        EndIf
      CompilerElse
      If RegOpenKeyEx_(xLong2, @xChar1$, 0, 983103, @xKeyLong2) <> 0
        xKeyLong2 = 0
        ElseIf xLong1 = 12
        RegDeleteValuesEx(xKeyLong2)
        EndIf
      CompilerEndIf
    ElseIf xLong1 = 10
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("RegDeleteKeysRecursive: " + xChar1$)
      RegDeleteKeysRecursive(xLong2, xChar1$, 0)
      WriteStringX("  done")
      CompilerElse
      RegDeleteKeysRecursive(xLong2, xChar1$, 0)
      CompilerEndIf
    ElseIf xLong1 = 11
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("RegDeleteKeysRecursive: " + xChar1$)
      xKeyLong2 = RegDeleteKeysRecursive(xLong2, xChar1$, 1)
      WriteStringX("  done")
      CompilerElse
      xKeyLong2 = RegDeleteKeysRecursive(xLong2, xChar1$, 1)
      CompilerEndIf
    Else
    Goto Er2
    EndIf
  Wend








CompilerIf #Compiler_Mode = 2
          EndIf
        EndIf
      EndIf   
    EndIf

Rs2:
  If xKeyLong2 <> 0
    RegCloseKey_(xKeyLong2)
    EndIf
  End

Er2:
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("Error occured")
    CompilerEndIf
  Goto Rs2






  CompilerElse
; If xLong1 <> 0
;   If Left(xChar1$, 3) = "R22"
;     If ReadData(xChar1$, 3) = 3
;       If Left(xChar1$, 3) = "R22"
          Else
          Goto Er2
          EndIf
        Else
        Goto Er2
        EndIf
      Else
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("Unusable: " + Trim(Str(Asc(Left(xChar1$, 1)))) + "," + Trim(Str(Asc(Mid(xChar1$, 2, 1))))+ "," + Trim(Str(Asc(Mid(xChar1$, 3, 1)))))
        CompilerEndIf
      Goto Er2
      EndIf
    Else
    Goto Er2
    EndIf


Rs1:
  If xKeyLong2 <> 0
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("Closing key (Final)")
      CompilerEndIf
    RegCloseKey_(xKeyLong2)
    EndIf
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("Done")
    CompilerEndIf
  End

Er2:
  MessageRequester("Reg2exe 2.24","File damaged", #PB_MessageRequester_Ok)
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("######### Error File Damaged")
    CompilerEndIf
  Goto Rs1
  CompilerEndIf
















Procedure RegDeleteValuesEx(OpenKey.l)
  xChar1.s
  xLong1.l
  xLong2.l
  xLong3.l

  RegDeleteValue_(OpenKey, @xChar1) ; Manually delete default value + updates regestry
  Repeat
    xChar1 = Space(512)
    xLong2= 512
;    Select RegEnumValue_(OpenKey, xLong1, @xChar1, @xLong2, 0, 0, 0, 0)
    xLong3 = RegEnumValue_(OpenKey, xLong1, @xChar1, @xLong2, 0, 0, 0, 0)
;Debug xLong3
;Debug xChar1
    Select xLong3
      Case 259
        RegDeleteValue_(OpenKey, @xChar1)
        xChar1 = ""
        RegDeleteValue_(OpenKey, @xChar1)  ; Manually delete default value after updating regestry
        Break
      Case 0
        RegDeleteValue_(OpenKey, @xChar1)
        xLong1 = xLong1 + 1
      Default
        Break
      EndSelect
    ForEver
  EndProcedure


Procedure.l RegDeleteKeysRecursive(StartKey.l, SubKey.s, NoDeleteMain.l)
  xChar1.s
  xLong1.l
  xLong2.l
  xLong3.l
  If SubKey <> ""
    If RegOpenKeyEx_(StartKey, SubKey, 0, 983103, @xLong1) = 0
      Repeat
        xChar1 = Space(512)
        xLong3 = 512
        Select RegEnumKeyEx_(xLong1, xLong2, @xChar1, @xLong3, 0, 0, 0, 0)
;          Case 259
;  Debug "RegDelKey: " + SubKey
;            Break
          Case 0
            If SubKey
              xChar1 = SubKey + "\" + xChar1
              EndIf
            CompilerIf #Compiler_DebugMe = 1
              WriteStringX("  SubKey: " + xChar1)
              CompilerEndIf
            RegDeleteKeysRecursive(StartKey, xChar1, 0)
            xLong2 = xLong2 + 1
          Default
            Break
          EndSelect
        ForEver
      If NoDeleteMain = 0
        ;RegDeleteKey_(StartKey, SubKey)
        RegCloseKey_(xLong1) ;Key)
        CompilerIf #Compiler_DebugMe = 1
          WriteStringX("  DeleteKey: " + SubKey)
          WriteStringX("    Returns: " + Trim(Str(RegDeleteKey_(StartKey, @SubKey))))
          CompilerElse
          RegDeleteKey_(StartKey, @SubKey)
          CompilerEndIf
        Else
        ProcedureReturn xLong1 ; Key
        EndIf
      EndIf
    EndIf
  EndProcedure

Procedure.s AppBase()
  xLong1.l
  Result.s

  xLong1 = GetCommandLine_()
  If xLong1 <> 0
    Result = PeekS(xLong1, 65535)
    If Left(Result, 1) = Chr(34) 
      xLong1 = Len(Result) - 2
      If xLong1 = -1
        Result = Mid(Result, 2, xLong1 + 1)
        Else
        Result = Mid(Result, 2, xLong1)
        EndIf
      xLong1 = FindString(Result, Chr(34), 1)
      Else
      xLong1 = FindString(Result, " ", 1)
      EndIf
    If xLong1 <> 0 
      Result = Left(Result, xLong1 - 1)
      EndIf

    CompilerIf #Compiler_Mode = 2
;     Result = "C:\Q03311\Programs\ctuser\QuickPlayer\ctuninst.exe"
      CompilerEndIf

;    Result = "d:\vb6\reg2exe\test224\test3.exe"
;    Result = "C:\Dokumente und Einstellungen\Christian\Eigene Dateien\PBasic\Test99.exe"
    ProcedureReturn = Result
    EndIf
  EndProcedure

Procedure.l InstrA(StartPos.l)
  xLong1.l

  For xLong1 = StartPos To 1048575
    If xByteA1(xLong1) = 0
      ProcedureReturn = xLong1
      EndIf
    Next
  EndProcedure

Procedure.s InstrRev(xChar1$)
  xLong1.l
  xLong2.l

  While 1
    xLong1 = FindString(xChar1$, "\", xLong2 + 1)
    If xLong1 = 0 
      Break
      Else
      xLong2 = xLong1
      EndIf
    Wend
  If xLong2 <> 0
    ProcedureReturn = Left(xChar1$, xLong2 - 1)
    EndIf
  EndProcedure

Procedure.l ReplaceBinary (NewString$, BinaryStart.l, BinaryEnd.l, OrigString.s)
  xLong1.l
  xLong2.l
  xLong3.l
  xLong4.l
  xLong5.l = Len(OrigString)

  For xLong1 = BinaryEnd - xLong5 - 1 To BinaryStart Step -1
    If xByteA1(xLong1) = 60 And xByteA1(xLong1 + xLong5 + 1) = 62 
      xChar1$ = ""
      For xLong2 = xLong1 + 1 To xLong1 + xLong5
        xChar1$ = xChar1$ + Chr(xByteA1(xLong2))
        Next
;      If LCase(xChar1$)="reg2exepath"
      If LCase(xChar1$) = OrigString
        xLong2 = Len(NewString$) 
        If xLong2 <> xLong5 + 2 
          If xLong2 < xLong5 + 2
;            Debug ("Longer" + OrigString)
            xLong3 = xLong5 + 2 - xLong2
            BinaryEnd = BinaryEnd - xLong3
            For xLong4 = xLong1 + xLong2 To BinaryEnd
              xByteA1(xLong4) = xByteA1(xLong4 + xLong3)
              Next
;            BinaryEnd = BinaryEnd - xLong3
            Else
;            Debug ("Shorter: " + OrigString)
            xLong3 = xLong2 - (xLong5 + 2)
            BinaryEnd = BinaryEnd + xLong3
            For xLong4 = BinaryEnd To xLong1 + xLong2 Step -1
              xByteA1(xLong4) = xByteA1(xLong4 - xLong3)
              Next
            EndIf
          EndIf
        For xLong3 = 0 To xLong2 - 1
          xByteA1(xLong1 + xLong3) = Asc(Mid(NewString$, xLong3 + 1, 1))
          Next
        EndIf
      EndIf
    Next
  ProcedureReturn = BinaryEnd
  EndProcedure

;Procedure.s GetApiChar(Pointer.l)
;  If Pointer
;    ProcedureReturn PeekS(xLong1, 65535)
;    EndIf
;  EndProcedure

Procedure.s GetProgramsPath()
  xChar1.s

  xChar1 = RegReadString("Software\Microsoft\Windows\CurrentVersion", "ProgramFilesDir")
  If xChar1 = ""
    xChar1 = RegReadString("Software\Microsoft\Windows\CurrentVersion", "ProgramFilesPath")
    If xChar1 = ""
      xChar1 = RegReadString("HKEY_LOCAL_MACHINE\Software\Microsoft\Windows\CurrentVersion\SETUP\VarLDID", "28700")
      EndIf
    EndIf

  If xChar1 = ""
    xChar1 = "C:\Program Files"
    Else
    If Right(xChar1, 1) = "\"
      xChar1 = Left(xChar1, Len(xChar1) - 1)
      EndIf
    EndIf

  ProcedureReturn xChar1
  EndProcedure


Procedure.s RegReadString(uRGSection.s, uRGName.s)
  xLong1.l
  xLong2.l
  xLong3.l
  xLong4.l
  xChar1.s

;&H80000002
  If RegOpenKeyEx_(-2147483646, uRGSection, 0, 983103, @xLong1) = 0
;    Debug "Opened"
    xLong2 = 1024
    xChar1 = Space(xLong2)

;    xLong4 = RegQueryValueEx_(xLong1, uRGName, 0, xLong3, @xChar1, @xLong2)
;    If xLong4 = 0 And xLong2 > 0

    If RegQueryValueEx_(xLong1, uRGName, 0, xLong3, @xChar1, @xLong2) = 0
      If xLong2 > 0
        ProcedureReturn = Left(xChar1, xLong2 - 1)
        EndIf
      EndIf
    RegCloseKey_(xLong1)
    EndIf
  EndProcedure

Procedure.s GetCharEx(xChar1$, xLong1.l)
  If xLong1
    If Right(xChar1$, 1) = "\"
      xChar1$ = Left(xChar1$, Len(xChar1$) - 1)
      EndIf
    ProcedureReturn xChar1$
    EndIf
  EndProcedure
; ExecutableFormat=Windows
; EnableXP
; UseIcon=E:\VB6\Reg2Exe\Backup48.ico
; Executable=E:\VB6\Reg2Exe\Reg2exe.exe
; EOF

CompilerIf #Compiler_DebugMe = 1
  Procedure WriteStringX(xChar1.s)
    UseFile(#DebugFileID)
    WriteStringN(xChar1)
    Debug(xChar1)
    If FileOpened
      UseFile(#RegFileID)
      EndIf
    EndProcedure
  CompilerEndIf

Procedure GetXPAccess()
;  '"SE_TAKE_OWNERSHIP_NAME"
  CompilerIf #Compiler_DebugMe = 1
    WriteStringX("Aquirering Privileges")
    CompilerEndIf


  xLong1.l
  xLong2.l
  xType1.OSVERSIONINFO
  xType2.TOKEN_PRIVILEGES
  xType3.TOKEN_PRIVILEGES
  
  xType1\dwOSVersionInfoSize = SizeOf(xType1)
  If GetVersionEx_(xType1) <> 0
    CompilerIf #Compiler_DebugMe = 1
      WriteStringX("  GetVersionEx ok, PlattformId = " + Trim(Str(xType1\dwPlatformId)))
      CompilerEndIf
    If xType1\dwPlatformId = 2
      CompilerIf #Compiler_DebugMe = 1
        WriteStringX("  OpenToken")
        CompilerEndIf
      If OpenProcessToken_(GetCurrentProcess_(), 40, @xLong2)
        xLong1 = LookupPrivilegeValue_(#NULL, @"SeTakeOwnershipPrivilege", xType2\Privileges[0]\Luid)
        xType2\PrivilegeCount = 1
        xType2\Privileges[0]\Attributes = 2
        CompilerIf #Compiler_DebugMe = 1
          xLong999.l = AdjustTokenPrivileges_(xLong2, 0, xType2, SizeOf(xType3), xType3, xLong1)
          If xLong999 = 0
            WriteStringX("  ok")
            Else
            WriteStringX("  failed (" + Trim(Str(xLong999)) + ")")
            EndIf
          CompilerElse
          AdjustTokenPrivileges_(xLong2, 0, xType2, SizeOf(xType3), xType3, xLong1)
          CompilerEndIf
        EndIf
      EndIf
    EndIf
  EndProcedure

CompilerIf #Compiler_Mode = 2
  Procedure.l ReadLongX()
    xLong1.l = ((256 + ReadByte()) & 255)
;Debug ("0.1" + Str(xLong1))
    xLong2.l = ((256 + ReadByte()) & 255)
;Debug ("0.2" + Str(xLong2))
    xLong3.l = ((256 + ReadByte()) & 255)
;Debug ("0.3" + Str(xLong3))
    xLong4.l = ((256 + ReadByte()) & 255)
;Debug ("0.4" + Str(xLong4))
    xLong1 = ((xLong1 * 256 + xLong2) * 256 + xLong3) * 256 + xLong4
;Debug ("0.5" + Str(xLong1))
    ProcedureReturn xLong1
    EndProcedure

  Procedure.s ReadStringX()
    xLong1.l
    Repeat
      xLong1 = ((256 + ReadByte()) & 255)
      If xLong1 = 0
        Break
        Else
        xChar1$ = xChar1$ + Chr(xLong1)
        EndIf
      ForEver
    ProcedureReturn xChar1$
    EndProcedure

  Procedure.s DeleteFileX(DefDir.s, Filename.s)
    xBool1.l
    If LCase(Right(Filename, 4)) = ".lnk"
      xBool1 = 1
      Else
      If LCase(Left(Filename, Len(DefDir) + 1)) = LCase(DefDir) + "\"
        xBool1 = 1
        Else
;        Debug "0. " + FileName
;        Debug ("1. " + LCase(MidX(Filename, Len(DefDir) + 1)))
;        Debug ("2. " + LCase(DefDir) + "\")
        If MessageRequester("Warning", "Do you want to permit deletion of this file:" + Chr(13) + Filename, #PB_MessageRequester_YesNo) = 6
          xBool1 = 1
          EndIf
        EndIf
      EndIf
    If xBool1
      If FindString(Filename, "?", 1) + FindString(Filename, "*", 1) Or 1
;        Debug ("DeleteDir.1: " + xChar1$)
        xChar1$ = InstrRev(Filename)
        Filename = MidX(Filename, Len(xChar1$) + 2)
;        Debug ("DeleteDir.1: " + xChar1$)
;        Debug ("DeleteDir.2: " + Filename)
        DeleteDirectory(xChar1$, Filename, #PB_FileSystem_Force)
        Else
        DeleteFile(Filename)
;        Debug ("DeleteFile: " + Filename)
        EndIf
      EndIf
    EndProcedure

  Procedure.s MidX(BaseString.s, Position.l)
    xLong1.l = Len(BaseString)
    If Position < xLong1
      BaseString = Mid(BaseString, Position, xLong1 - Position + 1)
      EndIf
    ProcedureReturn BaseString
    EndProcedure

  Procedure RunProgramX(FileName.s, RMode.l)
    Filename = MidX(Filename, 2)
    xLong1.l = FindString(Filename, ",", 1)
    xChar1$ = Left(Filename, xLong1 - 1)
    Filename = MidX(Filename, xLong1 + 1)
    xChar2$ = InstrRev(xChar1$)
    
    RunProgram(xChar1$, Filename, xChar2$, RMode)
    EndProcedure
  CompilerEndIf


; ExecutableFormat=Windows
; EnableXP
; UseIcon=D:\VB6\ctIMaker\uninst\ctUninst1_48.ico
; Executable=D:\VB6\Reg2Exe\ctUninst.exe
; EOF