Attribute VB_Name = "Module1"
Option Explicit
Option Base 0

' Modul for Visual Basic 6
' Copyright (C) 2001-2005 Jan Vorel
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues

Private Type LARGE_INTEGER
  lowpart As Long
  highpart As Long
  End Type

Private Type LUID_AND_ATTRIBUTES
  pLuid As LARGE_INTEGER
  Attributes As Long
  End Type

Private Type TOKEN_PRIVILEGES
  PrivilegeCount As Long
  Privileges(1) As LUID_AND_ATTRIBUTES
  End Type

Private Type OSVERSIONINFO
  dwOSVersionInfoSize As Long
  dwMajorVersion As Long
  dwMinorVersion As Long
  dwBuildNumber As Long
  dwPlatformId As Long
  szCSDVersion As String * 128
  End Type

Private Declare Function LookupPrivilegeValueA Lib "advapi32.dll" (ByVal lpSystemName As String, ByVal lpName As String, lpLuid As LARGE_INTEGER) As Long
Private Declare Function GetCurrentProcess Lib "kernel32" () As Long
Private Declare Function AdjustTokenPrivileges Lib "advapi32.dll" (ByVal TokenHandle As Long, ByVal DisableAllPrivileges As Long, NewState As TOKEN_PRIVILEGES, ByVal BufferLength As Long, PreviousState As TOKEN_PRIVILEGES, ReturnLength As Long) As Long
Private Declare Function OpenProcessToken Lib "advapi32.dll" (ByVal ProcessHandle As Long, ByVal DesiredAccess As Long, TokenHandle As Long) As Long
'Private Declare Function ExitWindowsEx Lib "user32" (ByVal uFlags As Long, ByVal dwReserved As Long) As Long
Private Declare Function GetVersionExA Lib "kernel32" (lpVersionInformation As OSVERSIONINFO) As Long












Private Declare Sub RtlMoveMemory Lib "kernel32" (lpvDest As Any, lpvSource As Any, ByVal cbCopy As Long)
'private Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal HKEY As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long
Private Declare Function RegEnumValueA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal dwIndex As Long, ByVal lpValueName As String, lpcbValueName As Long, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long
Private Declare Function RegEnumKeyA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal dwIndex As Long, ByVal lpName As String, ByVal cbName As Long) As Long
'private Declare Function RegOpenKeyA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal lpSubKey As String, phkResult As Long) As Long

Private Declare Function RegOpenKeyExA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
'Private Declare Function RegQueryValueExA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long
Private Declare Function RegCreateKeyExA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal lpSubKey As String, ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions As Long, ByVal samDesired As Long, lpSecurityAttributes As Any, phkResult As Long, lpdwDisposition As Long) As Long
Private Declare Function RegSetValueExA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpData As Any, ByVal cbData As Long) As Long
Private Declare Function RegDeleteKeyA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal lpSubKey As String) As Long
Private Declare Function RegDeleteValueA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal lpValueName As String) As Long
Private Declare Function RegCloseKey Lib "advapi32.dll" (ByVal HKEY As Long) As Long




Public Function ConvertRegistryA_ImportData(ByVal RegestryData As String, _
        ByVal WinPath As String, ByVal SysPath As String, _
        ByVal TempPath As String, ByVal ProgPath As String, _
        ByVal AppPath As String)
  
  Dim xByteA1_Size As Long
  Dim xByteA1_Pos As Long
  Dim xByteA1() As Byte
  Dim xChar1 As String
  Dim xChar2 As String
  Dim xLong1 As Long
  Dim xLong2 As Long
  Dim xLong3 As Long
  Dim xLong4 As Long
  Dim xLong5 As Long
  Dim xKeyLong2 As Long
  
  xByteA1_Size = Len(RegestryData)
  ReDim xByteA1(xByteA1_Size - 1&)
  Call RtlMoveMemory(xByteA1(0), ByVal RegestryData, xByteA1_Size)

  Call GetXPAccess

  Do While xByteA1_Pos < xByteA1_Size
    xLong2 = xByteA1(xByteA1_Pos)
    xLong1 = xByteA1(xByteA1_Pos + 1&)
    xLong3 = xLong1 * 256 + xByteA1(xByteA1_Pos + 2&)
    xLong1 = (xLong2 And 240&) / 16
    xByteA1_Pos = xByteA1_Pos + 3&
    
    If xLong1 > 7& Then
      If Not xKeyLong2 = 0& Then
        Call RegCloseKey(xKeyLong2)
        xKeyLong2 = 0&
        End If
      xLong2 = &H80000000 + (xLong2 And &HF&)
      Else
      xLong3 = (xLong2 And &HF&) * 65536 + xLong3
      If xLong1 = 2 Then
        xLong3 = xLong3 + 2&
        End If
      End If
    
    xChar2 = String(xLong3, vbNullChar)
    Call RtlMoveMemory(ByVal xChar2, xByteA1(xByteA1_Pos), xLong3)
    xByteA1_Pos = xByteA1_Pos + xLong3
    If xLong1 < 8& Then
      'xChar2 = String(xLong3, vbNullChar)
      'Call RtlMoveMemory(ByVal xChar2, xByteA1(xByteA1_Pos), xLong3)
      'xByteA1_Pos = xByteA1_Pos + xLong3

      'xChar1 = ""
      'Stop
      If xLong1 = 2& Then
        xLong4 = InStr(2&, xChar2, vbNullChar)
        xChar1 = Mid(xChar2, 3&, xLong4 - 3&)
        Else
        xLong4 = InStr(xChar2, vbNullChar)
        xChar1 = Left(xChar2, xLong4 - 1&)
        End If
      'Else
      'xChar1 = String(xLong3, vbNullChar)
      'Call RtlMoveMemory(ByVal xChar2, xByteA1(xByteA1_Pos), xLong3)
      'xByteA1_Pos = xByteA1_Pos + xLong3
      End If

'          ' 0 delvalue
'          ' 1 string
'          ' 2 hex(x)
'          ' 3 hex
'          ' 4 dword
'          ' 8 makedir       'xxxxxxxxxxx
'          ' 9 opendir       'xxxxxxxxxxx (does not create if not exists!!!)
'          '10 deldir        'xxxxxxxxxxx
'          '11 delsubdirs    'deletes all subkeys. key left open for writting values
'          '12 delmainvalues 'deletes all values in the directory itself. key left open for writting values


      If xLong1 = 0& Then
        If Not xKeyLong2 = 0& Then
          'Stop
          Call RegDeleteValueA(xKeyLong2, xChar1)
          End If
      ElseIf xLong1 < 5& Then
        If Not xKeyLong2 = 0& Then
          If xLong1 = 2& Then
            xLong1 = Asc(Left(xChar2, 1&)) * 256 + Asc(Mid(xChar2, 2&, 1&))
            End If
          xChar2 = Mid(xChar2, xLong4 + 1&)
          xChar2 = Replace(Replace(Replace(Replace(Replace(xChar2, _
                   "<reg2exepath>", AppPath, , , vbTextCompare), _
                   "<reg2exewinpath>", WinPath, , , vbTextCompare), _
                   "<reg2exesyspath>", SysPath, , , vbTextCompare), _
                   "<reg2exetemppath>", TempPath, , , vbTextCompare), _
                   "<reg2exeprogspath>", ProgPath, , , vbTextCompare)
'          xByteA1(xLong3) = 0
          'Stop
          Call RegSetValueExA(xKeyLong2, xChar1, 0&, xLong1, ByVal xChar2, xLong3 - xLong4 - 1&)
          End If
      ElseIf xLong1 = 8 Then
        'Stop
        If Not RegCreateKeyExA(xLong2, xChar2, 0&, "", 0&, 983103, ByVal 0&, xKeyLong2, xLong5) = 0& Then
          xKeyLong2 = 0&
          End If
      ElseIf xLong1 = 9 Or xLong1 = 12 Then
        'Stop
        If Not RegOpenKeyExA(xLong2, xChar1, 0&, &HF003F, xKeyLong2) = 0& Then
          xKeyLong2 = 0&
          ElseIf xLong1 = 12& Then
          RegDeleteValuesEx (xKeyLong2)
          End If
      ElseIf xLong1 = 10 Then
        'Stop
        Call RegDeleteKeysRecursive(xLong2, xChar1, 0&)
      ElseIf xLong1 = 11 Then
        'Stop
        xKeyLong2 = RegDeleteKeysRecursive(xLong2, xChar1, 1&)
      End If
    Loop
  
  If Not xKeyLong2 = 0& Then
    Call RegCloseKey(xKeyLong2)
    End If
  End Function



Private Sub RegDeleteValuesEx(ByVal OpenKey As Long)
  Dim xChar1 As String
  Dim xLong1 As Long
  Dim xLong2 As Long
  Dim xLong3 As Long

  Call RegDeleteValueA(OpenKey, xChar1)
  Do
    xChar1 = String(512&, vbNullChar)
    xLong2 = 512&
    xLong3 = RegEnumValueA(OpenKey, xLong1, ByVal xChar1, xLong2, 0&, 0&, 0&, 0&)
    'Stop
    Select Case xLong3
      Case 259&
        Call RegDeleteValueA(OpenKey, xChar1)
        xChar1 = ""
        Call RegDeleteValueA(OpenKey, xChar1)
        Exit Do
      Case 0&
        Call RegDeleteValueA(OpenKey, xChar1)
        xLong1 = xLong1 + 1&
      Case Else
        Exit Do
      End Select
    Loop
  End Sub


Public Function RegDeleteKeysRecursive(ByVal StartKey As Long, ByVal SubKey As String, ByVal NoDeleteMain As Boolean) As Long
  Dim xChar1 As String
  Dim xLong1 As Long
  Dim xLong2 As Long
  Dim xLong3 As Long

  If Not SubKey = "" Then
    If RegOpenKeyExA(StartKey, SubKey, 0, 983103, xLong1) = 0& Then
      Do
        xChar1 = String(512&, vbNullChar)
        xLong3 = 512&
        'Stop
        Select Case RegEnumKeyA(xLong1, xLong2, ByVal xChar1, xLong3)
          Case 0&
            Call RegDeleteKeysRecursive(xLong1, xChar1, False)
            xLong2 = xLong2 + 1&
          Case Else
            Exit Do
          End Select
        Loop
      If NoDeleteMain Then
        RegDeleteKeysRecursive = xLong1 'Key
        Else
        'Stop
        'Call RegDeleteKeyA(StartKey, SubKey)
        Call RegCloseKey(xLong1) ' Key)
        Call RegDeleteKeyA(StartKey, SubKey)
        End If
      End If
    End If
End Function

Private Sub GetXPAccess()
  Dim xLong1 As Long
  Dim xLong2 As Long
  Dim xType1 As OSVERSIONINFO
  Dim xType2 As TOKEN_PRIVILEGES
  Dim xType3 As TOKEN_PRIVILEGES
  
  xType1.dwOSVersionInfoSize = Len(xType1)
  If Not GetVersionExA(xType1) = 0& Then
    If (xType1.dwPlatformId = &H2&) Then
      If OpenProcessToken(GetCurrentProcess(), 40&, xLong2) Then
        xLong1 = LookupPrivilegeValueA(vbNullString, "SeTakeOwnershipPrivilege", xType2.Privileges(0).pLuid)
        xType2.PrivilegeCount = 1&
        xType2.Privileges(0).Attributes = 2&
        Call AdjustTokenPrivileges(xLong2, 0&, xType2, LenB(xType3), xType3, xLong1)
        End If
      End If
    End If
  End Sub

