Attribute VB_Name = "mod_LoadResEx"
' Copyright (C) 2004-2006 Jan Vorel
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA




' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues



'#LoadResEx_FlagA
'    1    LoadResStringA
'    2    LoadResStringAMultiline
'    4    LoadResStringsEx (maybe add tooltips, with new flag?)
'   10    LoadResPictureExA
'   20    FullAutoWindowIconLoad
'   40    Support HiColorIcons (auto, ResID + 1)
'   80    (reserved) Support AutoBackColor (auto, ResID + 2 (+1 if not &h40& ?))
'  100    LoadResDataA
'  200    LoadResMenu + All generic API
' 4000    LoadResLanguageFile
' 7FFF  = max!

Option Explicit
Option Base 0

#If (LoadResEx_FlagA And &H40&) = &H40& Then
  Private Declare Function GetDC Lib "user32" (ByVal hWnd As Long) As Long
  Private Declare Function GetDeviceCaps Lib "gdi32" (ByVal hdc As Long, ByVal nIndex As Long) As Long
  Private Declare Function ReleaseDC Lib "user32" (ByVal hWnd As Long, ByVal hdc As Long) As Long
  Private LoadResEx_MultiColorFlag As Long
  #End If
#If (LoadResEx_FlagA And &H80&) = &H80& Then
  '''''''''
  'loadresex_backcolorflag
  Private LoadResEx_BackColorFlag As Long ' 0/2
  #End If


#If (LoadResEx_FlagA And &H100&) = &H100& Then
  Private Declare Sub RtlMoveMemory Lib "kernel32" (lpvDest As Any, lpvSource As Any, ByVal cbCopy As Long)
  #End If

#If (LoadResEx_FlagA And &H4000&) = &H4000& Then
  Private Declare Function LoadLibraryA Lib "kernel32" (ByVal lpLibFileName As String) As Long
  Private Declare Function FreeLibrary Lib "kernel32" (ByVal hLibModule As Long) As Long
  Private Declare Function LoadStringA Lib "user32" (ByVal hInstance As Long, ByVal wID As Long, ByVal lpBuffer As String, ByVal nBufferMax As Long) As Long
  Private LngFileHandle As Long
  #End If

 #If (LoadResEx_FlagA And &H4100&) = &H4100& Then
  Private Declare Function FindResourceA Lib "kernel32" (ByVal hInstance As Long, ByVal lpName As String, ByVal lpType As String) As Long
  Private Declare Function LoadResource Lib "kernel32" (ByVal hInstance As Long, ByVal hResInfo As Long) As Long
  'Private Declare Function lstrcpynA Lib "kernel32" (ByVal lpString1 As String, ByVal lpString2 As Long, ByVal iMaxLength As Long) As Long
  Private Declare Function SizeofResource Lib "kernel32.dll" (ByVal hInstance As Long, ByVal hResInfo As Long) As Long
  #End If


#If (LoadResEx_FlagA And &H200&) = &H200& Then
  Public Declare Function CreatePopupMenu Lib "user32" () As Long
  Public Declare Function LoadMenuA Lib "user32" (ByVal hInstance As Long, ByVal lpString As String) As Long
  Public Declare Function DestroyMenu Lib "user32" (ByVal hMenu As Long) As Long
  'Public Declare Function TrackPopupMenu Lib "user32" (ByVal hMenu As Long, ByVal wFlags As Long, ByVal x As Long, ByVal y As Long, ByVal nReserved As Long, ByVal hWnd As Long, lprc As RECT) As Long
  'Public Declare Function AppendMenuA Lib "user32" (ByVal hMenu As Long, ByVal wFlags As Long, ByVal wIDNewItem As Long, ByVal lpNewItem As Any) As Long
  Public Declare Function InsertMenuA Lib "user32" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long, ByVal wIDNewItem As Long, ByVal lpNewItem As Any) As Long
  Public Declare Function ModifyMenuA Lib "user32" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long, ByVal wIDNewItem As Long, ByVal lpString As Any) As Long
  Public Declare Function CheckMenuItem Lib "user32" (ByVal hMenu As Long, ByVal wIDCheckItem As Long, ByVal wCheck As Long) As Long
  Public Declare Function EnableMenuItem Lib "user32" (ByVal hMenu As Long, ByVal wIDEnableItem As Long, ByVal wEnable As Long) As Long
  'Const MF_BYCOMMAND = &H0&
  'Const MF_BYPOSITION = &H400&
  'Const MF_POPUP = &H10&
  Public Declare Function TrackPopupMenuEx Lib "user32" (ByVal hMenu As Long, ByVal un As Long, ByVal n1 As Long, ByVal n2 As Long, ByVal hWnd As Long, lpTPMParams As Long) As Long
  Public Declare Function SetMenu Lib "user32" (ByVal hWnd As Long, ByVal hMenu As Long) As Long
  Public Declare Function DrawMenuBar Lib "user32" (ByVal hWnd As Long) As Long
  'Public Declare Function EnableMenuItem Lib "user32" (ByVal hMenu As Long, ByVal wIDEnableItem As Long, ByVal wEnable As Long) As Long
  'Public Declare Function GetMenuItemInfo Lib "user32" Alias "GetMenuItemInfoA" (ByVal hMenu As Long, ByVal un As Long, ByVal b As Long, lpMenuItemInfo As MENUITEMINFO) As Long
  'Public Declare Function InsertMenuItem Lib "user32" Alias "InsertMenuItemA" (ByVal hMenu As Long, ByVal un As Long, ByVal bool As Boolean, ByRef lpcMenuItemInfo As MENUITEMINFO) As Long
  Public Declare Function DeleteMenu Lib "user32" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long) As Long
  'Public Declare Function SetMenuItemInfo Lib "user32" Alias "SetMenuItemInfoA" (ByVal hMenu As Long, ByVal un As Long, ByVal bool As Boolean, lpcMenuItemInfo As MENUITEMINFO) As Long
  'Public Declare Function GetMenu Lib "user32" (ByVal hWnd As Long) As Long
  Public Declare Function SetMenuDefaultItem Lib "user32" (ByVal hMenu As Long, ByVal uItem As Long, ByVal fByPos As Long) As Long
  
  ' Should not be needed in normal cases?
  Public Declare Function GetMenuString Lib "user32" Alias "GetMenuStringA" (ByVal hMenu As Long, ByVal wIDItem As Long, ByVal lpString As String, ByVal nMaxCount As Long, ByVal wFlag As Long) As Long
  Public Declare Function GetMenuState Lib "user32" (ByVal hMenu As Long, ByVal wID As Long, ByVal wFlags As Long) As Long
  
  'Public Declare Function GetSubMenu Lib "user32" (ByVal hMenu As Long, ByVal nPos As Long) As Long
  Public Declare Function GetMenuItemCount Lib "user32" (ByVal hMenu As Long) As Long
  Public Declare Function RemoveMenu Lib "user32" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long) As Long
  #End If
'Const MIIM_ID As Long = &H2
'Const MIIM_FTYPE As Long = &H100
'Const MF_STRING As Long = &H0&
'Const MF_SEPARATOR As Long = &H800&

'Public Type MENUITEMINFO
'  cbSize As Long
'  fMask As Long
'  fType As Long
'  fState As Long
'  wID As Long
'  hSubMenu As Long
'  hbmpChecked As Long
'  hbmpUnchecked As Long
'  dwItemData As String 'Long
'  dwTypeData As String
'  cch As Long
'  End Type
#If (LoadResEx_FlagA And &H20&) = &H20& Then
  'Private Declare Function GetSystemMetrics Lib "user32" (ByVal nIndex As Long) As Long
  'Private Declare Function GetWindow Lib "user32" (ByVal hWnd As Long, ByVal wCmd As Long) As Long
  Private Declare Function LoadImageA Lib "user32" (ByVal hInst As Long, ByVal lpsz As String, ByVal uType As Long, ByVal cxDesired As Long, ByVal cyDesired As Long, ByVal fuLoad As Long) As Long
  Public Declare Function DestroyIcon Lib "user32" (ByVal hIcon As Long) As Long
  Private Declare Function SendMessageLong Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
  
  Private Type OSVERSIONINFO
    dwOSVersionInfoSize As Long
    dwMajorVersion As Long
    dwMinorVersion As Long
    dwBuildNumber As Long
    dwPlatformId As Long
    szCSDVersion As String * 128
    End Type
  Private Declare Function GetVersionExA Lib "kernel32" (lpVersionInformation As OSVERSIONINFO) As Long
  #End If

#If (LoadResEx_FlagA And &H20&) = &H20& Then
  Public Function LoadResWindowIcon(ByVal hWnd As Long, ByVal IconID As Long, Optional ByVal KeepAlive As Boolean, Optional ByRef Color256Support As Boolean = True) As Long ', Optional ByVal IsClassIcon As Boolean = False)
  
    'If Not hWnd = 0& Then
      #If (LoadResEx_FlagA And &H40&) = &H40& Then
        If Color256Support Then
          LoadResWindowIcon = LoadImageA(App.hInstance, "#" & CStr(IconID + LoadResEx_MultiColorFlag), 1&, 16&, 16&, &H8000&)
          Color256Support = Not (LoadResEx_MultiColorFlag = 0& Or LoadResWindowIcon = 0&)
          End If
        If LoadResWindowIcon = 0& And LoadResEx_MultiColorFlag = 1& Then
          LoadResWindowIcon = LoadImageA(App.hInstance, "#" & CStr(IconID), 1&, 16&, 16&, &H8000&)
          End If
        #Else
        LoadResWindowIcon = LoadImageA(App.hInstance, "#" & CStr(IconID), 1&, 16&, 16&, &H8000&)
        #End If
      If Not LoadResWindowIcon = 0& Then
        If Not hWnd = -1& Then
          Call SendMessageLong(hWnd, &H80&, 0&, LoadResWindowIcon)
          Call SendMessageLong(hWnd, &H80&, 1&, LoadResWindowIcon)
          End If
        'Call SendMessageLong(hWnd, &H80&, 1&, LoadResWindowIcon)
        If Not KeepAlive Then
          Call DestroyIcon(LoadResWindowIcon)
          LoadResWindowIcon = 1&
          End If
        End If
      'End If
    End Function

  Public Function LoadResEx_Check256TraySupport() As Boolean
    Dim xType1 As OSVERSIONINFO
    
    xType1.dwOSVersionInfoSize = 148& ' Len(xType1)
    If Not GetVersionExA(xType1) = 0& Then
      If (xType1.dwPlatformId = &H2&) Then
        If xType1.dwMajorVersion > 5& Or xType1.dwMajorVersion = 5& And xType1.dwMinorVersion >= 1& Then
          LoadResEx_Check256TraySupport = True
          'nt series
          End If
        Else
        If xType1.dwMajorVersion > 4& Or xType1.dwMajorVersion = 4& And xType1.dwMinorVersion >= 90& Then
          LoadResEx_Check256TraySupport = True
          End If
        End If
      End If
    End Function
  #End If

#If (LoadResEx_FlagA And &H200&) = &H200& Then
  #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
    Public Function LoadResMenu(ByVal MenuID As Long, Optional ByVal LoadFromSource As Long = 2&) As Long
      'xLong1 = FindResourceA(LngFileHandle, resFileName, resType)
      If Not (LngFileHandle = 0& Or LoadFromSource = 0&) Then
        'LoadResMenu = LoadResource(LngFileHandle, xLong1)
        LoadResMenu = LoadMenuA(LngFileHandle, ByVal "#" & CStr(MenuID))
        End If
      If (LngFileHandle = 0& Or LoadResMenu = 0&) And Not LoadFromSource = 1& Then
        LoadResMenu = LoadMenuA(App.hInstance, ByVal "#" & CStr(MenuID))
        End If
      End Function
    #Else
    Public Function LoadResMenu(ByVal MenuID As Long) As Long
      LoadResMenu = LoadMenuA(App.hInstance, ByVal "#" & CStr(MenuID))
      End Function
    #End If
  #End If

#If (LoadResEx_FlagA And &H4000&) = &H4000& Then
  Public Function LoadResLanguageFile(Optional ByVal FileName As String) As Boolean
    If Not LngFileHandle = 0& Then
      Call FreeLibrary(LngFileHandle)
      End If
    If FileName = "" Then
      LngFileHandle = 0&
      Else
      LngFileHandle = LoadLibraryA(FileName)
      LoadResLanguageFile = Not LngFileHandle = 0&
      End If
    End Function
  #End If

#If Not (LoadResEx_FlagA And &H3&) = &H0& Then
  #If (LoadResEx_FlagA And &H2&) = &H2& Then
    #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
      Public Function LoadResStringA(ByVal ResID As Long, Optional ByVal CanBeMultiLine As Boolean = False, Optional ByVal LoadFromSource As Long = 2&) As String
      #Else
      Public Function LoadResStringA(ByVal ResID As Long, Optional ByVal CanBeMultiLine As Boolean = False) As String
      #End If
    #Else
    #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
      Public Function LoadResStringA(ByVal ResID As Long, Optional ByVal LoadFromSource As Long = 2&) As String
      #Else
      Public Function LoadResStringA(ByVal ResID As Long) As String
      #End If
    #End If
    
    #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
      Dim xLong1 As Long
      Static xChar1 As String * 32767
      
      If Not (LngFileHandle = 0& Or LoadFromSource = 0&) Then
        xLong1 = LoadStringA(LngFileHandle, ResID, xChar1, 32766)
        If Not xLong1 = 0& Then
          LoadResStringA = Left(xChar1, xLong1)
          End If
        End If
      If (LngFileHandle = 0& Or xLong1 = 0&) And Not LoadFromSource = 1& Then
        #End If
    
          On Error Resume Next
          LoadResStringA = "#" & CStr(ResID)
          LoadResStringA = LoadResString(ResID)
          On Error GoTo 0
          
          #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
        End If
      #End If
    
    #If (LoadResEx_FlagA And &H2&) = &H2& Then
      If CanBeMultiLine Then
        LoadResStringA = Replace(Replace(Replace(LoadResStringA, "&|", vbNullChar), "|", vbCr), vbNullChar, "|")
        End If
      #End If
    End Function
  #End If

#If (LoadResEx_FlagA And &H4&) = &H4& Then
  #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
    Public Function LoadResStringsEx(ByVal xForm As Form, Optional ByVal MainIconResID As Long = -1&, Optional ByVal LoadFromSource As Long = 2&) As Boolean
    #Else
    Public Function LoadResStringsEx(ByVal xForm As Form, Optional ByVal MainIconResID As Long = -1&) As Boolean
    #End If
  
    Dim xObj1 As Object
    Dim xChar1 As String
    #If NoUseLoadResStringA Then
      Dim xLong1 As Long
      #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
        'Dim xLong1 As Long
        Static xChar1 As String * 32767
        #End If
      #End If
    
    For Each xObj1 In xForm.Controls
      xChar1 = ""
      On Error Resume Next
      xChar1 = xObj1.Caption
      If Left(xChar1, 1&) = "$" Then
        #If NoUseLoadResStringA Then
          
          
          
          #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
            If Not (LngFileHandle = 0& Or LoadFromSource = 0&) Then
              xLong1 = LoadStringA(LngFileHandle, ResID, xChar1, 32766)
              If Not xLong1 = 0& Then
                LoadResStringA = Left(xChar1, xLong1)
                End If
              End If
            If (LngFileHandle = 0& Or xLong1 = 0&) And Not LoadFromSource = 1& Then
              #End If
          
          
                
                xLong1 = Val(Mid(xChar1, 2&))
                LoadResStringA = "#" & CStr(xLong1)
                LoadResStringA = LoadResString(xLong1)
          
          
                #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
              End If
            #End If
          
          #Else
          xObj1.Caption = LoadResStringA(Val(Mid(xChar1, 2&)))
          #End If
        On Error GoTo 0
        End If
      Next
    
    On Error Resume Next
    xChar1 = xForm.Caption
    If Left(xChar1, 1&) = "$" Then
      xForm.Caption = LoadResStringA(Val(Mid(xChar1, 2&)))
      End If
    'Stop
    If Not MainIconResID = -1& Then
      #If (LoadResEx_FlagA And &HF0&) = 0& Then
        xForm.Icon = LoadResPicture(MainIconResID, 1)
        #Else
        #If (LoadResEx_FlagA And &H20&) = &H20& Then
          Call LoadResWindowIcon(xForm.hWnd, MainIconResID, False) ', False)
          #Else
          Call LoadResPictureExA(MainIconResID, xForm, False, True)
          #End If
        #End If
      End If
    On Error GoTo 0
    End Function
  #End If

'#If UseLoadResPictureAFake Then
'  Public Sub LoadResPictureExA(ByVal ResID As Long, ByVal eObject As Object, Optional ByVal BmpNotIcon As Boolean = False, Optional ByVal SetIcon As Boolean = False)
'    'Set LoadResPictureA = LoadPicture()
'    End Sub
'  #End If

#If (LoadResEx_FlagA And &H10&) = &H10& Then
  Public Function LoadResPictureExA(ByVal ResID As Long, ByVal eObject As Object, Optional ByVal BmpNotIcon As Boolean = False, Optional ByVal SetIcon As Boolean = False)

    #If (LoadResEx_FlagA And &HC0&) = &HC0& Then
      Static xLong1 As Long
      
      On Error GoTo Er1
      If SetIcon Then
        eObject.Icon = LoadPicture()
        Else
        eObject.Picture = LoadPicture()
        End If
      xLong1 = LoadResEx_MultiColorFlag + LoadResEx_BackColorFlag
      Do
        If SetIcon Then
          eObject.Icon = LoadResPicture(ResID + xLong1, 1)
          Else
          eObject.Picture = LoadResPicture(ResID + xLong1, CInt(BmpNotIcon) + 1)
          End If
        LoadResPictureExA = True
        Exit Do
Rs1:
        Select Case xLong1
          Case 3&
            xLong1 = 2&
          Case 2&
            If LoadResEx_MultiColorFlag = 0& Then
              Exit Do
              Else
              xLong1 = LoadResEx_MultiColorFlag
              End If
          Case 1&
            xLong1 = 0&
          Case Else
            Exit Do
          End Select
        Loop
      
      On Error GoTo 0
      Exit Function

Er1:
      Resume Rs1
    
    
    
    
      #ElseIf Not (LoadResEx_FlagA And &HC0&) = &H0& Then
      On Error GoTo Er1
      If SetIcon Then
        eObject.Icon = LoadPicture()
        #If (LoadResEx_FlagA And &H40&) = &H40& Then
          eObject.Icon = LoadResPicture(ResID + LoadResEx_MultiColorFlag, 1)
          #Else
          eObject.Icon = LoadResPicture(ResID + LoadResEx_BackColorFlag, 1)
          #End If
        Else
        eObject.Picture = LoadPicture()
        #If (LoadResEx_FlagA And &H40&) = &H40& Then
          eObject.Picture = LoadResPicture(ResID + LoadResEx_MultiColorFlag, CInt(BmpNotIcon) + 1)
          #Else
          eObject.Picture = LoadResPicture(ResID + LoadResEx_BackColorFlag, CInt(BmpNotIcon) + 1)
          #End If
        End If
      LoadResPictureExA = True
Rs1:
      On Error GoTo 0
      Exit Function

Er1:
      #If (LoadResEx_FlagA And &H40&) = &H40& Then
        If LoadResEx_MultiColorFlag = 0& Then
          Resume Rs1
          Else
          Resume Rs2
          End If
        #Else
        If LoadResEx_BackColorFlag = 0& Then
          Resume Rs1
          Else
          Resume Rs2
          End If
        #End If
      
Rs2:
      On Error GoTo Er2
      If SetIcon Then
        #If (LoadResEx_FlagA And &H40&) = &H40& Then
          eObject.Icon = LoadResPicture(ResID, 1)
          #Else
          eObject.Icon = LoadResPicture(ResID, 1)
          #End If
        Else
        #If (LoadResEx_FlagA And &H40&) = &H40& Then
          eObject.Picture = LoadResPicture(ResID, CInt(BmpNotIcon) + 1)
          #Else
          eObject.Picture = LoadResPicture(ResID, CInt(BmpNotIcon) + 1)
          #End If
        End If
      LoadResPictureExA = True
      On Error GoTo 0
      Exit Function

Er2:
  Resume Rs1
      
      
      #Else
      On Error GoTo Er1
      If SetIcon Then
        eObject.Icon = LoadPicture()
        eObject.Icon = LoadResPicture(ResID, 1)
        Else
        eObject.Picture = LoadPicture()
        eObject.Picture = LoadResPicture(ResID, CInt(BmpNotIcon) + 1)
        End If
      LoadResPictureExA = True
Rs1:
      On Error GoTo 0
      Exit Function
  
Er1:
      Resume Rs1
      #End If


    End Function
  #End If

#If (LoadResEx_FlagA And &H100&) = &H100& Then
  #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
    Public Function LoadResDataA(ByVal resFileName As String, Optional ByVal resType As String = "BIN", Optional ByVal LoadFromSource As Long = 2&) As String
    #Else
    Public Function LoadResDataA(ByVal resFileName As String, Optional ByVal resType As String = "BIN") As String
    #End If
    
    Dim xByteA1() As Byte
    Dim xLong1 As Long
    
    #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
      Dim xLong2 As Long
      Dim xLong3 As Long
      'Static xChar1 As String * 32767
      'Dim xChar1 As String
      
      If Not (LngFileHandle = 0& Or LoadFromSource = 0&) Then
        xLong1 = FindResourceA(LngFileHandle, resFileName, resType)
        If Not xLong1 = 0& Then
          xLong2 = LoadResource(LngFileHandle, xLong1)
'          Stop
          If Not xLong2 = 0& Then
            xLong3 = SizeofResource(LngFileHandle, xLong1)
            If Not xLong3 = 0& Then
            'xChar1 = String(32767, vbNullChar)
              'Call lstrcpynA(xChar1, xLong2, 32766&)
              'LoadResDataA = Trim(Left(xChar1, InStr(xChar1 & vbNullChar, vbNullChar) - 1&))
              LoadResDataA = String(xLong3, vbNullChar)
              Call RtlMoveMemory(ByVal LoadResDataA, ByVal xLong2, xLong3)
              End If
            End If
          End If
        End If
      If (LngFileHandle = 0& Or xLong1 = 0& Or xLong2 = 0& Or xLong3 = 0&) And Not LoadFromSource = 1& Then
        #End If
    
    
    
          On Error GoTo Er1
          xByteA1() = LoadResData(resFileName, resType)
          xLong1 = UBound(xByteA1()) + 1&
          LoadResDataA = String(xLong1, vbNullChar)
          RtlMoveMemory ByVal LoadResDataA, xByteA1(0&), xLong1
Rs1:
          On Error GoTo 0
          
          
          
          #If (LoadResEx_FlagA And &H4000&) = &H4000& Then
        End If
      #End If
    
    
    Exit Function
    
Er1:
    Resume Rs1
    End Function
  #End If

#If Not (LoadResEx_FlagA And &HC0&) = &H0& Then
  Public Sub LoadResEx_CheckHighColor()
    #If (LoadResEx_FlagA And &H40&) = &H40& Then
      Dim xLong1 As Long
    
      LoadResEx_MultiColorFlag = 0&
      xLong1 = GetDC(0&)
      If Not xLong1 = 0& Then
        If GetDeviceCaps(xLong1, 12&) > 15& Then
          LoadResEx_MultiColorFlag = 1&
          End If
        Call ReleaseDC(0&, xLong1)
        End If
      #End If
    #If (LoadResEx_FlagA And &H80&) = &H80& Then
      #If (LoadResEx_FlagA And &HC0&) = &HC0& Then
        'LoadResEx_BackColorFlag = 0/2
      '''''
        ' else LoadResEx_BackColorFlag = 0/2
          #End If
      #End If
    End Sub
  #End If
