Attribute VB_Name = "mod_ctInterprete"
' Copyright (C) 2000-2006 Jan Vorel
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues

Option Explicit
Option Base 0

Private Const ConstVals As String = "0123456789"


Public Function ctInterpretA(ByVal ctString As String) As Boolean
Dim xFinderLeft1 As Long
Dim xFinderRight1 As Long
Dim xLeftString As String
Dim xLong1 As Long
Dim xOldString As String

ctString = Trim(ctString)
ctReplace ctString, "=>", ">="
ctReplace ctString, "=<", "<="
ctReplace ctString, " ", ""
 

  
ctReplace ctString, "{", "("
If ctString = "" Then Exit Function
ctString = "(" + ctString + ")"

xLong1 = iCount(ctString, "(") - iCount(ctString, ")")
If xLong1 > 0 Then
  ctString = ctString + String(xLong1, ")")
  Else
  ctString = String(-xLong1, "(") + ctString
  End If

On Error GoTo Er1
Do While ctString <> xOldString
  xOldString = ctString
  xFinderLeft1 = 1
  Do While xFinderLeft1 > 0
    Do
      xFinderLeft1 = InStr(xFinderLeft1, ctString, "(")
      If xFinderLeft1 = 0 Then Exit Do
      xFinderRight1 = xFinderLeft1 + 1
      Do While (xFinderRight1 < Len(ctString) + 1)
        If InStr(ConstVals, Mid$(ctString, xFinderRight1, 1)) = 0 Then Exit Do
        xFinderRight1 = xFinderRight1 + 1
        Loop
      If Mid$(ctString, xFinderRight1, 1) <> ")" Then xFinderLeft1 = xFinderRight1: Exit Do
      xLeftString = Mid(ctString, xFinderLeft1 + 1, xFinderRight1 - xFinderLeft1 - 1)
      If InStr(xLeftString, Chr(0)) = 0 Then
        If Not xLeftString = "" Then
          xLeftString = Trim(Str(Val(xLeftString)))
          End If
        ctString = Left(ctString, xFinderLeft1 - 1) + Trim(xLeftString) + Mid(ctString, xFinderRight1 + 1)
        xFinderLeft1 = 0
        Else
        xFinderLeft1 = xFinderLeft1 + 1
        End If
      Exit Do
      Loop
    Loop
  
  ctReplace ctString, "not", Chr(4)
  ctReplace ctString, "and", Chr(3)
  ctReplace ctString, "or", Chr(2)
  ctReplace ctString, "xor", Chr(1)
  ctReplace ctString, "Eqv", Chr(0)
  
  ctCheckFor ctString, ">="
  ctCheckFor ctString, "<="
  ctCheckFor ctString, "<>"
  ctReplace ctString, ">=", Chr(5)
  ctReplace ctString, "<=", Chr(6)
  ctReplace ctString, "<>", Chr(7)
  ctCheckFor ctString, "="
  ctCheckFor ctString, "<"
  ctCheckFor ctString, ">"
  ctCheckFor ctString, "|"
  ctReplace ctString, Chr(5), ">="
  ctReplace ctString, Chr(6), "<="
  ctReplace ctString, Chr(7), "<>"
  
  ctReplaceX ctString, 0, "1001"
  ctReplaceX ctString, 1, "0110"
  ctReplaceX ctString, 2, "0111"
  ctReplaceX ctString, 3, "0001"
  ctReplaceX ctString, 4, "10"
  ctReplace ctString, Chr(4), "not"
  ctReplace ctString, Chr(3), "and"
  ctReplace ctString, Chr(2), "or"
  ctReplace ctString, Chr(1), "xor"
  ctReplace ctString, Chr(0), "eqv"
  Loop

ctInterpretA = xOldString = "1"

Rs1:
On Error GoTo 0
Exit Function

Er1:
Resume Rs1
End Function

Private Sub ctReplace(ByRef ctString As String, ByVal StringToFind As String, ByVal ReplaceString As String)
Dim xLong1 As Long
Dim xLong2 As Long
xLong2 = Len(StringToFind)
Do
  xLong1 = InStr(ctString, StringToFind)
  If xLong1 = 0 Then Exit Do
  ctString = Left(ctString, xLong1 - 1) + ReplaceString + Mid(ctString, xLong1 + xLong2)
  Loop
End Sub

Private Sub ctCheckFor(ByRef ctString As String, ByVal CalcOption As String)
Dim xLeft As Long
Dim xRight As Long
Dim xFinder As Long
Dim xValL As String
Dim xValR As String
Dim xResult As Boolean

xFinder = 1
Do
  xFinder = InStr(xFinder, ctString, CalcOption)
  If xFinder < 2 Or xFinder > Len(ctString) - 2 Then Exit Sub
  xLeft = xFinder
  Do
    If xLeft = 1 Then Exit Do
    If InStr(ConstVals, Mid(ctString, xLeft - 1, 1)) = 0 Then Exit Do
    xLeft = xLeft - 1
    Loop
  xRight = xFinder - 1 + Len(CalcOption)
  Do
    If xRight = Len(ctString) Then Exit Do
    If InStr(ConstVals, Mid(ctString, xRight + 1, 1)) = 0 Then Exit Do
    xRight = xRight + 1
    Loop
  If xRight > xFinder - 1 + Len(CalcOption) And xLeft < xFinder Then
    If Not (xLeft = 0 Or xRight = Len(ctString)) Then
    If InStr("-^*/#+)", Mid(ctString, xLeft - 1, 1)) = 0 And _
      InStr("-^*/#+(", Mid(ctString, xRight + 1, 1)) = 0 Then
    xValL = Mid(ctString, xLeft, xFinder - xLeft)
    xValR = Mid(ctString, xFinder + Len(CalcOption), xRight - (xFinder - 1 + Len(CalcOption)))
    xResult = 0
    Select Case CalcOption
      Case ">=", "=>": If Val(xValL) >= Val(xValR) Then xResult = 1
      Case "<=", "=<": If Val(xValL) <= Val(xValR) Then xResult = 1
      Case "<>", "|": If Val(xValL) <> Val(xValR) Then xResult = 1
      Case "=": If Val(xValL) = Val(xValR) Then xResult = 1
      Case "<": If Val(xValL) < Val(xValR) Then xResult = 1
      Case ">": If Val(xValL) > Val(xValR) Then xResult = 1
      End Select
    If xResult Then
      xValL = "1"
      Else
      xValL = "0"
      End If
    ctString = Left(ctString, xLeft - 1) + xValL + Mid(ctString, xRight + 1)
    xFinder = xLeft
    End If
    End If
    End If
  xFinder = xFinder + 1
  Loop
End Sub

Private Function iCount(ByVal bChar As String, ByVal fChar As String) As Long
Dim xLong1 As Long
Do
  xLong1 = InStr(xLong1 + 1, bChar, fChar)
  If xLong1 = 0 Then Exit Do
  iCount = iCount + 1
  Loop
End Function

Private Sub ctReplaceX(ByRef ctString As String, ByVal FlagToFind As Long, ByVal ReplaceStrings As String)
Dim xLong1 As Long
'Dim xLong2 As Long
Dim xLong3 As Long
Dim xLong4 As Long

Do
  xLong1 = InStr(xLong1 + 1, ctString, Chr(FlagToFind))
  If xLong1 = 0 Then Exit Do
  If FlagToFind = 4 Then
    If xLong1 < Len(ctString) - 1 Then
      xLong3 = Asc(Mid(ctString, xLong1 + 2))
      
      If (xLong3 <= FlagToFind Or xLong3 = 41) And _
         (Mid(ctString, xLong1 + 1, 1) = "0" Or Mid(ctString, xLong1 + 1, 1) = "1") Then
        If Mid(ctString, xLong1 + 1, 1) = "1" Then
          xLong3 = 1
          Else
          xLong3 = 0
          End If
        ctString = Left(ctString, xLong1 - 1) + Mid(ReplaceStrings, xLong3 + 1, 1) + Mid(ctString, xLong1 + 2)
        End If
      End If
    Else
    If xLong1 > 2 And xLong1 < Len(ctString) - 1 Then
      xLong3 = Asc(Mid(ctString, xLong1 - 2))
      xLong4 = Asc(Mid(ctString, xLong1 + 2))
      If (xLong3 < FlagToFind Or xLong3 = 40) And _
         (xLong4 <= FlagToFind Or xLong4 = 41) And _
         (Mid(ctString, xLong1 - 1, 1) = "0" Or Mid(ctString, xLong1 - 1, 1) = "1") And _
         (Mid(ctString, xLong1 + 1, 1) = "0" Or Mid(ctString, xLong1 + 1, 1) = "1") Then
        If Mid(ctString, xLong1 - 1, 1) = "0" Then
          xLong3 = 0
          Else
          xLong3 = 2
          End If
        If Mid(ctString, xLong1 + 1, 1) = "1" Then
          xLong3 = xLong3 + 1
          End If
        ctString = Left(ctString, xLong1 - 2) + Mid(ReplaceStrings, xLong3 + 1, 1) + Mid(ctString, xLong1 + 2)
        End If
      End If
    End If
  Loop
End Sub

