Attribute VB_Name = "Module1"
' Modul for Visual Basic 6
' Copyright (C) 2001-2008 Jan Vorel
'
' This program is free software; you can redistribute it and/or modify
' it under the terms of the GNU General Public License as published by
' the Free Software Foundation; either version 2 of the License, or
' (at your option) any later version.

' This program is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
' GNU General Public License for more details.

' You should have received a copy of the GNU General Public License
' along with this program; if not, write to the Free Software
' Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

' This is a shared modul, class modul, usercontrol or form. It is also
' published under the GNU General Public License.

' If you have any questions, suggestions or bug reports about this product,
' contact me: info@ctuser.net; Do not contact me about general B.A.S.I.C.
' language or A.P.I. issues

Option Explicit
Option Base 0

'Private Declare Function RegSetValueExA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpData As Any, ByVal cbData As Long) As Long
'Private Declare Function RegEnumValueA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal dwIndex As Long, ByVal lpValueName As String, lpcbValueName As Long, lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long
'Private Declare Function RegEnumKeyA Lib "advapi32.dll" (ByVal HKEY As Long, ByVal dwIndex As Long, lpName As Any, ByVal cbName As Long) As Long

Private Type LARGE_INTEGER
  lowpart As Long
  highpart As Long
  End Type

Private Type LUID_AND_ATTRIBUTES
  pLuid As LARGE_INTEGER
  Attributes As Long
  End Type

Private Type TOKEN_PRIVILEGES
  PrivilegeCount As Long
  Privileges(1) As LUID_AND_ATTRIBUTES
  End Type

Public Type OSVERSIONINFO
  dwOSVersionInfoSize As Long
  dwMajorVersion As Long
  dwMinorVersion As Long
  dwBuildNumber As Long
  dwPlatformId As Long
  szCSDVersion As String * 128
  End Type

Private Declare Function LookupPrivilegeValueA Lib "advapi32.dll" (ByVal lpSystemName As String, ByVal lpName As String, lpLuid As LARGE_INTEGER) As Long
Private Declare Function GetCurrentProcess Lib "kernel32" () As Long
Private Declare Function AdjustTokenPrivileges Lib "advapi32.dll" (ByVal TokenHandle As Long, ByVal DisableAllPrivileges As Long, NewState As TOKEN_PRIVILEGES, ByVal BufferLength As Long, PreviousState As TOKEN_PRIVILEGES, ReturnLength As Long) As Long
Private Declare Function OpenProcessToken Lib "advapi32.dll" (ByVal ProcessHandle As Long, ByVal DesiredAccess As Long, TokenHandle As Long) As Long
'Private Declare Function ExitWindowsEx Lib "user32" (ByVal uFlags As Long, ByVal dwReserved As Long) As Long
Public Declare Function GetVersionExA Lib "kernel32" (lpVersionInformation As OSVERSIONINFO) As Long












Private Declare Sub RtlMoveMemory Lib "kernel32" (lpvDest As Any, lpvSource As Any, ByVal cbCopy As Long)

Private xByteA1_Pos As Long
Private xByteA1() As Byte


Public Function ConvertRegistryA_ImportData(ByVal RegestryData As String, _
        ByVal WinPath As String, ByVal SysPath As String, _
        ByVal TempPath As String, ByVal ProgPath As String, _
        ByVal AppPath As String, _
        Optional ByVal ProgressControl As Long = 0&, Optional ByVal ProgressStart As Long = 0&, Optional ByVal ProgressTotal As Long = 0&, Optional ByVal ProgressQueue As Long = 0&)
  
  Dim xByteA1_Size As Long
  Dim xChar1 As String
  Dim xChar2 As String
  Dim xChar3 As String
  Dim xLong1 As Long
  Dim xLong2 As Long
  Dim xLong3 As Long
  Dim xLong4 As Long
  Dim xLong5 As Long
  Dim xKeyLong2 As Long
  
  Dim WinPathW As String
  Dim SysPathW As String
  Dim TempPathW As String
  Dim ProgPathW As String
  Dim AppPathW As String
  
  Dim ReGPlace1 As String
  Dim ReGPlace2 As String
  Dim ReGPlace3 As String
  Dim ReGPlace4 As String
  Dim ReGPlace5 As String

  Call MkWide(WinPath, WinPathW)
  Call MkWide(SysPath, SysPathW)
  Call MkWide(TempPath, TempPathW)
  Call MkWide(ProgPath, ProgPathW)
  Call MkWide(AppPath, AppPathW)
  
  Call MkWide("<reg2exepath>", ReGPlace1)
  Call MkWide("<reg2exewinpath>", ReGPlace2)
  Call MkWide("<reg2exesyspath>", ReGPlace3)
  Call MkWide("<reg2exetemppath>", ReGPlace4)
  Call MkWide("<reg2exeprogspath>", ReGPlace5)
  
  
  
#If 0 Then
Open "C:\test_reg.bin" For Output As 5
Close 5
Open "C:\test_reg.bin" For Binary Access Write Lock Read Write As 5
Put 5, , RegestryData
Close 5
#End If
  
#If 0 Then
Open "C:\test_reg.bin" For Input As 5
Close 5
Open "C:\test_reg.bin" For Binary Access Read Lock Write As 5
RegestryData = String(LOF(5), vbNullChar)
Get 5, , RegestryData
Close 5
#End If
  
  xByteA1_Pos = 0&
  xByteA1_Size = Len(RegestryData)
  ReDim xByteA1(xByteA1_Size - 1&)
  Call RtlMoveMemory(xByteA1(0), ByVal RegestryData, xByteA1_Size)

  Call GetXPAccess
'  Stop

  Do While xByteA1_Pos < xByteA1_Size
    xLong3 = GetNum(4&)
    xLong1 = GetNum(2&)
    xChar1 = ReadDyn(xLong3 And &H80000000, xLong1)
    xLong2 = ((xLong3 And &HF000000) \ &H1000000)
    
'    Debug.Print "Process: ", xLong3, xLong1, xChar1
    
    If xLong2 = 0& Then
'      Debug.Print "Stringig", xLong2;
      If (xLong3 And &H3FFFFFFF) Then
        
        xLong2 = GetNum(4&)
        xLong5 = xLong3
        xLong3 = (xLong3 And &H3FFFFFFF)
        
        Select Case xLong3
          Case 1&, 2&, 7&
            xChar2 = ReadDyn((xLong5 And &H40000000), xLong2)
          Case Else
            xChar2 = ReadDyn(0&, xLong2)
          End Select
'        Debug.Print "data", xChar2
        
        If Not xKeyLong2 = 0& Then
          xChar2 = Replace(Replace(Replace(Replace(Replace(xChar2, _
                   "<reg2exepath>", AppPath, , , vbTextCompare), _
                   "<reg2exewinpath>", WinPath, , , vbTextCompare), _
                   "<reg2exesyspath>", SysPath, , , vbTextCompare), _
                   "<reg2exetemppath>", TempPath, , , vbTextCompare), _
                   "<reg2exeprogspath>", ProgPath, , , vbTextCompare)
          
          Select Case xLong3
            Case 1&, 2&, 7&
'              Stop
              Call RegSetValueEx_String(xKeyLong2, xChar1, xChar2)
            Case Else
              ' also bin replace!
              'Stop
              xChar2 = Replace(Replace(Replace(Replace(Replace(xChar2, _
                       ReGPlace1, AppPathW, , , vbBinaryCompare), _
                       ReGPlace2, WinPathW, , , vbBinaryCompare), _
                       ReGPlace3, SysPathW, , , vbBinaryCompare), _
                       ReGPlace4, TempPathW, , , vbBinaryCompare), _
                       ReGPlace5, ProgPathW, , , vbBinaryCompare)
              'Stop
              Call RegSetValueExData(xKeyLong2, xChar1, xLong3, xChar2)
            End Select
          End If
        ElseIf Not xKeyLong2 = 0& Then
'        Debug.Print "delete"
'Stop
        Call RegDeleteValue(xKeyLong2, xChar1)
        End If
      Else
      If Not xKeyLong2 = 0& Then
        Call RegCloseKey(xKeyLong2)
        xKeyLong2 = 0&
        End If
      
      xLong3 = (xLong3 And &HFFFFFF) Or &H80000000

      Select Case xLong2
        Case 1&
          xKeyLong2 = 0&
'          Stop
          Call RegCreateKeyEx(xLong3, xChar1, xKeyLong2)
        Case 2&, 5&
          xKeyLong2 = 0&
'          Stop
          If RegOpenKeyEx(xLong3, xChar1, 2&, xKeyLong2) Then
            If xLong2 = 5& And Not xKeyLong2 = 0& Then
              Call RegDeleteValuesEx(xKeyLong2)
              End If
            End If
        Case 3&, 4&
'          Stop
          Call RegDeleteKeysRecursive(xLong3, xChar1, CBool(xLong2 - 3&))
'          Stop
        Case Else
          Exit Function
        End Select
      End If
    
    If Not ProgressControl = 0& Then
      Call ctProgressB_SetValue(ProgressControl, (ProgressStart + xByteA1_Pos / xByteA1_Size * ProgressQueue), ProgressTotal)
      'ctProgressB_SetValue ProgressControl, ProgressStart / ProgressTotal
      End If
    
    Loop
  
  If Not xKeyLong2 = 0& Then
    Call RegCloseKey(xKeyLong2)
    End If
  ReDim xByteA1(0&)
  End Function



Private Sub RegDeleteValuesEx(ByVal OpenKey As Long)
  Dim xChar1 As String
  Dim xLong1 As Long
  Dim xLong2 As Long
  Dim xLong3 As Long

  Call RegDeleteValue(OpenKey, xChar1)
  Do
    xChar1 = String(512&, vbNullChar)
    xLong2 = 512&
    xLong3 = RegEnumValue(OpenKey, xLong1, xChar1)
    Select Case xLong3
      Case 259&
        Call RegDeleteValue(OpenKey, xChar1)
        xChar1 = ""
        Call RegDeleteValue(OpenKey, xChar1)
        Exit Do
      Case 0&
        Call RegDeleteValue(OpenKey, xChar1)
        xLong1 = xLong1 + 1&
      Case Else
        Exit Do
      End Select
    Loop
  End Sub


Public Function RegDeleteKeysRecursive(ByVal StartKey As Long, ByVal SubKey As String, ByVal NoDeleteMain As Boolean) As Long
  Dim xChar1 As String
  Dim xLong1 As Long
  Dim xLong2 As Long
  'Dim xLong3 As Long

  If Not Len(SubKey) = 0& Then
'    Debug.Print "Process: ", Hex(StartKey), SubKey
    If RegOpenKeyEx(StartKey, SubKey, &HA&, xLong1) Then
      Do
        If RegEnumKey(xLong1, xLong2, xChar1) Then
          Call RegDeleteKeysRecursive(xLong1, xChar1, False)
          xLong2 = xLong2 + 1&
          Else
          Exit Do
          End If
        Loop
      If NoDeleteMain Then
        RegDeleteKeysRecursive = xLong1 'Key
        Else
        'Call RegDeleteKeyA(StartKey, SubKey)
        Call RegCloseKey(xLong1) ' Key)
        Call RegDeleteKey(StartKey, SubKey)
        End If
      End If
    End If
End Function

Private Sub GetXPAccess()
  Dim xLong1 As Long
  Dim xLong2 As Long
  Dim xType1 As OSVERSIONINFO
  Dim xType2 As TOKEN_PRIVILEGES
  Dim xType3 As TOKEN_PRIVILEGES
  
  xType1.dwOSVersionInfoSize = Len(xType1)
  If Not GetVersionExA(xType1) = 0& Then
    If (xType1.dwPlatformId = &H2&) Then
      If OpenProcessToken(GetCurrentProcess(), 40&, xLong2) Then
        xLong1 = LookupPrivilegeValueA(vbNullString, "SeTakeOwnershipPrivilege", xType2.Privileges(0).pLuid)
        xType2.PrivilegeCount = 1&
        xType2.Privileges(0).Attributes = 2&
        Call AdjustTokenPrivileges(xLong2, 0&, xType2, LenB(xType3), xType3, xLong1)
        End If
      End If
    End If
  End Sub

Private Function GetNum(ByVal xLen As Long) As Long
  Call RtlMoveMemory(ByVal VarPtr(GetNum), ByVal VarPtr(xByteA1(xByteA1_Pos)), xLen)
  xByteA1_Pos = xByteA1_Pos + xLen
  End Function

Private Function ReadDyn(ByVal rType As Long, ByVal xLen As Long) As String
  ReadDyn = String(xLen, vbNullChar)
  If rType = 0& Then
    Call RtlMoveMemory(ByVal ReadDyn, ByVal VarPtr(xByteA1(xByteA1_Pos)), xLen)
    Else
    xLen = xLen + xLen
    Call RtlMoveMemory(ByVal StrPtr(ReadDyn), ByVal VarPtr(xByteA1(xByteA1_Pos)), xLen)
    End If
  xByteA1_Pos = xByteA1_Pos + xLen
  End Function

Private Sub MkWide(ByVal xDef As String, ByRef xWide As String)
  Dim xLong1 As Long
  
  For xLong1 = 1& To Len(xDef)
    xWide = xWide + Mid(xDef, xLong1, 1&) + vbNullChar
    Next
  End Sub
